/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.ui;

public class RestResponse<T> {
    private T payload;
    private boolean success;
    private String msg;
    private int code = -1;
    private long timestamp = System.currentTimeMillis() / 1000L;

    public RestResponse() {
    }

    public RestResponse(boolean success) {
        this.success = success;
    }

    public RestResponse(boolean success, T payload) {
        this.success = success;
        this.payload = payload;
    }

    public RestResponse(boolean success, T payload, int code) {
        this.success = success;
        this.payload = payload;
        this.code = code;
    }

    public RestResponse(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public RestResponse(boolean success, String msg, int code) {
        this.success = success;
        this.msg = msg;
        this.code = code;
    }

    public T getPayload() {
        return this.payload;
    }

    public void setPayload(T payload) {
        this.payload = payload;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public static RestResponse ok() {
        return new RestResponse(true);
    }

    public static <T> RestResponse ok(T payload) {
        return new RestResponse<T>(true, payload);
    }

    public static <T> RestResponse ok(int code) {
        return new RestResponse<T>(true, null, code);
    }

    public static <T> RestResponse ok(T payload, int code) {
        return new RestResponse<T>(true, payload, code);
    }

    public static RestResponse fail() {
        return new RestResponse(false);
    }

    public static RestResponse fail(String msg) {
        return new RestResponse(false, msg);
    }

    public static RestResponse fail(int code) {
        return new RestResponse(false, null, code);
    }

    public static RestResponse fail(int code, String msg) {
        return new RestResponse(false, msg, code);
    }
}

