/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class AsmKit {
    private static final Map<Method, String[]> pool = new ConcurrentHashMap<Method, String[]>();

    private static boolean sameType(Type[] types, Class<?>[] clazzes) {
        if (types.length != clazzes.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (Type.getType(clazzes[i]).equals(types[i])) continue;
            return false;
        }
        return true;
    }

    public static String[] getMethodParamNames(final Method m) throws IOException {
        if (pool.containsKey(m)) {
            return pool.get(m);
        }
        final String[] paramNames = new String[m.getParameterTypes().length];
        String n = m.getDeclaringClass().getName();
        ClassReader cr = null;
        try {
            cr = new ClassReader(n);
        }
        catch (IOException e) {
            return null;
        }
        cr.accept(new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Type[] args = Type.getArgumentTypes(desc);
                if (!name.equals(m.getName()) || !AsmKit.sameType(args, m.getParameterTypes())) {
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                MethodVisitor v = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, v){

                    @Override
                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        int i = index - 1;
                        if (Modifier.isStatic(m.getModifiers())) {
                            i = index;
                        }
                        if (i >= 0 && i < paramNames.length) {
                            paramNames[i] = name;
                        }
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }
                };
            }
        }, 0);
        pool.put(m, paramNames);
        return paramNames;
    }
}

