/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.pem;

import com.auth0.jwt.internal.org.apache.commons.lang3.Validate;
import com.auth0.jwt.pem.PemFileWriter;
import java.io.IOException;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class PemWriter {
    public static void writePrivateKey(RSAPrivateKey privateKey, String description, String filename) throws IOException {
        Validate.notNull(privateKey);
        Validate.notNull(filename);
        PemWriter.writePemFile(privateKey, description, filename);
    }

    public static void writePublicKey(RSAPublicKey publicKey, String description, String filename) throws IOException {
        Validate.notNull(publicKey);
        Validate.notNull(filename);
        PemWriter.writePemFile(publicKey, description, filename);
    }

    public static void writePemFile(Key key, String description, String filename) throws IOException {
        Validate.notNull(key);
        Validate.notNull(filename);
        PemFileWriter pemFileWriter = new PemFileWriter(key, description);
        pemFileWriter.write(filename);
    }
}

