/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.version;

import com.aoindustries.lang.NullArgumentException;

public final class Version {
    private final int major;
    private final int minor;
    private final int release;
    private final int build;

    public static Version getInstance(int major, int minor, int release, int build) {
        return new Version(major, minor, release, build);
    }

    public static Version valueOf(String version) throws IllegalArgumentException {
        NullArgumentException.checkNotNull((Object)version, (String)"version");
        int dot1Pos = version.indexOf(46);
        if (dot1Pos == -1) {
            throw new IllegalArgumentException(version);
        }
        int dot2Pos = version.indexOf(46, dot1Pos + 1);
        if (dot2Pos == -1) {
            throw new IllegalArgumentException(version);
        }
        int dot3Pos = version.indexOf(46, dot2Pos + 1);
        if (dot3Pos == -1) {
            throw new IllegalArgumentException(version);
        }
        return Version.getInstance(Integer.parseInt(version.substring(0, dot1Pos)), Integer.parseInt(version.substring(dot1Pos + 1, dot2Pos)), Integer.parseInt(version.substring(dot2Pos + 1, dot3Pos)), Integer.parseInt(version.substring(dot3Pos + 1)));
    }

    private Version(int major, int minor, int release, int build) {
        this.major = major;
        this.minor = minor;
        this.release = release;
        this.build = build;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.release + "." + this.build;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this.build == other.build && this.release == other.release && this.minor == other.minor && this.major == other.major;
    }

    public int hashCode() {
        int hash = this.major;
        hash = hash * 31 + this.minor;
        hash = hash * 31 + this.release;
        hash = hash * 31 + this.build;
        return hash;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRelease() {
        return this.release;
    }

    public int getBuild() {
        return this.build;
    }
}

