/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.version;

import com.aoindustries.util.PropertiesUtils;
import com.aoindustries.version.ApplicationResources;
import com.aoindustries.version.Version;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesVersions {
    private final Properties properties;

    private static Properties readProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        return props;
    }

    public PropertiesVersions(Class<?> clazz, String resource) throws IOException {
        this(PropertiesUtils.loadFromResource(clazz, (String)resource));
    }

    public PropertiesVersions(InputStream in) throws IOException {
        this(PropertiesVersions.readProperties(in));
    }

    public PropertiesVersions(Properties properties) {
        this.properties = properties;
    }

    public Version getVersion(String product) throws IllegalArgumentException {
        String three = this.properties.getProperty(product);
        if (three == null) {
            throw new IllegalArgumentException(ApplicationResources.accessor.getMessage("PropertiesVersions.getVersion.productNotFound", new Object[]{product}));
        }
        return Version.valueOf(three + "." + this.getBuild());
    }

    public int getBuild() throws IllegalArgumentException {
        String build = this.properties.getProperty("build.number");
        if (build == null) {
            throw new IllegalArgumentException(ApplicationResources.accessor.getMessage("PropertiesVersions.getVersion.buildNotFound"));
        }
        return Integer.parseInt(build);
    }
}

