/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseComparisonSortAlgorithm;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

public final class ShellSort
extends BaseComparisonSortAlgorithm<Object> {
    private static final ShellSort instance = new ShellSort();

    public static ShellSort getInstance() {
        return instance;
    }

    private ShellSort() {
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        int h = 1;
        int length = list.size();
        while (h * 3 + 1 < length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < length; ++i) {
                int j;
                T B = ShellSort.get(list, i, stats);
                for (j = i; j >= h && ShellSort.compare(ShellSort.get(list, j - h, stats), B, comparator, stats) > 0; j -= h) {
                    ShellSort.set(list, j, ShellSort.get(list, j - h, stats), stats);
                }
                ShellSort.set(list, j, B, stats);
            }
            h /= 3;
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        int h = 1;
        int length = array.length;
        while (h * 3 + 1 < length) {
            h = 3 * h + 1;
        }
        while (h > 0) {
            for (int i = h - 1; i < length; ++i) {
                int j;
                T B = ShellSort.get(array, i, stats);
                for (j = i; j >= h && ShellSort.compare(ShellSort.get(array, j - h, stats), B, comparator, stats) > 0; j -= h) {
                    ShellSort.set(array, j, ShellSort.get(array, j - h, stats), stats);
                }
                ShellSort.set(array, j, B, stats);
            }
            h /= 3;
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }
}

