/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseComparisonSortAlgorithm;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

public final class QubbleSort
extends BaseComparisonSortAlgorithm<Object> {
    private static final QubbleSort instance = new QubbleSort();

    public static QubbleSort getInstance() {
        return instance;
    }

    private QubbleSort() {
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        QubbleSort.sort(list, 0, list.size() - 1, comparator, stats);
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        QubbleSort.sort(array, 0, array.length - 1, comparator, stats);
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public boolean isStable() {
        return false;
    }

    private static <T> void sort(List<T> list, int lo0, int hi0, Comparator<? super T> comparator, SortStatistics stats) {
        int hi = hi0;
        int lo = lo0;
        if (hi - lo <= 6) {
            if (stats != null) {
                stats.sortRecursing();
            }
            QubbleSort.bsort(list, lo, hi, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
            return;
        }
        T pivot = QubbleSort.get(list, (lo + hi) / 2, stats);
        QubbleSort.set(list, (lo + hi) / 2, QubbleSort.get(list, hi, stats), stats);
        QubbleSort.set(list, hi, pivot, stats);
        while (lo < hi) {
            while (QubbleSort.compare(QubbleSort.get(list, lo, stats), pivot, comparator, stats) <= 0 && lo < hi) {
                ++lo;
            }
            while (QubbleSort.compare(pivot, QubbleSort.get(list, hi, stats), comparator, stats) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            QubbleSort.swap(list, hi, lo, stats);
        }
        QubbleSort.set(list, hi0, QubbleSort.get(list, hi, stats), stats);
        QubbleSort.set(list, hi, pivot, stats);
        if (stats != null) {
            stats.sortRecursing();
        }
        QubbleSort.sort(list, lo0, lo - 1, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
        if (stats != null) {
            stats.sortRecursing();
        }
        QubbleSort.sort(list, hi + 1, hi0, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
    }

    private static <T> void sort(T[] array, int lo0, int hi0, Comparator<? super T> comparator, SortStatistics stats) {
        int hi = hi0;
        int lo = lo0;
        if (hi - lo <= 6) {
            if (stats != null) {
                stats.sortRecursing();
            }
            QubbleSort.bsort(array, lo, hi, comparator, stats);
            if (stats != null) {
                stats.sortUnrecursing();
            }
            return;
        }
        T pivot = QubbleSort.get(array, (lo + hi) / 2, stats);
        QubbleSort.set(array, (lo + hi) / 2, QubbleSort.get(array, hi, stats), stats);
        QubbleSort.set(array, hi, pivot, stats);
        while (lo < hi) {
            while (QubbleSort.compare(QubbleSort.get(array, lo, stats), pivot, comparator, stats) <= 0 && lo < hi) {
                ++lo;
            }
            while (QubbleSort.compare(pivot, QubbleSort.get(array, hi, stats), comparator, stats) <= 0 && lo < hi) {
                --hi;
            }
            if (lo >= hi) continue;
            QubbleSort.swap(array, hi, lo, stats);
        }
        QubbleSort.set(array, hi0, QubbleSort.get(array, hi, stats), stats);
        QubbleSort.set(array, hi, pivot, stats);
        if (stats != null) {
            stats.sortRecursing();
        }
        QubbleSort.sort(array, lo0, lo - 1, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
        if (stats != null) {
            stats.sortRecursing();
        }
        QubbleSort.sort(array, hi + 1, hi0, comparator, stats);
        if (stats != null) {
            stats.sortUnrecursing();
        }
    }

    static <T> void bsort(List<T> list, int lo, int hi, Comparator<? super T> comparator, SortStatistics stats) {
        for (int j = hi; j > lo; --j) {
            for (int i = lo; i < j; ++i) {
                T O2;
                T O1 = QubbleSort.get(list, i, stats);
                if (QubbleSort.compare(O1, O2 = QubbleSort.get(list, i + 1, stats), comparator, stats) <= 0) continue;
                QubbleSort.set(list, i + 1, O1, stats);
                QubbleSort.set(list, i, O2, stats);
            }
        }
    }

    static <T> void bsort(T[] array, int lo, int hi, Comparator<? super T> comparator, SortStatistics stats) {
        for (int j = hi; j > lo; --j) {
            for (int i = lo; i < j; ++i) {
                T O2;
                T O1 = QubbleSort.get(array, i, stats);
                if (QubbleSort.compare(O1, O2 = QubbleSort.get(array, i + 1, stats), comparator, stats) <= 0) continue;
                QubbleSort.set(array, i + 1, O1, stats);
                QubbleSort.set(array, i, O2, stats);
            }
        }
    }
}

