/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.lang.RuntimeUtils;
import com.aoindustries.util.AtomicSequence;
import com.aoindustries.util.IntList;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.WrappedException;
import com.aoindustries.util.sort.BaseIntegerSortAlgorithm;
import com.aoindustries.util.sort.IntValueComparator;
import com.aoindustries.util.sort.SortStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public final class IntegerRadixSort
extends BaseIntegerSortAlgorithm {
    private static final int BITS_PER_PASS = 8;
    private static final int PASS_SIZE = 256;
    private static final int PASS_MASK = 255;
    private static final int MIN_RADIX_SORT_SIZE = 2048;
    private static final int MINIMUM_START_QUEUE_LENGTH = 16;
    private static final int MIN_CONCURRENCY_SIZE = 65536;
    private static final int MIN_CONCURRENCY_PROCESSORS = 2;
    private static final int TASKS_PER_PROCESSOR = 2;
    private static final ExecutorService defaultExecutor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final Sequence idSequence = new AtomicSequence();

        @Override
        public Thread newThread(Runnable target) {
            long id = this.idSequence.getNextSequenceValue();
            return new Thread(target, IntegerRadixSort.class.getName() + ".defaultExecutor: id=" + id);
        }
    });
    private static final IntegerRadixSort defaultInstance = new IntegerRadixSort(defaultExecutor);
    private static final IntegerRadixSort singleThreadedInstance = new IntegerRadixSort(null);
    private final ExecutorService executor;

    public static IntegerRadixSort getInstance() {
        return defaultInstance;
    }

    public static IntegerRadixSort getSingleThreadedInstance() {
        return singleThreadedInstance;
    }

    public static IntegerRadixSort getInstance(ExecutorService executor) {
        return executor == null ? singleThreadedInstance : new IntegerRadixSort(executor);
    }

    private static void waitForAll(Iterable<? extends Future<?>> futures) throws InterruptedException, ExecutionException {
        for (Future<?> future : futures) {
            future.get();
        }
    }

    private IntegerRadixSort(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static <T extends RadixTable> void radixSort(int size, final T table, final Source<? super T> source, ExecutorService executor) {
        try {
            int fromQueueStart;
            int fromTaskNum;
            int fromQueueNum;
            int taskTotalLength;
            int sizePerTask;
            ArrayList runnableFutures;
            int numTasks = table.numTasks;
            if (executor == null) {
                assert (numTasks == 1) : "Must have an executor when numTasks != 1";
                runnableFutures = null;
                sizePerTask = size;
            } else {
                assert (numTasks >= 2) : "Must not have an executor when numTasks < 2";
                runnableFutures = new ArrayList(numTasks);
                int spt = size / numTasks;
                if (spt * numTasks < size) {
                    ++spt;
                }
                sizePerTask = spt;
            }
            int bitsSeen = 0;
            int bitsNotSeen = 0;
            if (executor != null && source.useRandomAccess()) {
                ArrayList<Future<Source.ImportDataResult>> importStepFutures = new ArrayList<Future<Source.ImportDataResult>>(numTasks);
                boolean bl = false;
                for (int taskStart = 0; taskStart < size; taskStart += sizePerTask) {
                    void var11_17;
                    int taskEnd = taskStart + sizePerTask;
                    if (taskEnd > size) {
                        taskEnd = size;
                    }
                    final int finalTaskStart = taskStart;
                    final int finalTaskEnd = taskEnd;
                    void finalToTaskNum = var11_17++;
                    importStepFutures.add(executor.submit(new Callable<Source.ImportDataResult>((int)finalToTaskNum){
                        final /* synthetic */ int val$finalToTaskNum;
                        {
                            this.val$finalToTaskNum = n3;
                        }

                        @Override
                        public Source.ImportDataResult call() {
                            return source.importData(table, finalTaskStart, finalTaskEnd, this.val$finalToTaskNum);
                        }
                    }));
                }
                for (Future future : importStepFutures) {
                    Source.ImportDataResult result = (Source.ImportDataResult)future.get();
                    bitsSeen |= result.bitsSeen;
                    bitsNotSeen |= result.bitsNotSeen;
                }
            } else {
                Source.ImportDataResult result = source.importData(table, 0, size, 0);
                bitsSeen |= result.bitsSeen;
                bitsNotSeen |= result.bitsNotSeen;
            }
            bitsNotSeen ^= 0xFFFFFFFF;
            table.swapQueues();
            int lastShiftUsed = 0;
            for (int shift = 8; shift < 32; shift += 8) {
                int n;
                if ((bitsSeen >>> shift & 0xFF) == (bitsNotSeen >>> shift & 0xFF)) continue;
                lastShiftUsed = shift;
                if (executor != null) {
                    n = shift;
                    int toTaskNum = 0;
                    int taskFromQueueStart = 0;
                    taskTotalLength = 0;
                    for (fromQueueNum = 0; fromQueueNum < 256; ++fromQueueNum) {
                        for (fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                            taskTotalLength += table.getFromQueueLength(fromTaskNum, fromQueueNum);
                        }
                        if (taskTotalLength <= 0 || taskTotalLength < sizePerTask && fromQueueNum != 255) continue;
                        final int finalToTaskNum = toTaskNum;
                        final int finalTaskFromQueueStart = taskFromQueueStart;
                        final int taskFromQueueEnd = fromQueueNum + 1;
                        assert (runnableFutures != null);
                        runnableFutures.add(executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                for (int fromQueueNum = finalTaskFromQueueStart; fromQueueNum < taskFromQueueEnd; ++fromQueueNum) {
                                    table.gatherScatter(n, fromQueueNum, finalToTaskNum);
                                }
                            }
                        }));
                        ++toTaskNum;
                        taskFromQueueStart = taskFromQueueEnd;
                        taskTotalLength = 0;
                    }
                    assert (runnableFutures != null);
                    IntegerRadixSort.waitForAll(runnableFutures);
                    runnableFutures.clear();
                } else {
                    for (n = 0; n < 256; ++n) {
                        table.gatherScatter(shift, n, 0);
                    }
                }
                table.swapQueues();
            }
            int n = fromQueueStart = lastShiftUsed + 8 == 32 ? 128 : 0;
            if (executor != null && source.useRandomAccess()) {
                int n2 = fromQueueStart - 1 & 0xFF;
                int taskFromQueueStart = fromQueueStart;
                int taskOutIndex = 0;
                taskTotalLength = 0;
                fromQueueNum = fromQueueStart;
                do {
                    for (fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                        taskTotalLength += table.getFromQueueLength(fromTaskNum, fromQueueNum);
                    }
                    if (taskTotalLength <= 0 || taskTotalLength < sizePerTask && fromQueueNum != n2) continue;
                    final int finalTaskFromQueueStart = taskFromQueueStart;
                    final int finalTaskOutIndex = taskOutIndex;
                    final int finalTaskFromQueueEnd = fromQueueNum + 1 & 0xFF;
                    assert (runnableFutures != null);
                    runnableFutures.add(executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            source.exportData(table, finalTaskFromQueueStart, finalTaskFromQueueEnd, finalTaskOutIndex);
                        }
                    }));
                    taskFromQueueStart = finalTaskFromQueueEnd;
                    taskOutIndex += taskTotalLength;
                    taskTotalLength = 0;
                } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueStart);
                IntegerRadixSort.waitForAll(runnableFutures);
            } else {
                source.exportData(table, fromQueueStart, fromQueueStart, 0);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrappedException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    public <N extends Number> void sort(List<N> list, SortStatistics stats) {
        if (list instanceof IntList) {
            this.sort((IntList)list);
        } else {
            int size;
            if (stats != null) {
                stats.sortStarting();
            }
            if ((size = list.size()) < 2048) {
                if (stats != null) {
                    stats.sortSwitchingAlgorithms();
                }
                Collections.sort(list, IntValueComparator.getInstance());
            } else {
                int numProcessors;
                if (stats != null) {
                    stats.sortGetting(size);
                    stats.sortSetting(size);
                }
                if (this.executor == null || size < 65536 || (numProcessors = RuntimeUtils.getAvailableProcessors()) < 2) {
                    IntegerRadixSort.radixSort(size, new SingleTaskNumberRadixTable(size), new NumberListSource<N>(size, list), null);
                } else {
                    IntegerRadixSort.radixSort(size, new MultiTaskNumberRadixTable(size, numProcessors * 2), new NumberListSource<N>(size, list), this.executor);
                }
            }
            if (stats != null) {
                stats.sortEnding();
            }
        }
    }

    @Override
    public <N extends Number> void sort(N[] array, SortStatistics stats) {
        int size;
        if (stats != null) {
            stats.sortStarting();
        }
        if ((size = array.length) < 2048) {
            if (stats != null) {
                stats.sortSwitchingAlgorithms();
            }
            Arrays.sort(array, IntValueComparator.getInstance());
        } else {
            int numProcessors;
            if (stats != null) {
                stats.sortGetting(size);
                stats.sortSetting(size);
            }
            if (this.executor == null || size < 65536 || (numProcessors = RuntimeUtils.getAvailableProcessors()) < 2) {
                IntegerRadixSort.radixSort(size, new SingleTaskNumberRadixTable(size), new NumberArraySource(size, array), null);
            } else {
                IntegerRadixSort.radixSort(size, new MultiTaskNumberRadixTable(size, numProcessors * 2), new NumberArraySource(size, array), this.executor);
            }
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public void sort(IntList list, SortStatistics stats) {
        int size;
        if (stats != null) {
            stats.sortStarting();
        }
        if ((size = list.size()) < 2048) {
            if (stats != null) {
                stats.sortSwitchingAlgorithms();
            }
            Collections.sort(list, IntValueComparator.getInstance());
        } else {
            int numProcessors;
            if (stats != null) {
                stats.sortGetting(size);
                stats.sortSetting(size);
            }
            if (this.executor == null || size < 65536 || (numProcessors = RuntimeUtils.getAvailableProcessors()) < 2) {
                IntegerRadixSort.radixSort(size, new SingleTaskIntRadixTable(size), new IntListSource(size, list), null);
            } else {
                IntegerRadixSort.radixSort(size, new MultiTaskIntRadixTable(size, numProcessors * 2), new IntListSource(size, list), this.executor);
            }
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public void sort(int[] array, SortStatistics stats) {
        int size;
        if (stats != null) {
            stats.sortStarting();
        }
        if ((size = array.length) < 2048) {
            if (stats != null) {
                stats.sortSwitchingAlgorithms();
            }
            Arrays.sort(array);
        } else {
            int numProcessors;
            if (stats != null) {
                stats.sortGetting(size);
                stats.sortSetting(size);
            }
            if (this.executor == null || size < 65536 || (numProcessors = RuntimeUtils.getAvailableProcessors()) < 2) {
                IntegerRadixSort.radixSort(size, new SingleTaskIntRadixTable(size), new IntArraySource(size, array), null);
            } else {
                IntegerRadixSort.radixSort(size, new MultiTaskIntRadixTable(size, numProcessors * 2), new IntArraySource(size, array), this.executor);
            }
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    static class IntArraySource
    extends Source<IntRadixTable> {
        private final int size;
        private final int[] array;

        IntArraySource(int size, int[] array) {
            this.size = size;
            this.array = array;
        }

        @Override
        final boolean useRandomAccess() {
            return true;
        }

        @Override
        final Source.ImportDataResult importData(IntRadixTable table, int start, int end, int toTaskNum) {
            int bSeen = 0;
            int bNotSeen = 0;
            for (int i = start; i < end; ++i) {
                int numInt = table.addToQueue(0, this.array[i], toTaskNum);
                bSeen |= numInt;
                bNotSeen |= ~numInt;
            }
            return new Source.ImportDataResult(bSeen, bNotSeen);
        }

        @Override
        final void exportData(IntRadixTable table, int fromQueueStart, int fromQueueEnd, int start) {
            int numTasks = table.numTasks;
            int fromQueueNum = fromQueueStart;
            int outIndex = start;
            do {
                for (int fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                    int[] fromQueue = table.getFromQueue(fromTaskNum, fromQueueNum);
                    if (fromQueue == null) continue;
                    int length = table.getFromQueueLength(fromTaskNum, fromQueueNum);
                    System.arraycopy(fromQueue, 0, this.array, outIndex, length);
                    outIndex += length;
                }
            } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueEnd);
        }
    }

    static class IntListSource
    extends Source<IntRadixTable> {
        private final int size;
        private final IntList list;
        private final boolean useRandomAccess;

        IntListSource(int size, IntList list) {
            this.size = size;
            this.list = list;
            this.useRandomAccess = size < Integer.MAX_VALUE && list instanceof RandomAccess;
        }

        @Override
        final boolean useRandomAccess() {
            return this.useRandomAccess;
        }

        @Override
        final Source.ImportDataResult importData(IntRadixTable table, int start, int end, int toTaskNum) {
            int bSeen = 0;
            int bNotSeen = 0;
            if (this.useRandomAccess) {
                for (int i = start; i < end; ++i) {
                    int numInt = table.addToQueue(0, this.list.getInt(i), toTaskNum);
                    bSeen |= numInt;
                    bNotSeen |= ~numInt;
                }
            } else {
                assert (start == 0 && end == this.size) : "Must import all in a single pass for iterator method";
                Iterator iterator = this.list.iterator();
                while (iterator.hasNext()) {
                    int number = (Integer)iterator.next();
                    int numInt = table.addToQueue(0, number, toTaskNum);
                    bSeen |= numInt;
                    bNotSeen |= ~numInt;
                }
            }
            return new Source.ImportDataResult(bSeen, bNotSeen);
        }

        @Override
        final void exportData(IntRadixTable table, int fromQueueStart, int fromQueueEnd, int start) {
            int numTasks = table.numTasks;
            int fromQueueNum = fromQueueStart;
            if (this.useRandomAccess) {
                int outIndex = start;
                do {
                    for (int fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                        int[] fromQueue = table.getFromQueue(fromTaskNum, fromQueueNum);
                        if (fromQueue == null) continue;
                        int length = table.getFromQueueLength(fromTaskNum, fromQueueNum);
                        for (int j = 0; j < length; ++j) {
                            this.list.set(outIndex++, fromQueue[j]);
                        }
                    }
                } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueEnd);
            } else {
                assert (start == 0) : "Must import all in a single pass for iterator method";
                ListIterator<Integer> iterator = this.list.listIterator();
                do {
                    for (int fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                        int[] fromQueue = table.getFromQueue(fromTaskNum, fromQueueNum);
                        if (fromQueue == null) continue;
                        int length = table.getFromQueueLength(fromTaskNum, fromQueueNum);
                        for (int j = 0; j < length; ++j) {
                            iterator.next();
                            iterator.set(fromQueue[j]);
                        }
                    }
                } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueEnd);
            }
        }
    }

    static class NumberArraySource<N extends Number>
    extends Source<NumberRadixTable<N>> {
        private final int size;
        private final N[] array;

        NumberArraySource(int size, N[] array) {
            this.size = size;
            this.array = array;
        }

        @Override
        final boolean useRandomAccess() {
            return true;
        }

        @Override
        final Source.ImportDataResult importData(NumberRadixTable<N> table, int start, int end, int toTaskNum) {
            int bSeen = 0;
            int bNotSeen = 0;
            for (int i = start; i < end; ++i) {
                int numInt = table.addToQueue(0, this.array[i], toTaskNum);
                bSeen |= numInt;
                bNotSeen |= ~numInt;
            }
            return new Source.ImportDataResult(bSeen, bNotSeen);
        }

        @Override
        final void exportData(NumberRadixTable<N> table, int fromQueueStart, int fromQueueEnd, int start) {
            int numTasks = table.numTasks;
            int fromQueueNum = fromQueueStart;
            int outIndex = start;
            do {
                for (int fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                    Number[] fromQueue = table.getFromQueue(fromTaskNum, fromQueueNum);
                    if (fromQueue == null) continue;
                    int length = table.getFromQueueLength(fromTaskNum, fromQueueNum);
                    System.arraycopy(fromQueue, 0, this.array, outIndex, length);
                    outIndex += length;
                }
            } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueEnd);
        }
    }

    static class NumberListSource<N extends Number>
    extends Source<NumberRadixTable<N>> {
        private final int size;
        private final List<N> list;
        private final boolean useRandomAccess;

        NumberListSource(int size, List<N> list) {
            this.size = size;
            this.list = list;
            this.useRandomAccess = size < Integer.MAX_VALUE && list instanceof RandomAccess;
        }

        @Override
        final boolean useRandomAccess() {
            return this.useRandomAccess;
        }

        @Override
        final Source.ImportDataResult importData(NumberRadixTable<N> table, int start, int end, int toTaskNum) {
            int bSeen = 0;
            int bNotSeen = 0;
            if (this.useRandomAccess) {
                for (int i = start; i < end; ++i) {
                    int numInt = table.addToQueue(0, (Number)this.list.get(i), toTaskNum);
                    bSeen |= numInt;
                    bNotSeen |= ~numInt;
                }
            } else {
                assert (start == 0 && end == this.size) : "Must import all in a single pass for iterator method";
                for (Number number : this.list) {
                    int numInt = table.addToQueue(0, number, toTaskNum);
                    bSeen |= numInt;
                    bNotSeen |= ~numInt;
                }
            }
            return new Source.ImportDataResult(bSeen, bNotSeen);
        }

        @Override
        final void exportData(NumberRadixTable<N> table, int fromQueueStart, int fromQueueEnd, int start) {
            int numTasks = table.numTasks;
            int fromQueueNum = fromQueueStart;
            if (this.useRandomAccess) {
                int outIndex = start;
                do {
                    for (int fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                        Number[] fromQueue = table.getFromQueue(fromTaskNum, fromQueueNum);
                        if (fromQueue == null) continue;
                        int length = table.getFromQueueLength(fromTaskNum, fromQueueNum);
                        for (int j = 0; j < length; ++j) {
                            this.list.set(outIndex++, fromQueue[j]);
                        }
                    }
                } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueEnd);
            } else {
                assert (start == 0) : "Must import all in a single pass for iterator method";
                ListIterator<N> iterator = this.list.listIterator();
                do {
                    for (int fromTaskNum = 0; fromTaskNum < numTasks; ++fromTaskNum) {
                        Number[] fromQueue = table.getFromQueue(fromTaskNum, fromQueueNum);
                        if (fromQueue == null) continue;
                        int length = table.getFromQueueLength(fromTaskNum, fromQueueNum);
                        for (int j = 0; j < length; ++j) {
                            iterator.next();
                            iterator.set(fromQueue[j]);
                        }
                    }
                } while ((fromQueueNum = fromQueueNum + 1 & 0xFF) != fromQueueEnd);
            }
        }
    }

    static abstract class Source<T extends RadixTable> {
        Source() {
        }

        abstract boolean useRandomAccess();

        abstract ImportDataResult importData(T var1, int var2, int var3, int var4);

        abstract void exportData(T var1, int var2, int var3, int var4);

        static final class ImportDataResult {
            final int bitsSeen;
            final int bitsNotSeen;

            ImportDataResult(int bitsSeen, int bitsNotSeen) {
                this.bitsSeen = bitsSeen;
                this.bitsNotSeen = bitsNotSeen;
            }
        }
    }

    static class MultiTaskIntRadixTable
    extends IntRadixTable {
        int[][][] fromQueues;
        int[][] fromQueueLengths;
        int[][][] toQueues;
        int[][] toQueueLengths;

        MultiTaskIntRadixTable(int size, int numTasks) {
            super(size, numTasks);
            this.fromQueues = new int[numTasks][256][];
            this.fromQueueLengths = new int[numTasks][256];
            this.toQueues = new int[numTasks][256][];
            this.toQueueLengths = new int[numTasks][256];
        }

        @Override
        final void swapQueues() {
            int[][][] temp = this.fromQueues;
            this.fromQueues = this.toQueues;
            this.toQueues = temp;
            int[][] tempLengths = this.fromQueueLengths;
            this.fromQueueLengths = this.toQueueLengths;
            this.toQueueLengths = tempLengths;
        }

        private int addToQueue(int shift, int number, int[][] taskToQueues, int[] taskToQueueLengths) {
            int toQueueNum = number >>> shift & 0xFF;
            int[] toQueue = taskToQueues[toQueueNum];
            int toQueueLength = taskToQueueLengths[toQueueNum];
            if (toQueue == null) {
                int[] newQueue = new int[this.startQueueLength];
                toQueue = newQueue;
                taskToQueues[toQueueNum] = newQueue;
            } else if (toQueueLength >= toQueue.length) {
                int[] newQueue = new int[toQueueLength << 1];
                System.arraycopy(toQueue, 0, newQueue, 0, toQueueLength);
                toQueue = newQueue;
                taskToQueues[toQueueNum] = newQueue;
            }
            toQueue[toQueueLength++] = number;
            taskToQueueLengths[toQueueNum] = toQueueLength;
            return number;
        }

        @Override
        final void gatherScatter(int shift, int fromQueueNum, int toTaskNum) {
            for (int fromTaskNum = 0; fromTaskNum < this.numTasks; ++fromTaskNum) {
                int[][] taskFromQueues = this.fromQueues[fromTaskNum];
                int[] fromQueue = taskFromQueues[fromQueueNum];
                if (fromQueue == null) continue;
                int[] taskFromQueueLengths = this.fromQueueLengths[fromTaskNum];
                int[][] taskToQueues = this.toQueues[toTaskNum];
                int[] taskToQueueLengths = this.toQueueLengths[toTaskNum];
                int length = taskFromQueueLengths[fromQueueNum];
                for (int j = 0; j < length; ++j) {
                    this.addToQueue(shift, fromQueue[j], taskToQueues, taskToQueueLengths);
                }
                taskFromQueueLengths[fromQueueNum] = 0;
            }
        }

        @Override
        final int getFromQueueLength(int fromTaskNum, int fromQueueNum) {
            return this.fromQueueLengths[fromTaskNum][fromQueueNum];
        }

        @Override
        final int[] getFromQueue(int fromTaskNum, int fromQueueNum) {
            return this.fromQueues[fromTaskNum][fromQueueNum];
        }

        @Override
        final int addToQueue(int shift, int number, int toTaskNum) {
            return this.addToQueue(shift, number, this.toQueues[toTaskNum], this.toQueueLengths[toTaskNum]);
        }
    }

    static class SingleTaskIntRadixTable
    extends IntRadixTable {
        int[][] fromQueues = new int[256][];
        int[] fromQueueLengths = new int[256];
        int[][] toQueues = new int[256][];
        int[] toQueueLengths = new int[256];

        SingleTaskIntRadixTable(int size) {
            super(size, 1);
        }

        @Override
        final void swapQueues() {
            int[][] temp = this.fromQueues;
            this.fromQueues = this.toQueues;
            this.toQueues = temp;
            int[] tempLengths = this.fromQueueLengths;
            this.fromQueueLengths = this.toQueueLengths;
            this.toQueueLengths = tempLengths;
        }

        @Override
        final void gatherScatter(int shift, int fromQueueNum, int toTaskNum) {
            assert (toTaskNum == 0);
            int[] fromQueue = this.fromQueues[fromQueueNum];
            if (fromQueue != null) {
                int length = this.fromQueueLengths[fromQueueNum];
                for (int j = 0; j < length; ++j) {
                    this.addToQueue(shift, fromQueue[j], 0);
                }
                this.fromQueueLengths[fromQueueNum] = 0;
            }
        }

        @Override
        final int getFromQueueLength(int fromTaskNum, int fromQueueNum) {
            assert (fromTaskNum == 0);
            return this.fromQueueLengths[fromQueueNum];
        }

        @Override
        final int[] getFromQueue(int fromTaskNum, int fromQueueNum) {
            assert (fromTaskNum == 0);
            return this.fromQueues[fromQueueNum];
        }

        @Override
        final int addToQueue(int shift, int number, int toTaskNum) {
            assert (toTaskNum == 0);
            int toQueueNum = number >>> shift & 0xFF;
            int[] toQueue = this.toQueues[toQueueNum];
            int toQueueLength = this.toQueueLengths[toQueueNum];
            if (toQueue == null) {
                int[] newQueue = new int[this.startQueueLength];
                toQueue = newQueue;
                this.toQueues[toQueueNum] = newQueue;
            } else if (toQueueLength >= toQueue.length) {
                int[] newQueue = new int[toQueueLength << 1];
                System.arraycopy(toQueue, 0, newQueue, 0, toQueueLength);
                toQueue = newQueue;
                this.toQueues[toQueueNum] = newQueue;
            }
            toQueue[toQueueLength++] = number;
            this.toQueueLengths[toQueueNum] = toQueueLength;
            return number;
        }
    }

    static class MultiTaskNumberRadixTable<N extends Number>
    extends NumberRadixTable<N> {
        N[][][] fromQueues;
        int[][] fromQueueLengths;
        N[][][] toQueues;
        int[][] toQueueLengths;

        MultiTaskNumberRadixTable(int size, int numTasks) {
            super(size, numTasks);
            this.fromQueues = new Number[numTasks][256][];
            this.fromQueueLengths = new int[numTasks][256];
            this.toQueues = new Number[numTasks][256][];
            this.toQueueLengths = new int[numTasks][256];
        }

        @Override
        final void swapQueues() {
            N[][][] temp = this.fromQueues;
            this.fromQueues = this.toQueues;
            this.toQueues = temp;
            int[][] tempLengths = this.fromQueueLengths;
            this.fromQueueLengths = this.toQueueLengths;
            this.toQueueLengths = tempLengths;
        }

        @Override
        final void gatherScatter(int shift, int fromQueueNum, int toTaskNum) {
            for (int fromTaskNum = 0; fromTaskNum < this.numTasks; ++fromTaskNum) {
                N[][] taskFromQueues = this.fromQueues[fromTaskNum];
                N[] fromQueue = taskFromQueues[fromQueueNum];
                if (fromQueue == null) continue;
                int[] taskFromQueueLengths = this.fromQueueLengths[fromTaskNum];
                N[][] taskToQueues = this.toQueues[toTaskNum];
                int[] taskToQueueLengths = this.toQueueLengths[toTaskNum];
                int length = taskFromQueueLengths[fromQueueNum];
                for (int j = 0; j < length; ++j) {
                    this.addToQueue(shift, (Number)fromQueue[j], (Number[][])taskToQueues, taskToQueueLengths);
                }
                taskFromQueueLengths[fromQueueNum] = 0;
            }
        }

        @Override
        final int getFromQueueLength(int fromTaskNum, int fromQueueNum) {
            return this.fromQueueLengths[fromTaskNum][fromQueueNum];
        }

        @Override
        final N[] getFromQueue(int fromTaskNum, int fromQueueNum) {
            return this.fromQueues[fromTaskNum][fromQueueNum];
        }

        private int addToQueue(int shift, N number, N[][] taskToQueues, int[] taskToQueueLengths) {
            int numInt = ((Number)number).intValue();
            int toQueueNum = numInt >>> shift & 0xFF;
            Object[] toQueue = taskToQueues[toQueueNum];
            int toQueueLength = taskToQueueLengths[toQueueNum];
            if (toQueue == null) {
                Number[] newQueue = new Number[this.startQueueLength];
                toQueue = newQueue;
                taskToQueues[toQueueNum] = newQueue;
            } else if (toQueueLength >= toQueue.length) {
                Number[] newQueue = new Number[toQueueLength << 1];
                System.arraycopy(toQueue, 0, newQueue, 0, toQueueLength);
                toQueue = newQueue;
                taskToQueues[toQueueNum] = newQueue;
            }
            toQueue[toQueueLength++] = number;
            taskToQueueLengths[toQueueNum] = toQueueLength;
            return numInt;
        }

        @Override
        final int addToQueue(int shift, N number, int toTaskNum) {
            return this.addToQueue(shift, (Number)number, (Number[][])this.toQueues[toTaskNum], this.toQueueLengths[toTaskNum]);
        }
    }

    static class SingleTaskNumberRadixTable<N extends Number>
    extends NumberRadixTable<N> {
        N[][] fromQueues = new Number[256][];
        int[] fromQueueLengths = new int[256];
        N[][] toQueues = new Number[256][];
        int[] toQueueLengths = new int[256];

        SingleTaskNumberRadixTable(int size) {
            super(size, 1);
        }

        @Override
        final void swapQueues() {
            N[][] temp = this.fromQueues;
            this.fromQueues = this.toQueues;
            this.toQueues = temp;
            int[] tempLengths = this.fromQueueLengths;
            this.fromQueueLengths = this.toQueueLengths;
            this.toQueueLengths = tempLengths;
        }

        @Override
        final void gatherScatter(int shift, int fromQueueNum, int toTaskNum) {
            assert (toTaskNum == 0);
            N[] fromQueue = this.fromQueues[fromQueueNum];
            if (fromQueue != null) {
                int length = this.fromQueueLengths[fromQueueNum];
                for (int j = 0; j < length; ++j) {
                    this.addToQueue(shift, fromQueue[j], 0);
                }
                this.fromQueueLengths[fromQueueNum] = 0;
            }
        }

        @Override
        final int getFromQueueLength(int fromTaskNum, int fromQueueNum) {
            assert (fromTaskNum == 0);
            return this.fromQueueLengths[fromQueueNum];
        }

        @Override
        final N[] getFromQueue(int fromTaskNum, int fromQueueNum) {
            assert (fromTaskNum == 0);
            return this.fromQueues[fromQueueNum];
        }

        @Override
        final int addToQueue(int shift, N number, int toTaskNum) {
            assert (toTaskNum == 0);
            int numInt = ((Number)number).intValue();
            int toQueueNum = numInt >>> shift & 0xFF;
            Object[] toQueue = this.toQueues[toQueueNum];
            int toQueueLength = this.toQueueLengths[toQueueNum];
            if (toQueue == null) {
                Number[] newQueue = new Number[this.startQueueLength];
                toQueue = newQueue;
                this.toQueues[toQueueNum] = newQueue;
            } else if (toQueueLength >= toQueue.length) {
                Number[] newQueue = new Number[toQueueLength << 1];
                System.arraycopy(toQueue, 0, newQueue, 0, toQueueLength);
                toQueue = newQueue;
                this.toQueues[toQueueNum] = newQueue;
            }
            toQueue[toQueueLength++] = number;
            this.toQueueLengths[toQueueNum] = toQueueLength;
            return numInt;
        }
    }

    static abstract class IntRadixTable
    extends RadixTable {
        IntRadixTable(int size, int numTasks) {
            super(size, numTasks);
        }

        abstract int[] getFromQueue(int var1, int var2);

        abstract int addToQueue(int var1, int var2, int var3);
    }

    static abstract class NumberRadixTable<N extends Number>
    extends RadixTable {
        NumberRadixTable(int size, int numTasks) {
            super(size, numTasks);
        }

        abstract N[] getFromQueue(int var1, int var2);

        abstract int addToQueue(int var1, N var2, int var3);
    }

    static abstract class RadixTable {
        final int numTasks;
        final int startQueueLength;

        RadixTable(int size, int numTasks) {
            this.numTasks = numTasks;
            int sql = (size >>> 7) / numTasks;
            if (sql < 16) {
                sql = 16;
            }
            if (sql > size) {
                sql = size;
            }
            this.startQueueLength = sql;
        }

        abstract void swapQueues();

        abstract void gatherScatter(int var1, int var2, int var3);

        abstract int getFromQueueLength(int var1, int var2);
    }
}

