/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.util.sort.BaseComparisonSortAlgorithm;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Comparator;
import java.util.List;

public final class HeapSort
extends BaseComparisonSortAlgorithm<Object> {
    private static final HeapSort instance = new HeapSort();

    public static HeapSort getInstance() {
        return instance;
    }

    private HeapSort() {
    }

    @Override
    public boolean isStable() {
        return false;
    }

    @Override
    public <T> void sort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        HeapSort.heapSort(list, comparator, stats);
        if (stats != null) {
            stats.sortEnding();
        }
    }

    @Override
    public <T> void sort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        HeapSort.heapSort(array, comparator, stats);
        if (stats != null) {
            stats.sortEnding();
        }
    }

    static <T> void heapSort(List<T> list, Comparator<? super T> comparator, SortStatistics stats) {
        int N = list.size();
        for (int k = N / 2; k > 0; --k) {
            if (stats != null) {
                stats.sortRecursing();
            }
            HeapSort.downheap(list, k, N, comparator, stats);
            if (stats == null) continue;
            stats.sortUnrecursing();
        }
        do {
            HeapSort.swap(list, 0, N - 1, stats);
            --N;
            if (stats != null) {
                stats.sortRecursing();
            }
            HeapSort.downheap(list, 1, N, comparator, stats);
            if (stats == null) continue;
            stats.sortUnrecursing();
        } while (N > 1);
    }

    static <T> void heapSort(T[] array, Comparator<? super T> comparator, SortStatistics stats) {
        int N = array.length;
        for (int k = N / 2; k > 0; --k) {
            if (stats != null) {
                stats.sortRecursing();
            }
            HeapSort.downheap(array, k, N, comparator, stats);
            if (stats == null) continue;
            stats.sortUnrecursing();
        }
        do {
            HeapSort.swap(array, 0, N - 1, stats);
            --N;
            if (stats != null) {
                stats.sortRecursing();
            }
            HeapSort.downheap(array, 1, N, comparator, stats);
            if (stats == null) continue;
            stats.sortUnrecursing();
        } while (N > 1);
    }

    private static <T> void downheap(List<T> list, int k, int N, Comparator<? super T> comparator, SortStatistics stats) {
        T temp = HeapSort.get(list, k - 1, stats);
        while (k <= N / 2) {
            int j = k + k;
            if (j < N && HeapSort.compare(list, j - 1, j, comparator, stats) < 0) {
                ++j;
            }
            if (HeapSort.compare(temp, HeapSort.get(list, j - 1, stats), comparator, stats) >= 0) break;
            HeapSort.set(list, k - 1, HeapSort.get(list, j - 1, stats), stats);
            k = j;
        }
        HeapSort.set(list, k - 1, temp, stats);
    }

    private static <T> void downheap(T[] array, int k, int N, Comparator<? super T> comparator, SortStatistics stats) {
        T temp = HeapSort.get(array, k - 1, stats);
        while (k <= N / 2) {
            int j = k + k;
            if (j < N && HeapSort.compare(array, j - 1, j, comparator, stats) < 0) {
                ++j;
            }
            if (HeapSort.compare(temp, HeapSort.get(array, j - 1, stats), comparator, stats) >= 0) break;
            HeapSort.set(array, k - 1, HeapSort.get(array, j - 1, stats), stats);
            k = j;
        }
        HeapSort.set(array, k - 1, temp, stats);
    }
}

