/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.schedule;

import com.aoindustries.util.StringUtility;
import com.aoindustries.util.UnmodifiableCalendar;
import com.aoindustries.util.schedule.DayOfWeek;
import com.aoindustries.util.schedule.Month;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;

public abstract class Recurring {
    private static final DayOfWeek[] allDaysOfWeek = DayOfWeek.values();
    private static final Month[] allMonths = Month.values();
    private static final int EVERYDAY_HASH_CODE = 0;
    public static final Recurring EVERYDAY = new Recurring(){

        @Override
        public boolean equals(Object o) {
            return o == EVERYDAY;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String getRecurringDisplay() {
            return "Everyday";
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final Calendar cal;
                {
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.add(5, 1);
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private static final int WEEKDAYS_HASH_CODE = 1;
    public static final Recurring WEEKDAYS = new Recurring(){

        @Override
        public boolean equals(Object o) {
            return o == WEEKDAYS;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String getRecurringDisplay() {
            return "Week Days";
        }

        @Override
        public String checkScheduleFrom(Calendar from, String attribute) {
            int dayOfWeek = from.get(7);
            if (dayOfWeek == 7 || dayOfWeek == 1) {
                DayOfWeek fromDow = DayOfWeek.getByCalendarDayOfWeek(dayOfWeek);
                return "Day of week for \"" + attribute + "\" must be a weekday: " + fromDow.getLongName();
            }
            return null;
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final Calendar cal;
                {
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    int dayOfWeek;
                    while ((dayOfWeek = this.cal.get(7)) == 7 || dayOfWeek == 1) {
                        this.cal.add(5, 1);
                    }
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.add(5, 1);
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private static final int WEEKLY_HASH_CODE = 2;
    public static final Recurring WEEKLY = new Recurring(){

        @Override
        public boolean equals(Object o) {
            return o == WEEKLY;
        }

        @Override
        public int hashCode() {
            return 2;
        }

        @Override
        public String getRecurringDisplay() {
            return "Weekly";
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final Calendar cal;
                {
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.add(3, 1);
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private static final int MONTHLY_HASH_CODE = 3;
    public static final Recurring MONTHLY = new Recurring(){

        @Override
        public boolean equals(Object o) {
            return o == MONTHLY;
        }

        @Override
        public int hashCode() {
            return 3;
        }

        @Override
        public String getRecurringDisplay() {
            return "Monthly";
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final int dayOfMonth;
                private final Calendar cal;
                {
                    this.dayOfMonth = from.get(5);
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.set(5, 1);
                    this.cal.add(2, 1);
                    int daysInMonth = this.cal.getActualMaximum(5);
                    this.cal.set(5, Math.min(daysInMonth, this.dayOfMonth));
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private static final int YEARLY_HASH_CODE = 4;
    public static final Recurring YEARLY = new Recurring(){

        @Override
        public boolean equals(Object o) {
            return o == YEARLY;
        }

        @Override
        public int hashCode() {
            return 4;
        }

        @Override
        public String getRecurringDisplay() {
            return "Yearly";
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final int dayOfMonth;
                private final Calendar cal;
                {
                    this.dayOfMonth = from.get(5);
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.set(5, 1);
                    this.cal.add(1, 1);
                    int daysInMonth = this.cal.getActualMaximum(5);
                    this.cal.set(5, Math.min(daysInMonth, this.dayOfMonth));
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };

    public static Recurring parse(String recurring) throws IllegalArgumentException {
        if (recurring == null) {
            return null;
        }
        if ("everyday".equalsIgnoreCase(recurring)) {
            return EVERYDAY;
        }
        if ("weekdays".equalsIgnoreCase(recurring)) {
            return WEEKDAYS;
        }
        if (recurring.length() >= 3 && recurring.substring(0, 3).equalsIgnoreCase("on ")) {
            EnumSet<DayOfWeek> daysOfWeek = EnumSet.noneOf(DayOfWeek.class);
            for (String dayStr : StringUtility.splitStringCommaSpace(recurring.substring(3))) {
                boolean found = false;
                for (DayOfWeek dow : allDaysOfWeek) {
                    if (!dow.getLongName().equalsIgnoreCase(dayStr) && !dow.getShortName().equalsIgnoreCase(dayStr)) continue;
                    daysOfWeek.add(dow);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Unexpected value for day of week: " + dayStr);
            }
            if (daysOfWeek.isEmpty()) {
                throw new IllegalArgumentException("Must specify at least one day of the week for recurring on");
            }
            return new DayOfWeekList(daysOfWeek);
        }
        if (recurring.length() >= 3 && recurring.substring(0, 3).equalsIgnoreCase("in ")) {
            EnumSet<Month> months = EnumSet.noneOf(Month.class);
            for (String monthStr : StringUtility.splitStringCommaSpace(recurring.substring(3))) {
                boolean found = false;
                for (Month month : allMonths) {
                    if (!month.getLongName().equalsIgnoreCase(monthStr) && !month.getShortName().equalsIgnoreCase(monthStr)) continue;
                    months.add(month);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Unexpected value for month: " + monthStr);
            }
            if (months.isEmpty()) {
                throw new IllegalArgumentException("Must specify at least one month for recurring in");
            }
            return new MonthList(months);
        }
        if ("weekly".equalsIgnoreCase(recurring)) {
            return WEEKLY;
        }
        if ("monthly".equalsIgnoreCase(recurring)) {
            return MONTHLY;
        }
        if ("yearly".equalsIgnoreCase(recurring)) {
            return YEARLY;
        }
        if (recurring.length() >= 6 && recurring.substring(0, 6).equalsIgnoreCase("every ")) {
            int field;
            int spacePos = recurring.indexOf(32, 6);
            if (spacePos == -1) {
                throw new IllegalArgumentException("Second space not found in \"every ### {days|weeks|months|years}\": " + recurring);
            }
            int increment = Integer.parseInt(recurring.substring(6, spacePos));
            String fieldStr = recurring.substring(spacePos + 1);
            if ("days".equalsIgnoreCase(fieldStr) || "day".equalsIgnoreCase(fieldStr)) {
                field = 5;
            } else if ("weeks".equalsIgnoreCase(fieldStr) || "week".equalsIgnoreCase(fieldStr)) {
                field = 3;
            } else if ("months".equalsIgnoreCase(fieldStr) || "month".equalsIgnoreCase(fieldStr)) {
                field = 2;
            } else if ("years".equalsIgnoreCase(fieldStr) || "year".equalsIgnoreCase(fieldStr)) {
                field = 1;
            } else {
                throw new IllegalArgumentException("Unexpected value for field: " + fieldStr);
            }
            return new Every(increment, field);
        }
        throw new IllegalArgumentException("Unexpected value for recurring: " + recurring);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String getRecurringDisplay();

    public String checkScheduleFrom(Calendar from, String attribute) {
        return null;
    }

    public abstract Iterator<Calendar> getScheduleIterator(Calendar var1);

    public static class Every
    extends Recurring {
        private final int increment;
        private final int field;

        public Every(int increment, int field) {
            if (increment < 1) {
                throw new IllegalArgumentException("Increment must be at least one");
            }
            this.increment = increment;
            if (field != 5 && field != 3 && field != 2 && field != 1) {
                throw new IllegalArgumentException("Unexpected value for field: " + field);
            }
            this.field = field;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Every)) {
                return false;
            }
            Every other = (Every)o;
            return this.increment == other.increment && this.field == other.field;
        }

        @Override
        public int hashCode() {
            return this.increment * 31 + this.field;
        }

        @Override
        public String getRecurringDisplay() {
            StringBuilder sb = new StringBuilder("Every ");
            sb.append(this.increment);
            switch (this.field) {
                case 5: {
                    sb.append(" days");
                    break;
                }
                case 3: {
                    sb.append(" weeks");
                    break;
                }
                case 2: {
                    sb.append(" months");
                    break;
                }
                case 1: {
                    sb.append(" years");
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value for field: " + this.field));
                }
            }
            return sb.toString();
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            switch (this.field) {
                case 1: 
                case 3: 
                case 5: {
                    return new Iterator<Calendar>(){
                        private final Calendar cal;
                        {
                            this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                        }

                        @Override
                        public boolean hasNext() {
                            return true;
                        }

                        @Override
                        public Calendar next() {
                            Calendar date = (Calendar)this.cal.clone();
                            this.cal.add(Every.this.field, Every.this.increment);
                            return date;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                case 2: {
                    return new Iterator<Calendar>(){
                        private final int dayOfMonth;
                        private final Calendar cal;
                        {
                            this.dayOfMonth = from.get(5);
                            this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                        }

                        @Override
                        public boolean hasNext() {
                            return true;
                        }

                        @Override
                        public Calendar next() {
                            Calendar date = (Calendar)this.cal.clone();
                            this.cal.set(5, 1);
                            this.cal.add(2, Every.this.increment);
                            int daysInMonth = this.cal.getActualMaximum(5);
                            this.cal.set(5, Math.min(daysInMonth, this.dayOfMonth));
                            return date;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            }
            throw new AssertionError((Object)("Unexpected value for field: " + this.field));
        }
    }

    public static class MonthList
    extends Recurring {
        private final EnumSet<Month> months;

        public MonthList(Collection<Month> months) {
            if (months.isEmpty()) {
                throw new IllegalArgumentException("At least one month required");
            }
            this.months = EnumSet.copyOf(months);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MonthList)) {
                return false;
            }
            MonthList other = (MonthList)o;
            return this.months.equals(other.months);
        }

        @Override
        public int hashCode() {
            return this.months.hashCode();
        }

        @Override
        public String getRecurringDisplay() {
            StringBuilder sb = new StringBuilder("In ");
            boolean didOne = false;
            for (Month month : this.months) {
                if (didOne) {
                    sb.append(", ");
                } else {
                    didOne = true;
                }
                sb.append(month.toString());
            }
            return sb.toString();
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final Calendar cal;
                {
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    while (true) {
                        Month month = Month.getByCalendarMonth(this.cal.get(2));
                        if (MonthList.this.months.contains((Object)month)) break;
                        this.cal.add(2, 1);
                    }
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.add(2, 1);
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class DayOfWeekList
    extends Recurring {
        private final EnumSet<DayOfWeek> daysOfWeek;

        public DayOfWeekList(Collection<DayOfWeek> daysOfWeek) {
            if (daysOfWeek.isEmpty()) {
                throw new IllegalArgumentException("At least one day of week required");
            }
            this.daysOfWeek = EnumSet.copyOf(daysOfWeek);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof DayOfWeekList)) {
                return false;
            }
            DayOfWeekList other = (DayOfWeekList)o;
            return this.daysOfWeek.equals(other.daysOfWeek);
        }

        @Override
        public int hashCode() {
            return this.daysOfWeek.hashCode();
        }

        @Override
        public String getRecurringDisplay() {
            StringBuilder sb = new StringBuilder("On ");
            boolean didOne = false;
            for (DayOfWeek dow : this.daysOfWeek) {
                if (didOne) {
                    sb.append(", ");
                } else {
                    didOne = true;
                }
                sb.append(dow.toString());
            }
            return sb.toString();
        }

        @Override
        public String checkScheduleFrom(Calendar from, String attribute) {
            DayOfWeek fromDow = DayOfWeek.getByCalendarDayOfWeek(from.get(7));
            if (!this.daysOfWeek.contains((Object)fromDow)) {
                return "Day of week for \"" + attribute + "\" not found in days of week list: " + fromDow.getLongName();
            }
            return null;
        }

        @Override
        public Iterator<Calendar> getScheduleIterator(final Calendar from) {
            return new Iterator<Calendar>(){
                private final Calendar cal;
                {
                    this.cal = UnmodifiableCalendar.unwrapClone((Calendar)from);
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Calendar next() {
                    while (true) {
                        DayOfWeek dow = DayOfWeek.getByCalendarDayOfWeek(this.cal.get(7));
                        if (DayOfWeekList.this.daysOfWeek.contains((Object)dow)) break;
                        this.cal.add(5, 1);
                    }
                    Calendar date = (Calendar)this.cal.clone();
                    this.cal.add(5, 1);
                    return date;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

