/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.FileUtils;
import com.aoindustries.io.IoUtils;
import com.aoindustries.lang.NotImplementedException;
import com.aoindustries.util.AoArrays;
import com.aoindustries.util.persistent.AbstractPersistentBuffer;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.ProtectionLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TwoCopyBarrierBuffer
extends AbstractPersistentBuffer {
    private static final int DEFAULT_SECTOR_SIZE = 4096;
    private static final long DEFAULT_ASYNCHRONOUS_COMMIT_DELAY = 5000L;
    private static final long DEFAULT_SYNCHRONOUS_COMMIT_DELAY = 60000L;
    private static final Logger logger = Logger.getLogger(TwoCopyBarrierBuffer.class.getName());
    private static final Timer asynchronousCommitTimer = new Timer("TwoCopyBarrierBuffer.asynchronousCommitTimer");
    private static final Set<TwoCopyBarrierBuffer> shutdownBuffers = new HashSet<TwoCopyBarrierBuffer>();
    private static final Thread shutdownHook = new Thread("TwoCopyBarrierBuffer.shutdownHook"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                boolean terminated;
                ArrayList toClose;
                Set set = shutdownBuffers;
                synchronized (set) {
                    toClose = new ArrayList(shutdownBuffers);
                    shutdownBuffers.clear();
                }
                if (toClose.isEmpty()) break block16;
                final FieldLock fieldLock = new FieldLock();
                final int[] counter = new int[]{1};
                final long[] startTime = new long[]{System.currentTimeMillis() - 55000L};
                final boolean[] wrote = new boolean[]{false};
                final int size = toClose.size();
                int maxNumThreads = Math.max(100, size / 20);
                int numThreads = Math.min(maxNumThreads, size);
                ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
                try {
                    for (int c = 0; c < size; ++c) {
                        final TwoCopyBarrierBuffer buffer = (TwoCopyBarrierBuffer)toClose.get(c);
                        executorService.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                FieldLock fieldLock2 = fieldLock;
                                synchronized (fieldLock2) {
                                    long currentTime = System.currentTimeMillis();
                                    long timeSince = currentTime - startTime[0];
                                    if (timeSince <= -60000L || timeSince >= 60000L) {
                                        logger.info(size == 1 ? "Closing the TwoCopyBarrierBuffer." : "Closing TwoCopyBarrierBuffer " + counter[0] + " of " + size + ".");
                                        wrote[0] = true;
                                        startTime[0] = currentTime;
                                    }
                                    counter[0] = counter[0] + 1;
                                }
                                try {
                                    buffer.close();
                                }
                                catch (ThreadDeath TD) {
                                    throw TD;
                                }
                                catch (Throwable T) {
                                    logger.log(Level.WARNING, null, T);
                                }
                            }
                        });
                    }
                    executorService.shutdown();
                    terminated = false;
                }
                catch (Throwable throwable) {
                    executorService.shutdown();
                    boolean terminated2 = false;
                    while (!terminated2) {
                        try {
                            terminated2 = executorService.awaitTermination(3600L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException err) {
                            logger.log(Level.WARNING, null, err);
                            Thread.currentThread().interrupt();
                        }
                        if (terminated2) continue;
                        logger.info(size == 1 ? "Waiting for the TwoCopyBarrierBuffer to close." : "Waiting for all " + size + " TwoCopyBarrierBuffers to close.");
                    }
                    throw throwable;
                }
                while (!terminated) {
                    try {
                        terminated = executorService.awaitTermination(3600L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException err) {
                        logger.log(Level.WARNING, null, err);
                        Thread.currentThread().interrupt();
                    }
                    if (terminated) continue;
                    logger.info(size == 1 ? "Waiting for the TwoCopyBarrierBuffer to close." : "Waiting for all " + size + " TwoCopyBarrierBuffers to close.");
                }
                FieldLock fieldLock2 = fieldLock;
                synchronized (fieldLock2) {
                    if (wrote[0]) {
                        logger.info(size == 1 ? "Finished closing the TwoCopyBarrierBuffer." : "Finished closing all " + size + " TwoCopyBarrierBuffers.");
                    }
                }
            }
        }
    };
    private final File file;
    private final File newFile;
    private final File oldFile;
    private final boolean deleteOnClose;
    private final int sectorSize;
    private final long asynchronousCommitDelay;
    private final long synchronousCommitDelay;
    private final CacheLock cacheLock = new CacheLock();
    private SortedMap<Long, byte[]> currentWriteCache = new TreeMap<Long, byte[]>();
    private SortedMap<Long, byte[]> oldWriteCache = new TreeMap<Long, byte[]>();
    private long capacity;
    private RandomAccessFile raf;
    private boolean isClosed = false;
    private long firstWriteTime = -1L;
    private TimerTask asynchronousCommitTimerTask;

    public TwoCopyBarrierBuffer() throws IOException {
        super(ProtectionLevel.NONE);
        this.file = File.createTempFile("TwoCopyBarrierBuffer", null);
        this.file.deleteOnExit();
        this.newFile = new File(this.file.getPath() + ".new");
        if (this.newFile.exists()) {
            throw new IOException("File exists: " + this.newFile);
        }
        this.newFile.deleteOnExit();
        this.oldFile = new File(this.file.getPath() + ".old");
        if (this.oldFile.exists()) {
            throw new IOException("File exists: " + this.oldFile);
        }
        this.oldFile.deleteOnExit();
        new FileOutputStream(this.oldFile).close();
        this.deleteOnClose = true;
        this.sectorSize = 4096;
        this.asynchronousCommitDelay = 5000L;
        this.synchronousCommitDelay = 60000L;
        this.raf = new RandomAccessFile(this.file, "r");
    }

    public TwoCopyBarrierBuffer(String name) throws IOException {
        this(new File(name), ProtectionLevel.BARRIER, 4096, 5000L, 60000L);
    }

    public TwoCopyBarrierBuffer(String name, ProtectionLevel protectionLevel) throws IOException {
        this(new File(name), protectionLevel, 4096, 5000L, 60000L);
    }

    public TwoCopyBarrierBuffer(File file) throws IOException {
        this(file, ProtectionLevel.BARRIER, 4096, 5000L, 60000L);
    }

    public TwoCopyBarrierBuffer(File file, ProtectionLevel protectionLevel) throws IOException {
        this(file, protectionLevel, 4096, 5000L, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TwoCopyBarrierBuffer(File file, ProtectionLevel protectionLevel, int sectorSize, long asynchronousCommitDelay, long synchronousCommitDelay) throws IOException {
        super(protectionLevel);
        if (Integer.bitCount(sectorSize) != 1) {
            throw new IllegalArgumentException("sectorSize is not a power of two: " + sectorSize);
        }
        if (sectorSize < 1) {
            throw new IllegalArgumentException("sectorSize<1: " + sectorSize);
        }
        if (asynchronousCommitDelay < 0L) {
            throw new IllegalArgumentException("asynchronousCommitDelay<0: " + asynchronousCommitDelay);
        }
        if (synchronousCommitDelay < 0L) {
            throw new IllegalArgumentException("synchronousCommitDelay<0: " + synchronousCommitDelay);
        }
        this.file = file;
        this.newFile = new File(file.getPath() + ".new");
        this.oldFile = new File(file.getPath() + ".old");
        this.deleteOnClose = false;
        this.sectorSize = sectorSize;
        this.asynchronousCommitDelay = asynchronousCommitDelay;
        this.synchronousCommitDelay = synchronousCommitDelay;
        if (file.exists()) {
            if (this.newFile.exists()) {
                if (this.oldFile.exists()) {
                    throw new IOException("file, newFile, and oldFile all exist");
                }
                FileUtils.rename((File)this.newFile, (File)this.oldFile);
            } else if (!this.oldFile.exists()) {
                new FileOutputStream(this.oldFile).close();
            }
        } else if (this.newFile.exists()) {
            if (!this.oldFile.exists()) throw new IOException("newFile exists without either file or oldFile");
            FileUtils.rename((File)this.newFile, (File)file);
        } else {
            if (this.oldFile.exists()) {
                throw new IOException("oldFile exists without either file or newFile");
            }
            new FileOutputStream(file).close();
            new FileOutputStream(this.oldFile).close();
        }
        this.raf = new RandomAccessFile(file, "r");
        this.capacity = this.raf.length();
        long oldCapacity = this.oldFile.length();
        FileInputStream oldIn = new FileInputStream(this.oldFile);
        try {
            byte[] buff = new byte[sectorSize];
            byte[] oldBuff = new byte[sectorSize];
            for (long sector = 0L; sector < this.capacity; sector += (long)sectorSize) {
                long sectorEnd = sector + (long)sectorSize;
                if (sectorEnd > this.capacity) {
                    sectorEnd = this.capacity;
                }
                int inBytes = (int)(sectorEnd - sector);
                this.raf.readFully(buff, 0, inBytes);
                if (sectorEnd > oldCapacity) {
                    if (sector >= oldCapacity && AoArrays.allEquals((byte[])buff, (int)0, (int)inBytes, (byte)0)) continue;
                    if (inBytes < sectorSize) {
                        Arrays.fill(buff, sectorSize - inBytes, sectorSize, (byte)0);
                    }
                    this.oldWriteCache.put(sector, buff);
                    buff = new byte[sectorSize];
                    continue;
                }
                IoUtils.readFully((InputStream)oldIn, (byte[])oldBuff, (int)0, (int)inBytes);
                if (AoArrays.equals((byte[])buff, (byte[])oldBuff, (int)0, (int)inBytes)) continue;
                if (inBytes < sectorSize) {
                    Arrays.fill(buff, sectorSize - inBytes, sectorSize, (byte)0);
                }
                this.oldWriteCache.put(sector, buff);
                buff = new byte[sectorSize];
            }
        }
        finally {
            ((InputStream)oldIn).close();
        }
        Set<TwoCopyBarrierBuffer> set = shutdownBuffers;
        synchronized (set) {
            shutdownBuffers.add(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushWriteCache(boolean isClosing) throws IOException {
        if (!this.currentWriteCache.isEmpty()) {
            if (this.protectionLevel == ProtectionLevel.READ_ONLY) {
                throw new IOException("protectionLevel==ProtectionLevel.READ_ONLY");
            }
            FileUtils.rename((File)this.oldFile, (File)this.newFile);
            RandomAccessFile newRaf = new RandomAccessFile(this.newFile, "rw");
            try {
                long oldLength = newRaf.length();
                if (this.capacity != oldLength) {
                    newRaf.setLength(this.capacity);
                    if (this.capacity > oldLength) {
                        PersistentCollections.ensureZeros(newRaf, oldLength, this.capacity - oldLength);
                    }
                }
                for (Map.Entry<Long, byte[]> entry : this.oldWriteCache.entrySet()) {
                    long sector = entry.getKey();
                    long sectorEnd = sector + (long)this.sectorSize;
                    if (sectorEnd > this.capacity) {
                        sectorEnd = this.capacity;
                    }
                    newRaf.seek(sector);
                    newRaf.write(entry.getValue(), 0, (int)(sectorEnd - sector));
                }
                if (this.protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0) {
                    newRaf.getChannel().force(false);
                }
            }
            finally {
                newRaf.close();
            }
            this.raf.close();
            FileUtils.rename((File)this.file, (File)this.oldFile);
            this.oldWriteCache.clear();
            SortedMap<Long, byte[]> temp = this.currentWriteCache;
            this.currentWriteCache = this.oldWriteCache;
            this.oldWriteCache = temp;
            FileUtils.rename((File)this.newFile, (File)this.file);
            if (!isClosing) {
                this.raf = new RandomAccessFile(this.file, "r");
            }
            this.clearFirstWriteTime();
        } else if (isClosing) {
            this.raf.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = shutdownBuffers;
        synchronized (object) {
            shutdownBuffers.remove(this);
        }
        object = this.cacheLock;
        synchronized (object) {
            this.flushWriteCache(true);
            this.isClosed = true;
            if (this.deleteOnClose) {
                IOException ioErr = null;
                if (this.newFile.exists()) {
                    try {
                        FileUtils.delete((File)this.newFile);
                    }
                    catch (IOException e) {
                        ioErr = e;
                    }
                }
                if (this.oldFile.exists()) {
                    try {
                        FileUtils.delete((File)this.oldFile);
                    }
                    catch (IOException e) {
                        ioErr = e;
                    }
                }
                if (this.file.exists()) {
                    try {
                        FileUtils.delete((File)this.file);
                    }
                    catch (IOException e) {
                        ioErr = e;
                    }
                }
                if (ioErr != null) {
                    throw ioErr;
                }
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("TwoCopyBarrierBuffer(\"" + this.file.getPath() + "\") is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long capacity() throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.checkClosed();
            return this.capacity;
        }
    }

    private void clearFirstWriteTime() {
        this.firstWriteTime = -1L;
        if (this.asynchronousCommitTimerTask != null) {
            this.asynchronousCommitTimerTask.cancel();
            this.asynchronousCommitTimerTask = null;
        }
    }

    private void markFirstWriteTime() {
        if (this.firstWriteTime == -1L) {
            this.firstWriteTime = System.currentTimeMillis();
        }
        if (this.asynchronousCommitDelay != Long.MAX_VALUE && this.asynchronousCommitTimerTask == null) {
            this.asynchronousCommitTimerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CacheLock cacheLock = TwoCopyBarrierBuffer.this.cacheLock;
                    synchronized (cacheLock) {
                        if (TwoCopyBarrierBuffer.this.asynchronousCommitTimerTask == this) {
                            TwoCopyBarrierBuffer.this.asynchronousCommitTimerTask = null;
                            if (TwoCopyBarrierBuffer.this.firstWriteTime != -1L) {
                                long timeSince = System.currentTimeMillis() - TwoCopyBarrierBuffer.this.firstWriteTime;
                                if (timeSince <= -TwoCopyBarrierBuffer.this.asynchronousCommitDelay || timeSince >= TwoCopyBarrierBuffer.this.asynchronousCommitDelay) {
                                    try {
                                        TwoCopyBarrierBuffer.this.flushWriteCache(false);
                                    }
                                    catch (IOException err) {
                                        logger.log(Level.SEVERE, null, err);
                                    }
                                } else {
                                    TwoCopyBarrierBuffer.this.markFirstWriteTime();
                                }
                            }
                        }
                    }
                }
            };
            long delay = this.firstWriteTime + this.asynchronousCommitDelay - System.currentTimeMillis();
            if (delay < 0L) {
                delay = 0L;
            }
            asynchronousCommitTimer.schedule(this.asynchronousCommitTimerTask, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCapacity(long newCapacity) throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.checkClosed();
            if (newCapacity != this.capacity) {
                Iterator<Map.Entry<Long, byte[]>> oldEntries = this.oldWriteCache.entrySet().iterator();
                while (oldEntries.hasNext()) {
                    Map.Entry<Long, byte[]> entry = oldEntries.next();
                    Long sector = entry.getKey();
                    if (sector >= newCapacity) {
                        oldEntries.remove();
                        this.currentWriteCache.remove(sector);
                        continue;
                    }
                    long sectorEnd = sector + (long)this.sectorSize;
                    if (newCapacity < sector || newCapacity >= sectorEnd) continue;
                    Arrays.fill(entry.getValue(), (int)(newCapacity - sector), this.sectorSize, (byte)0);
                }
                this.capacity = newCapacity;
                this.markFirstWriteTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte get(long position) throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.checkClosed();
            if (position < 0L) {
                throw new IllegalArgumentException("position<0: " + position);
            }
            long sector = position & (long)(-this.sectorSize);
            byte[] cached = (byte[])this.oldWriteCache.get(sector);
            if (cached != null) {
                return cached[(int)(position - sector)];
            }
            long rafLength = this.raf.length();
            if (position < rafLength) {
                this.raf.seek(position);
                return this.raf.readByte();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSome(long position, byte[] buff, int off, int len) throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.checkClosed();
            if (position < 0L) {
                throw new IllegalArgumentException("position<0: " + position);
            }
            if (off < 0) {
                throw new IllegalArgumentException("off<0: " + off);
            }
            if (len < 0) {
                throw new IllegalArgumentException("len<0: " + len);
            }
            long end = position + (long)len;
            int bytesRead = 0;
            while (position < end) {
                int count;
                long sector = position & (long)(-this.sectorSize);
                int buffEnd = off + (this.sectorSize + (int)(sector - position));
                if (buffEnd > off + len) {
                    buffEnd = off + len;
                }
                int bytesToRead = buffEnd - off;
                byte[] cached = (byte[])this.oldWriteCache.get(sector);
                if (cached != null) {
                    System.arraycopy(cached, (int)(position - sector), buff, off, bytesToRead);
                    count = bytesToRead;
                } else {
                    long rafLength = this.raf.length();
                    if (position < rafLength) {
                        this.raf.seek(position);
                        count = this.raf.read(buff, off, bytesToRead);
                        if (count == -1) {
                            throw new BufferUnderflowException();
                        }
                    } else {
                        Arrays.fill(buff, off, buffEnd, (byte)0);
                        count = bytesToRead;
                    }
                }
                bytesRead += count;
                if (count < bytesToRead) break;
                position += (long)count;
                off += count;
                len -= count;
            }
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(long position, byte value) throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.checkClosed();
            if (position < 0L) {
                throw new IllegalArgumentException("position<0: " + position);
            }
            long sector = position & (long)(-this.sectorSize);
            byte[] oldCached = (byte[])this.oldWriteCache.get(sector);
            if (oldCached != null) {
                if (this.currentWriteCache.containsKey(sector)) {
                    oldCached[(int)(position - sector)] = value;
                } else if (oldCached[(int)(position - sector)] != value) {
                    this.markFirstWriteTime();
                    this.currentWriteCache.put(sector, oldCached);
                    oldCached[(int)(position - sector)] = value;
                }
            } else {
                byte curValue;
                long rafLength = this.raf.length();
                if (position < rafLength) {
                    this.raf.seek(position);
                    curValue = this.raf.readByte();
                } else {
                    curValue = 0;
                }
                if (curValue != value) {
                    byte[] readBuff = new byte[this.sectorSize];
                    int offset = 0;
                    int bytesLeft = this.sectorSize;
                    while (bytesLeft > 0) {
                        long seek = sector + (long)offset;
                        if (seek < rafLength) {
                            this.raf.seek(seek);
                            long readEnd = seek + (long)bytesLeft;
                            if (readEnd > rafLength) {
                                readEnd = rafLength;
                            }
                            int readLen = (int)(readEnd - seek);
                            this.raf.readFully(readBuff, offset, readLen);
                            offset += readLen;
                            bytesLeft -= readLen;
                            continue;
                        }
                        offset += bytesLeft;
                        bytesLeft = 0;
                    }
                    this.markFirstWriteTime();
                    this.currentWriteCache.put(sector, readBuff);
                    this.oldWriteCache.put(sector, readBuff);
                    readBuff[(int)(position - sector)] = value;
                }
            }
        }
    }

    @Override
    public void ensureZeros(long position, long len) throws IOException {
        throw new NotImplementedException("TODO: Implement by using PersistentCollection.zero, passing to put sector aligned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(long position, byte[] buff, int off, int len) throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            this.checkClosed();
            if (position < 0L) {
                throw new IllegalArgumentException("position<0: " + position);
            }
            if (off < 0) {
                throw new IllegalArgumentException("off<0: " + off);
            }
            if (len < 0) {
                throw new IllegalArgumentException("len<0: " + len);
            }
            long rafLength = -1L;
            long end = position + (long)len;
            byte[] readBuff = null;
            while (position < end) {
                long sector = position & (long)(-this.sectorSize);
                int buffEnd = off + (this.sectorSize + (int)(sector - position));
                if (buffEnd > off + len) {
                    buffEnd = off + len;
                }
                int bytesToWrite = buffEnd - off;
                byte[] oldCached = (byte[])this.oldWriteCache.get(sector);
                if (oldCached != null) {
                    if (this.currentWriteCache.containsKey(sector)) {
                        System.arraycopy(buff, off, oldCached, (int)(position - sector), bytesToWrite);
                    } else if (!AoArrays.equals((byte[])buff, (int)off, (byte[])oldCached, (int)((int)(position - sector)), (int)bytesToWrite)) {
                        this.markFirstWriteTime();
                        this.currentWriteCache.put(sector, oldCached);
                        System.arraycopy(buff, off, oldCached, (int)(position - sector), bytesToWrite);
                    }
                } else {
                    boolean isNewBuff;
                    if (rafLength == -1L) {
                        rafLength = this.raf.length();
                    }
                    boolean bl = isNewBuff = readBuff == null;
                    if (isNewBuff) {
                        readBuff = new byte[this.sectorSize];
                    }
                    int offset = 0;
                    int bytesLeft = this.sectorSize;
                    while (bytesLeft > 0) {
                        long seek = sector + (long)offset;
                        if (seek < rafLength) {
                            this.raf.seek(seek);
                            long readEnd = seek + (long)bytesLeft;
                            if (readEnd > rafLength) {
                                readEnd = rafLength;
                            }
                            int readLen = (int)(readEnd - seek);
                            this.raf.readFully(readBuff, offset, readLen);
                            offset += readLen;
                            bytesLeft -= readLen;
                            continue;
                        }
                        if (!isNewBuff) {
                            Arrays.fill(readBuff, offset, this.sectorSize, (byte)0);
                        }
                        offset += bytesLeft;
                        bytesLeft = 0;
                    }
                    if (!AoArrays.equals((byte[])buff, (int)off, (byte[])readBuff, (int)((int)(position - sector)), (int)bytesToWrite)) {
                        this.markFirstWriteTime();
                        this.currentWriteCache.put(sector, readBuff);
                        this.oldWriteCache.put(sector, readBuff);
                        System.arraycopy(buff, off, readBuff, (int)(position - sector), bytesToWrite);
                        readBuff = null;
                    }
                }
                position += (long)bytesToWrite;
                off += bytesToWrite;
                len -= bytesToWrite;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void barrier(boolean force) throws IOException {
        CacheLock cacheLock = this.cacheLock;
        synchronized (cacheLock) {
            long timeSince;
            this.checkClosed();
            if (force && this.protectionLevel.compareTo(ProtectionLevel.FORCE) >= 0) {
                this.flushWriteCache(false);
            } else if (this.firstWriteTime != -1L && ((timeSince = System.currentTimeMillis() - this.firstWriteTime) <= -this.synchronousCommitDelay || timeSince >= this.synchronousCommitDelay)) {
                this.flushWriteCache(false);
            }
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private static class CacheLock {
        private CacheLock() {
        }
    }

    private static class FieldLock {
        private FieldLock() {
        }
    }
}

