/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ShortSerializer
implements Serializer<Short> {
    private final byte[] buffer = new byte[2];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Short value) {
        return 2L;
    }

    @Override
    public void serialize(Short value, OutputStream out) throws IOException {
        IoUtils.shortToBuffer((short)value, (byte[])this.buffer);
        out.write(this.buffer, 0, 2);
    }

    @Override
    public Short deserialize(InputStream in) throws IOException {
        IoUtils.readFully((InputStream)in, (byte[])this.buffer, (int)0, (int)2);
        return IoUtils.bufferToShort((byte[])this.buffer);
    }
}

