/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.FileUtils;
import com.aoindustries.util.persistent.AbstractPersistentBuffer;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.ProtectionLevel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;

public class RandomAccessFileBuffer
extends AbstractPersistentBuffer {
    private static final Logger logger = Logger.getLogger(RandomAccessFileBuffer.class.getName());
    private final File tempFile;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private boolean closed;

    public RandomAccessFileBuffer() throws IOException {
        super(ProtectionLevel.NONE);
        this.tempFile = File.createTempFile("RandomAccessFileBuffer", null);
        this.tempFile.deleteOnExit();
        this.raf = new RandomAccessFile(this.tempFile, "rw");
        this.channel = this.raf.getChannel();
        this.channel.lock(0L, Long.MAX_VALUE, false);
    }

    public RandomAccessFileBuffer(String name) throws IOException {
        this(new RandomAccessFile(name, "rw"), ProtectionLevel.BARRIER);
    }

    public RandomAccessFileBuffer(String name, ProtectionLevel protectionLevel) throws IOException {
        this(new RandomAccessFile(name, protectionLevel == ProtectionLevel.READ_ONLY ? "r" : "rw"), protectionLevel);
    }

    public RandomAccessFileBuffer(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"), ProtectionLevel.BARRIER);
    }

    public RandomAccessFileBuffer(File file, ProtectionLevel protectionLevel) throws IOException {
        this(new RandomAccessFile(file, protectionLevel == ProtectionLevel.READ_ONLY ? "r" : "rw"), protectionLevel);
    }

    public RandomAccessFileBuffer(RandomAccessFile raf, ProtectionLevel protectionLevel) throws IOException {
        super(protectionLevel);
        this.tempFile = null;
        this.raf = raf;
        this.channel = raf.getChannel();
        this.channel.lock(0L, Long.MAX_VALUE, protectionLevel == ProtectionLevel.READ_ONLY);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.raf.close();
        if (this.tempFile != null && this.tempFile.exists()) {
            FileUtils.delete((File)this.tempFile);
        }
    }

    @Override
    public long capacity() throws IOException {
        return this.raf.length();
    }

    @Override
    public void setCapacity(long newLength) throws IOException {
        long oldLength = this.capacity();
        this.raf.setLength(newLength);
        if (newLength > oldLength) {
            this.ensureZeros(oldLength, newLength - oldLength);
        }
    }

    @Override
    public int getSome(long position, byte[] buff, int off, int len) throws IOException {
        this.raf.seek(position);
        int count = this.raf.read(buff, off, len);
        if (count < 0) {
            throw new BufferUnderflowException();
        }
        return count;
    }

    @Override
    public byte get(long position) throws IOException {
        this.raf.seek(position);
        return this.raf.readByte();
    }

    @Override
    public void ensureZeros(long position, long len) throws IOException {
        PersistentCollections.ensureZeros(this.raf, position, len);
    }

    @Override
    public void put(long position, byte value) throws IOException {
        if (position >= this.capacity()) {
            throw new BufferOverflowException();
        }
        this.raf.seek(position);
        this.raf.write(value);
    }

    @Override
    public void put(long position, byte[] buff, int off, int len) throws IOException {
        if (position + (long)len > this.capacity()) {
            throw new BufferOverflowException();
        }
        this.raf.seek(position);
        this.raf.write(buff, off, len);
    }

    @Override
    public void barrier(boolean force) throws IOException {
        if (this.protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0) {
            this.channel.force(false);
        }
    }
}

