/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.AoArrays;
import com.aoindustries.util.WrappedException;
import com.aoindustries.util.persistent.PersistentBlockBuffer;
import com.aoindustries.util.persistent.PersistentBuffer;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.ProtectionLevel;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.logging.Logger;

public class PersistentLinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Queue<E> {
    private static final Logger logger = Logger.getLogger(PersistentLinkedList.class.getName());
    private static final byte[] MAGIC = new byte[]{80, 76, 76, 10};
    private static final int VERSION = 3;
    private static final long END_PTR = -2L;
    private static final long HEAD_OFFSET = MAGIC.length + 4;
    private static final long TAIL_OFFSET = HEAD_OFFSET + 8L;
    private static final int HEADER_SIZE = (int)(TAIL_OFFSET + 8L);
    private static final int NEXT_OFFSET = 0;
    private static final int PREV_OFFSET = 8;
    private static final int DATA_SIZE_OFFSET = 16;
    private static final int DATA_OFFSET = 24;
    private static final long DATA_SIZE_NULL = -1L;
    private final Serializer<E> serializer;
    private final PersistentBlockBuffer blockBuffer;
    private final byte[] ioBuffer = new byte[Math.max(24, MAGIC.length)];
    private long metaDataBlockId;
    private long _head;
    private long _tail;
    private long _size;

    public PersistentLinkedList(Class<E> type) throws IOException {
        this.serializer = PersistentCollections.getSerializer(type);
        this.blockBuffer = PersistentCollections.getPersistentBlockBuffer(this.serializer, PersistentCollections.getPersistentBuffer(Long.MAX_VALUE), Math.max(HEADER_SIZE, 24));
        this.checkConsistency(true, true);
    }

    public PersistentLinkedList(Class<E> type, Collection<? extends E> c) throws IOException {
        this(type);
        this.addAll(c);
    }

    public PersistentLinkedList(PersistentBuffer pbuffer, Class<E> type) throws IOException {
        this(pbuffer, PersistentCollections.getSerializer(type));
    }

    public PersistentLinkedList(PersistentBuffer pbuffer, Serializer<E> serializer) throws IOException {
        this.serializer = serializer;
        this.blockBuffer = PersistentCollections.getPersistentBlockBuffer(serializer, pbuffer, Math.max(HEADER_SIZE, 24));
        this.checkConsistency(this.blockBuffer.getProtectionLevel() != ProtectionLevel.READ_ONLY, true);
    }

    private boolean isValidRange(long ptr) throws IOException {
        return ptr >= 0L && ptr != this.metaDataBlockId;
    }

    private long getHead() {
        return this._head;
    }

    private void setHead(long head) throws IOException {
        this.blockBuffer.putLong(this.metaDataBlockId, HEAD_OFFSET, head);
        this._head = head;
    }

    private long getTail() {
        return this._tail;
    }

    private void setTail(long tail) throws IOException {
        this.blockBuffer.putLong(this.metaDataBlockId, TAIL_OFFSET, tail);
        this._tail = tail;
    }

    private long getNext(long ptr) throws IOException {
        return this.blockBuffer.getLong(ptr, 0L);
    }

    private void setNext(long ptr, long next) throws IOException {
        this.blockBuffer.putLong(ptr, 0L, next);
    }

    private long getPrev(long ptr) throws IOException {
        return this.blockBuffer.getLong(ptr, 8L);
    }

    private void setPrev(long ptr, long prev) throws IOException {
        this.blockBuffer.putLong(ptr, 8L, prev);
    }

    private long getDataSize(long ptr) throws IOException {
        return this.blockBuffer.getLong(ptr, 16L);
    }

    private boolean isNull(long ptr) throws IOException {
        return this.getDataSize(ptr) == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getElement(long ptr) throws IOException {
        long dataSize = this.getDataSize(ptr);
        if (dataSize == -1L) {
            return null;
        }
        InputStream in = this.blockBuffer.getInputStream(ptr, 24L, dataSize);
        try {
            E e = this.serializer.deserialize(in);
            return e;
        }
        finally {
            in.close();
        }
    }

    private void remove(long ptr) throws IOException {
        long prev = this.getPrev(ptr);
        long next = this.getNext(ptr);
        if (prev == -2L) {
            this.setHead(next);
        } else {
            this.setNext(prev, next);
        }
        if (next == -2L) {
            this.setTail(prev);
        } else {
            this.setPrev(next, prev);
        }
        this.blockBuffer.barrier(false);
        this.blockBuffer.deallocate(ptr);
        this.blockBuffer.barrier(true);
        --this._size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addEntry(long next, long prev, E element) throws IOException {
        long newPtr;
        if (this._size == Long.MAX_VALUE) {
            throw new IOException("List is full: _size==Long.MAX_VALUE");
        }
        if (element == null) {
            newPtr = this.blockBuffer.allocate(24L);
            IoUtils.longToBuffer((long)next, (byte[])this.ioBuffer, (int)0);
            IoUtils.longToBuffer((long)prev, (byte[])this.ioBuffer, (int)8);
            IoUtils.longToBuffer((long)-1L, (byte[])this.ioBuffer, (int)16);
            this.blockBuffer.put(newPtr, 0L, this.ioBuffer, 0, 24);
        } else {
            long dataSize = this.serializer.getSerializedSize(element);
            newPtr = this.blockBuffer.allocate(24L + dataSize);
            IoUtils.longToBuffer((long)next, (byte[])this.ioBuffer, (int)0);
            IoUtils.longToBuffer((long)prev, (byte[])this.ioBuffer, (int)8);
            IoUtils.longToBuffer((long)dataSize, (byte[])this.ioBuffer, (int)16);
            this.blockBuffer.put(newPtr, 0L, this.ioBuffer, 0, 24);
            OutputStream out = this.blockBuffer.getOutputStream(newPtr, 24L, dataSize);
            try {
                this.serializer.serialize(element, out);
            }
            finally {
                out.close();
            }
        }
        this.blockBuffer.barrier(false);
        if (prev == -2L) {
            this.setHead(newPtr);
        } else {
            this.setNext(prev, newPtr);
        }
        if (next == -2L) {
            this.setTail(newPtr);
        } else {
            this.setPrev(next, newPtr);
        }
        this.blockBuffer.barrier(true);
        ++this._size;
        return newPtr;
    }

    private void addFirstEntry(E element) throws IOException {
        this.addEntry(-2L, -2L, element);
    }

    private void addBefore(E element, long ptr) throws IOException {
        this.addEntry(ptr, this.getPrev(ptr), element);
    }

    private void addAfter(E element, long ptr) throws IOException {
        this.addEntry(this.getNext(ptr), ptr, element);
    }

    protected void checkConsistency(boolean autoCorrect) throws IOException, IllegalStateException {
        this.checkConsistency(autoCorrect, false);
    }

    private void dumpPointer(long ptr) throws IOException {
        System.err.println("_head=" + this._head);
        if (this._head != -2L) {
            System.err.println("  _head->next=" + this.getNext(this._head));
        }
        if (this._head != -2L) {
            System.err.println("  _head->prev=" + this.getPrev(this._head));
        }
        System.err.println("ptr=" + ptr);
        if (ptr != -2L) {
            long next = this.getNext(ptr);
            System.err.println("  ptr.next=" + next);
            if (next != -2L) {
                System.err.println("    ptr->next.next=" + this.getNext(next));
                System.err.println("    ptr->next.prev=" + this.getPrev(next));
            }
            long prev = this.getPrev(ptr);
            System.err.println("  ptr.prev=" + prev);
            if (prev != -2L) {
                System.err.println("    ptr->prev.next=" + this.getNext(prev));
                System.err.println("    ptr->prev.prev=" + this.getPrev(prev));
            }
        }
        System.err.println("_tail=" + this._tail);
        if (this._tail != -2L) {
            System.err.println("  _tail->next=" + this.getNext(this._tail));
        }
        if (this._tail != -2L) {
            System.err.println("  _tail->prev=" + this.getPrev(this._tail));
        }
    }

    private void checkConsistency(boolean autoCorrect, boolean isInit) throws IOException, IllegalStateException {
        if (autoCorrect && this.blockBuffer.getProtectionLevel() == ProtectionLevel.READ_ONLY) {
            throw new IllegalArgumentException("autoCorrect on read-only block buffer is not allowed");
        }
        Iterator<Long> ids = this.blockBuffer.iterateBlockIds();
        if (ids.hasNext()) {
            long next;
            long next2;
            long prev;
            long correctMetaDataBlockId = ids.next();
            if (this.metaDataBlockId != correctMetaDataBlockId) {
                if (!isInit) {
                    if (!autoCorrect) {
                        throw new IllegalStateException("metaDataBlockId!=correctMetaDataBlockId: " + this.metaDataBlockId + "!=" + correctMetaDataBlockId);
                    }
                    logger.info("metaDataBlockId!=correctMetaDataBlockId: " + this.metaDataBlockId + "!=" + correctMetaDataBlockId + " - correcting");
                }
                this.metaDataBlockId = correctMetaDataBlockId;
            }
            this.blockBuffer.get(this.metaDataBlockId, 0L, this.ioBuffer, 0, MAGIC.length);
            if (!AoArrays.equals((byte[])this.ioBuffer, (byte[])MAGIC, (int)0, (int)MAGIC.length)) {
                throw new IllegalStateException("File does not appear to be a PersistentLinkedList (MAGIC mismatch)");
            }
            int version = this.blockBuffer.getInt(this.metaDataBlockId, MAGIC.length);
            if (version != 3) {
                throw new IllegalStateException("Unsupported file version: " + version);
            }
            HashMap<Long, Boolean> allocatedIds = new HashMap<Long, Boolean>();
            while (ids.hasNext()) {
                allocatedIds.put(ids.next(), false);
            }
            long correctHead = this.blockBuffer.getLong(this.metaDataBlockId, HEAD_OFFSET);
            if (this._head != correctHead) {
                if (!isInit) {
                    if (!autoCorrect) {
                        throw new IllegalStateException("_head!=correctHead: " + this._head + "!=" + correctHead);
                    }
                    logger.info("_head!=correctMetaDataBlockId: " + this._head + "!=" + correctHead + " - correcting");
                }
                this._head = correctHead;
            }
            if (this._head != -2L && !allocatedIds.containsKey(this._head)) {
                throw new IllegalStateException("_head points to unallocated block: " + this._head);
            }
            long correctTail = this.blockBuffer.getLong(this.metaDataBlockId, TAIL_OFFSET);
            if (this._tail != correctTail) {
                if (!isInit) {
                    if (!autoCorrect) {
                        throw new IllegalStateException("_tail!=correctTail: " + this._tail + "!=" + correctTail);
                    }
                    logger.info("_tail!=correctMetaDataBlockId: " + this._tail + "!=" + correctTail + " - correcting");
                }
                this._tail = correctTail;
            }
            if (this._tail != -2L && !allocatedIds.containsKey(this._tail)) {
                throw new IllegalStateException("_tail points to unallocated block: " + this._tail);
            }
            if (this._head == -2L && this._tail != -2L) {
                if (!autoCorrect) {
                    throw new IllegalStateException("_head==END_PTR && _tail!=END_PTR: _tail=" + this._tail);
                }
                logger.info("_head==END_PTR && _tail!=END_PTR: _tail=" + this._tail + " - recovering partial add or remove");
                prev = this.getPrev(this._tail);
                if (prev != -2L) {
                    throw new IllegalStateException("_tail->prev!=END_PTR: " + prev);
                }
                next2 = this.getNext(this._tail);
                if (next2 != -2L) {
                    throw new IllegalStateException("_tail->next!=END_PTR: " + next2);
                }
                this.setHead(this._tail);
            }
            if (this._tail == -2L && this._head != -2L) {
                if (!autoCorrect) {
                    throw new IllegalStateException("_tail==END_PTR && _head!=END_PTR: _head=" + this._head);
                }
                logger.info("_tail==END_PTR && _head!=END_PTR: _head=" + this._head + " - recovering partial add or remove");
                prev = this.getPrev(this._head);
                if (prev != -2L) {
                    throw new IllegalStateException("_head->prev!=END_PTR: " + prev);
                }
                next2 = this.getNext(this._head);
                if (next2 != -2L) {
                    throw new IllegalStateException("_head->next!=END_PTR: " + next2);
                }
                this.setTail(this._head);
            }
            if (this._head != -2L && (prev = this.getPrev(this._head)) != -2L) {
                if (!autoCorrect) {
                    throw new IllegalStateException("_head->prev!=END_PTR: _head=" + this._head + ", _head->prev=" + prev);
                }
                if (!allocatedIds.containsKey(prev)) {
                    throw new IllegalStateException("_head->prev points to unallocated block: _head=" + this._head + ", _head->prev=" + prev);
                }
                logger.info("_head->prev!=END_PTR: " + prev + " - recovering partial add or remove");
                long prevPrev = this.getPrev(prev);
                if (prevPrev != -2L) {
                    throw new IllegalStateException("_head->prev!=END_PTR: _head=" + this._head + ", _head->prev=" + prev + " - unrecoverable because _head->prev.prev!=END_PTR: " + prevPrev);
                }
                long prevNext = this.getNext(prev);
                if (prevNext != this._head) {
                    throw new IllegalStateException("_head->prev!=END_PTR: _head=" + this._head + ", _head->prev=" + prev + " - unrecoverable because _head->prev.next!=_head: " + prevNext);
                }
                this.setHead(prev);
            }
            if (this._tail != -2L && (next = this.getNext(this._tail)) != -2L) {
                if (!autoCorrect) {
                    throw new IllegalStateException("_tail->next!=END_PTR: _tail=" + this._tail + ", _tail->next=" + next);
                }
                if (!allocatedIds.containsKey(next)) {
                    throw new IllegalStateException("_tail->next points to unallocated block: _tail=" + this._tail + ", _tail->next=" + next);
                }
                logger.info("_tail->next!=END_PTR: " + next + " - recovering partial add or remove");
                long nextNext = this.getNext(next);
                if (nextNext != -2L) {
                    throw new IllegalStateException("_tail->next!=END_PTR: _tail=" + this._tail + ", _tail->next=" + next + " - unrecoverable because _tail->next.next!=END_PTR: " + nextNext);
                }
                long nextPrev = this.getPrev(next);
                if (nextPrev != this._tail) {
                    throw new IllegalStateException("_tail->next!=END_PTR: _tail=" + this._tail + ", _tail->next=" + next + " - unrecoverable because _tail->next.prev!=_tail: " + nextPrev);
                }
                this.setTail(next);
            }
            long count = 0L;
            long ptr = this._head;
            while (ptr != -2L) {
                long next3;
                Boolean seen = (Boolean)allocatedIds.get(ptr);
                if (seen == null) {
                    throw new IllegalStateException("ptr points to unallocated block: " + ptr);
                }
                if (seen.booleanValue()) {
                    throw new IllegalStateException("ptr seen more than once, loop in list: " + ptr);
                }
                allocatedIds.put(ptr, Boolean.TRUE);
                long prev2 = this.getPrev(ptr);
                if (prev2 == -2L) {
                    if (this._head != ptr) {
                        this.dumpPointer(ptr);
                        throw new IllegalStateException("ptr.prev==END_PTR while _head!=ptr: ptr=" + ptr + ", _head=" + this._head);
                    }
                } else {
                    if (!allocatedIds.containsKey(prev2)) {
                        throw new IllegalStateException("ptr.prev points to unallocated block: ptr=" + ptr + ", ptr.prev=" + prev2);
                    }
                    long prevNext = this.getNext(prev2);
                    if (prevNext != ptr) {
                        this.dumpPointer(ptr);
                        throw new IllegalStateException("ptr.prev->next!=ptr: ptr=" + ptr + ", ptr.prev=" + prev2 + ", ptr.prev->next=" + prevNext);
                    }
                }
                if ((next3 = this.getNext(ptr)) == -2L) {
                    if (this._tail != ptr) {
                        if (!autoCorrect) {
                            throw new IllegalStateException("ptr.next==END_PTR while _tail!=ptr: ptr=" + ptr + ", _tail=" + this._tail);
                        }
                        logger.info("ptr.next==END_PTR while _tail!=ptr: ptr=" + ptr + ", _tail=" + this._tail + " - recovering partial add or remove");
                        if (this._tail == -2L) {
                            throw new IllegalStateException("ptr.next==END_PTR while _tail!=ptr: ptr=" + ptr + ", _tail=" + this._tail + " - unrecoverable because _tail==END_PTR");
                        }
                        long tailPrev = this.getPrev(this._tail);
                        if (tailPrev != ptr) {
                            throw new IllegalStateException("ptr.next==END_PTR while _tail!=ptr: ptr=" + ptr + ", _tail=" + this._tail + " - unrecoverable because _tail->prev!=ptr: " + tailPrev);
                        }
                        long tailNext = this.getNext(this._tail);
                        if (tailNext != -2L) {
                            throw new IllegalStateException("ptr.next==END_PTR while _tail!=ptr: ptr=" + ptr + ", _tail=" + this._tail + " - unrecoverable because _tail->next!=END_PTR: " + tailNext);
                        }
                        next3 = this._tail;
                        this.setNext(ptr, next3);
                    }
                } else {
                    if (!allocatedIds.containsKey(next3)) {
                        throw new IllegalStateException("ptr.next points to unallocated block: ptr=" + ptr + ", ptr.next=" + next3);
                    }
                    long nextPrev = this.getPrev(next3);
                    if (nextPrev != ptr) {
                        if (!autoCorrect) {
                            throw new IllegalStateException("ptr.next->prev!=ptr: ptr=" + ptr + ", ptr.prev=" + prev2 + ", ptr.next=" + next3 + ", ptr.next->prev=" + nextPrev);
                        }
                        logger.info("ptr.next->prev!=ptr: ptr=" + ptr + ", ptr.prev=" + prev2 + ", ptr.next=" + next3 + ", ptr.next->prev=" + nextPrev + " - recovering partial add or remove");
                        if (nextPrev != prev2) {
                            throw new IllegalStateException("ptr.next->prev!=ptr: ptr=" + ptr + ", ptr.prev=" + prev2 + ", ptr.next=" + next3 + ", ptr.next->prev=" + nextPrev + " - unrecoverable because ptr.next->prev!=ptr.prev");
                        }
                        this.setPrev(next3, ptr);
                    }
                }
                ptr = next3;
                ++count;
            }
            long firstUnreferencedBlockId = -1L;
            long unreferencedCount = 0L;
            for (Map.Entry entry : allocatedIds.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                if (firstUnreferencedBlockId == -1L) {
                    firstUnreferencedBlockId = (Long)entry.getKey();
                }
                ++unreferencedCount;
            }
            if (unreferencedCount > 0L) {
                if (unreferencedCount > 1L) {
                    throw new IllegalStateException("More than one block allocated but not referenced: firstUnreferencedBlockId=" + firstUnreferencedBlockId + ", unreferencedCount=" + unreferencedCount);
                }
                if (!autoCorrect) {
                    throw new IllegalStateException("Block allocated but not referenced: " + firstUnreferencedBlockId);
                }
                logger.info("Block allocated but not referenced: " + firstUnreferencedBlockId + " - deallocating");
                this.blockBuffer.deallocate(firstUnreferencedBlockId);
            }
            if (this._size != count) {
                if (!isInit) {
                    if (!autoCorrect) {
                        throw new IllegalStateException("_size!=count: " + this._size + "!=" + count);
                    }
                    logger.info("_size!=count: " + this._size + "!=" + count + " - correcting");
                }
                this._size = count;
            }
        } else {
            if (!autoCorrect) {
                throw new IllegalStateException("Block buffer is empty - no meta data block found.");
            }
            if (!isInit) {
                logger.info("Block buffer is empty - initializing meta data block.");
            }
            this.metaDataBlockId = this.blockBuffer.allocate(HEADER_SIZE);
            this.blockBuffer.put(this.metaDataBlockId, 0L, MAGIC, 0, MAGIC.length);
            this.blockBuffer.putInt(this.metaDataBlockId, MAGIC.length, 3);
            this.setHead(-2L);
            this.setTail(-2L);
            this.blockBuffer.barrier(true);
            this._size = 0L;
        }
    }

    @Override
    public E getFirst() {
        long head = this.getHead();
        if (head == -2L) {
            throw new NoSuchElementException();
        }
        try {
            return this.getElement(head);
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E getLast() {
        long tail = this.getTail();
        if (tail == -2L) {
            throw new NoSuchElementException();
        }
        try {
            return this.getElement(tail);
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E removeFirst() {
        long head = this.getHead();
        if (head == -2L) {
            throw new NoSuchElementException();
        }
        try {
            ++this.modCount;
            E element = this.getElement(head);
            this.remove(head);
            return element;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E removeLast() {
        long tail = this.getTail();
        if (tail == -2L) {
            throw new NoSuchElementException();
        }
        try {
            ++this.modCount;
            E element = this.getElement(tail);
            this.remove(tail);
            return element;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public void addFirst(E element) {
        try {
            ++this.modCount;
            long head = this.getHead();
            if (head == -2L) {
                this.addFirstEntry(element);
            } else {
                this.addBefore(element, head);
            }
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public void addLast(E element) {
        try {
            ++this.modCount;
            long tail = this.getTail();
            if (tail == -2L) {
                this.addFirstEntry(element);
            } else {
                this.addAfter(element, tail);
            }
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    private long getPointerForIndex(long index) throws IOException {
        if (index < this._size >> 1) {
            long ptr = this.getHead();
            int i = 0;
            while ((long)i < index) {
                ptr = this.getNext(ptr);
                ++i;
            }
            return ptr;
        }
        long bptr = this.getTail();
        for (long i = this._size - 1L; i > index; --i) {
            bptr = this.getPrev(bptr);
        }
        return bptr;
    }

    @Override
    public boolean remove(Object o) {
        try {
            if (o == null) {
                long ptr = this.getHead();
                while (ptr != -2L) {
                    if (this.isNull(ptr)) {
                        ++this.modCount;
                        this.remove(ptr);
                        return true;
                    }
                    ptr = this.getNext(ptr);
                }
            } else {
                long ptr = this.getHead();
                while (ptr != -2L) {
                    if (o.equals(this.getElement(ptr))) {
                        ++this.modCount;
                        this.remove(ptr);
                        return true;
                    }
                    ptr = this.getNext(ptr);
                }
            }
            return false;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        ++this.modCount;
        for (E element : c) {
            this.addLast(element);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if ((long)index == this._size) {
            return this.addAll(c);
        }
        if (c.isEmpty()) {
            return false;
        }
        if (index < 0 || (long)index > this._size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._size);
        }
        ++this.modCount;
        try {
            long ptr = this.getPointerForIndex(index);
            for (E element : c) {
                this.addBefore(element, ptr);
            }
            return true;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public int size() {
        return this._size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._size;
    }

    @Override
    public boolean add(E element) {
        this.addLast(element);
        return true;
    }

    @Override
    public void clear() {
        try {
            ++this.modCount;
            Iterator<Long> ids = this.blockBuffer.iterateBlockIds();
            if (!ids.hasNext()) {
                throw new AssertionError((Object)"Block buffer is empty - no meta data block found.");
            }
            long firstId = ids.next();
            if (this.metaDataBlockId != firstId) {
                throw new AssertionError((Object)("metaDataBlockId!=firstId: " + this.metaDataBlockId + "!=" + firstId));
            }
            this.setHead(-2L);
            this.setTail(-2L);
            this._size = 0L;
            this.blockBuffer.barrier(false);
            while (ids.hasNext()) {
                ids.next();
                ids.remove();
            }
            this.blockBuffer.barrier(true);
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E get(int index) {
        try {
            return this.getElement(this.getPointerForIndex(index));
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    private void setElement(long ptr, E element) {
        ++this.modCount;
        try {
            long prev = this.getPrev(ptr);
            this.remove(ptr);
            if (prev == -2L) {
                this.addFirst(element);
            } else {
                this.addAfter(element, prev);
            }
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E set(int index, E element) {
        try {
            long ptr = this.getPointerForIndex(index);
            E oldElement = this.getElement(ptr);
            this.setElement(ptr, element);
            return oldElement;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public void add(int index, E element) {
        ++this.modCount;
        try {
            long ptr = this.getPointerForIndex(index);
            long prev = this.getPrev(ptr);
            if (prev == -2L) {
                this.addFirst(element);
            } else {
                this.addAfter(element, prev);
            }
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E remove(int index) {
        ++this.modCount;
        try {
            long ptr = this.getPointerForIndex(index);
            E oldElement = this.getElement(ptr);
            this.remove(ptr);
            return oldElement;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public int indexOf(Object o) {
        try {
            int index = 0;
            if (o == null) {
                long ptr = this.getHead();
                while (ptr != -2L) {
                    if (this.isNull(ptr)) {
                        return index;
                    }
                    ++index;
                    ptr = this.getNext(ptr);
                }
            } else {
                long ptr = this.getHead();
                while (ptr != -2L) {
                    if (o.equals(this.getElement(ptr))) {
                        return index;
                    }
                    ++index;
                    ptr = this.getNext(ptr);
                }
            }
            return -1;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        try {
            long index = this._size;
            if (o == null) {
                long ptr = this.getTail();
                while (ptr != -2L) {
                    --index;
                    if (this.isNull(ptr)) {
                        if (index > Integer.MAX_VALUE) {
                            throw new RuntimeException("Index too high to return from lastIndexOf: " + index);
                        }
                        return (int)index;
                    }
                    ptr = this.getPrev(ptr);
                }
            } else {
                long ptr = this.getTail();
                while (ptr != -2L) {
                    --index;
                    if (o.equals(this.getElement(ptr))) {
                        if (index > Integer.MAX_VALUE) {
                            throw new RuntimeException("Index too high to return from lastIndexOf: " + index);
                        }
                        return (int)index;
                    }
                    ptr = this.getPrev(ptr);
                }
            }
            return -1;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public E peek() {
        if (this._size == 0L) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E poll() {
        if (this._size == 0L) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    public E peekFirst() {
        if (this._size == 0L) {
            return null;
        }
        return this.getFirst();
    }

    public E peekLast() {
        if (this._size == 0L) {
            return null;
        }
        return this.getLast();
    }

    public E pollFirst() {
        if (this._size == 0L) {
            return null;
        }
        return this.removeFirst();
    }

    public E pollLast() {
        if (this._size == 0L) {
            return null;
        }
        return this.removeLast();
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    public boolean removeLastOccurrence(Object o) {
        try {
            if (o == null) {
                long ptr = this.getTail();
                while (ptr != -2L) {
                    if (this.isNull(ptr)) {
                        ++this.modCount;
                        this.remove(ptr);
                        return true;
                    }
                    ptr = this.getPrev(ptr);
                }
            } else {
                long ptr = this.getTail();
                while (ptr != -2L) {
                    if (o.equals(this.getElement(ptr))) {
                        ++this.modCount;
                        this.remove(ptr);
                        return true;
                    }
                    ptr = this.getPrev(ptr);
                }
            }
            return false;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public Object[] toArray() {
        try {
            if (this._size > Integer.MAX_VALUE) {
                throw new RuntimeException("Too many elements in list to create Object[]: " + this._size);
            }
            Object[] result = new Object[(int)this._size];
            int i = 0;
            long ptr = this.getHead();
            while (ptr != -2L) {
                result[i++] = this.getElement(ptr);
                ptr = this.getNext(ptr);
            }
            return result;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this._size > Integer.MAX_VALUE) {
            throw new RuntimeException("Too many elements in list to fill or create array: " + this._size);
        }
        try {
            if ((long)a.length < this._size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), (int)this._size);
            }
            int i = 0;
            T[] result = a;
            long ptr = this.getHead();
            while (ptr != -2L) {
                result[i++] = this.getElement(ptr);
                ptr = this.getNext(ptr);
            }
            if ((long)a.length > this._size) {
                a[(int)this._size] = null;
            }
            return a;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void close() throws IOException {
        if (!this.blockBuffer.isClosed()) {
            this.blockBuffer.close();
        }
    }

    static /* synthetic */ int access$000(PersistentLinkedList x0) {
        return x0.modCount;
    }

    private class DescendingIterator
    implements Iterator<E> {
        final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(PersistentLinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class ListItr
    implements ListIterator<E> {
        private long lastReturned = -2L;
        private long nextPtr;
        private long nextIndex;
        private int expectedModCount = PersistentLinkedList.access$000(PersistentLinkedList.this);

        ListItr(long index) {
            if (index < 0L || index > PersistentLinkedList.this._size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + PersistentLinkedList.this._size);
            }
            try {
                if (index == PersistentLinkedList.this._size) {
                    this.nextPtr = -2L;
                    this.nextIndex = PersistentLinkedList.this._size;
                } else {
                    this.nextPtr = PersistentLinkedList.this.getPointerForIndex(index);
                    this.nextIndex = index;
                }
            }
            catch (IOException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != PersistentLinkedList.this._size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (this.nextIndex == PersistentLinkedList.this._size) {
                throw new NoSuchElementException();
            }
            try {
                this.lastReturned = this.nextPtr;
                this.nextPtr = PersistentLinkedList.this.getNext(this.nextPtr);
                ++this.nextIndex;
                assert (this.nextPtr == -2L && this.nextIndex == PersistentLinkedList.this._size || this.nextPtr != -2L && this.nextIndex < PersistentLinkedList.this._size);
                return PersistentLinkedList.this.getElement(this.lastReturned);
            }
            catch (IOException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0L;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (this.nextIndex == 0L) {
                throw new NoSuchElementException();
            }
            try {
                this.nextPtr = this.nextPtr == -2L ? PersistentLinkedList.this.getTail() : PersistentLinkedList.this.getPrev(this.nextPtr);
                this.lastReturned = this.nextPtr;
                --this.nextIndex;
                assert (this.nextPtr == -2L && this.nextIndex == PersistentLinkedList.this._size || this.nextPtr != -2L && this.nextIndex < PersistentLinkedList.this._size);
                return PersistentLinkedList.this.getElement(this.lastReturned);
            }
            catch (IOException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public int nextIndex() {
            if (this.nextIndex > Integer.MAX_VALUE) {
                throw new RuntimeException("Index too high to return from nextIndex: " + this.nextIndex);
            }
            assert (this.nextIndex >= 0L);
            return (int)this.nextIndex;
        }

        @Override
        public int previousIndex() {
            long prevIndex = this.nextIndex - 1L;
            if (prevIndex > Integer.MAX_VALUE) {
                throw new RuntimeException("Index too high to return from previousIndex: " + prevIndex);
            }
            assert (prevIndex >= 0L);
            return (int)prevIndex;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            try {
                long lastNext = PersistentLinkedList.this.getNext(this.lastReturned);
                try {
                    PersistentLinkedList.this.remove(this.lastReturned);
                }
                catch (NoSuchElementException e) {
                    throw new IllegalStateException();
                }
                if (this.nextPtr == this.lastReturned) {
                    this.nextPtr = lastNext;
                } else {
                    --this.nextIndex;
                }
                this.lastReturned = -2L;
                ++this.expectedModCount;
                assert (this.nextPtr == -2L && this.nextIndex == PersistentLinkedList.this._size || this.nextPtr != -2L && this.nextIndex < PersistentLinkedList.this._size);
            }
            catch (IOException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == -2L) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            PersistentLinkedList.this.setElement(this.lastReturned, e);
            ++this.expectedModCount;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                this.lastReturned = -2L;
                PersistentLinkedList.this.modCount++;
                PersistentLinkedList.this.addBefore(e, this.nextPtr);
                ++this.nextIndex;
                ++this.expectedModCount;
            }
            catch (IOException err) {
                throw new WrappedException((Throwable)err);
            }
        }

        final void checkForComodification() {
            if (PersistentLinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

