/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.AoArrays;
import com.aoindustries.util.BufferManager;
import com.aoindustries.util.persistent.BooleanSerializer;
import com.aoindustries.util.persistent.ByteArraySerializer;
import com.aoindustries.util.persistent.ByteSerializer;
import com.aoindustries.util.persistent.CharArraySerializer;
import com.aoindustries.util.persistent.CharacterSerializer;
import com.aoindustries.util.persistent.DoubleSerializer;
import com.aoindustries.util.persistent.DynamicPersistentBlockBuffer;
import com.aoindustries.util.persistent.FixedPersistentBlockBuffer;
import com.aoindustries.util.persistent.FloatSerializer;
import com.aoindustries.util.persistent.IntegerSerializer;
import com.aoindustries.util.persistent.LargeMappedPersistentBuffer;
import com.aoindustries.util.persistent.LongSerializer;
import com.aoindustries.util.persistent.MappedPersistentBuffer;
import com.aoindustries.util.persistent.ObjectSerializer;
import com.aoindustries.util.persistent.PersistentBlockBuffer;
import com.aoindustries.util.persistent.PersistentBuffer;
import com.aoindustries.util.persistent.ProtectionLevel;
import com.aoindustries.util.persistent.RandomAccessFileBuffer;
import com.aoindustries.util.persistent.Serializer;
import com.aoindustries.util.persistent.ShortSerializer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistentCollections {
    private static final Logger logger = Logger.getLogger(PersistentCollections.class.getName());
    static final boolean ASSERT = false;
    private static final byte[] zeros = new byte[4096];

    private PersistentCollections() {
    }

    @Deprecated
    public static void charToBuffer(char ch, byte[] ioBuffer) {
        IoUtils.charToBuffer((char)ch, (byte[])ioBuffer);
    }

    @Deprecated
    public static void charToBuffer(char ch, byte[] ioBuffer, int off) {
        IoUtils.charToBuffer((char)ch, (byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static char bufferToChar(byte[] ioBuffer) {
        return IoUtils.bufferToChar((byte[])ioBuffer);
    }

    @Deprecated
    public static char bufferToChar(byte[] ioBuffer, int off) {
        return IoUtils.bufferToChar((byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static void shortToBuffer(short s, byte[] ioBuffer) {
        IoUtils.shortToBuffer((short)s, (byte[])ioBuffer);
    }

    @Deprecated
    public static void shortToBuffer(short s, byte[] ioBuffer, int off) {
        IoUtils.shortToBuffer((short)s, (byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static short bufferToShort(byte[] ioBuffer) {
        return IoUtils.bufferToShort((byte[])ioBuffer);
    }

    @Deprecated
    public static short bufferToShort(byte[] ioBuffer, int off) {
        return IoUtils.bufferToShort((byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static void intToBuffer(int i, byte[] ioBuffer) {
        IoUtils.intToBuffer((int)i, (byte[])ioBuffer);
    }

    @Deprecated
    public static void intToBuffer(int i, byte[] ioBuffer, int off) {
        IoUtils.intToBuffer((int)i, (byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static int bufferToInt(byte[] ioBuffer) {
        return IoUtils.bufferToInt((byte[])ioBuffer);
    }

    @Deprecated
    public static int bufferToInt(byte[] ioBuffer, int off) {
        return IoUtils.bufferToInt((byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static void longToBuffer(long l, byte[] ioBuffer) {
        IoUtils.longToBuffer((long)l, (byte[])ioBuffer);
    }

    @Deprecated
    public static void longToBuffer(long l, byte[] ioBuffer, int off) {
        IoUtils.longToBuffer((long)l, (byte[])ioBuffer, (int)off);
    }

    @Deprecated
    public static long bufferToLong(byte[] ioBuffer) {
        return IoUtils.bufferToLong((byte[])ioBuffer);
    }

    @Deprecated
    public static long bufferToLong(byte[] ioBuffer, int off) {
        return IoUtils.bufferToLong((byte[])ioBuffer, (int)off);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureZeros(RandomAccessFile raf, long position, long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException("count<0: " + count);
        }
        boolean modified = false;
        byte[] buff = BufferManager.getBytes();
        try {
            while (count > 4096L) {
                raf.seek(position);
                raf.readFully(buff, 0, 4096);
                if (!Arrays.equals(buff, zeros)) {
                    raf.seek(position);
                    raf.write(zeros, 0, 4096);
                    modified = true;
                }
                position += 4096L;
                count -= 4096L;
            }
            if (count > 0L) {
                raf.seek(position);
                raf.readFully(buff, 0, (int)count);
                if (!AoArrays.equals((byte[])buff, (byte[])zeros, (int)0, (int)((int)count))) {
                    raf.seek(position);
                    raf.write(zeros, 0, (int)count);
                    modified = true;
                }
            }
        }
        finally {
            BufferManager.release((byte[])buff, (boolean)false);
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureZeros(ByteBuffer byteBuffer, int position, int count) throws IOException {
        if (count < 0) {
            throw new IllegalArgumentException("count<0: " + count);
        }
        boolean modified = false;
        ByteOrder previousByteOrder = byteBuffer.order();
        ByteOrder nativeByteOrder = ByteOrder.nativeOrder();
        try {
            int nextCount;
            byte b;
            if (previousByteOrder != nativeByteOrder) {
                byteBuffer.order(nativeByteOrder);
            }
            byteBuffer.position(position);
            while (count > 0 && (position & 7) != 0) {
                b = byteBuffer.get();
                if (b != 0) {
                    byteBuffer.put(position, (byte)0);
                    modified = true;
                }
                ++position;
                --count;
            }
            while ((nextCount = count - 8) >= 0) {
                if (byteBuffer.getLong() != 0L) {
                    byteBuffer.putLong(position, 0L);
                    modified = true;
                }
                position += 8;
                count = nextCount;
            }
            while (count > 0) {
                b = byteBuffer.get();
                if (b != 0) {
                    byteBuffer.put(position, (byte)0);
                    modified = true;
                }
                ++position;
                --count;
            }
        }
        finally {
            if (previousByteOrder != nativeByteOrder) {
                byteBuffer.order(previousByteOrder);
            }
        }
        return modified;
    }

    public static PersistentBuffer getPersistentBuffer(long maximumCapacity) throws IOException {
        if (maximumCapacity < 0x40000000L) {
            return new MappedPersistentBuffer();
        }
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new RandomAccessFileBuffer();
        }
        if (!"64".equals(dataModel)) {
            logger.log(Level.WARNING, "Unexpected value for system property sun.arch.data.model, assuming 64-bit virtual machine: sun.arch.data.model={0}", dataModel);
        }
        return new LargeMappedPersistentBuffer();
    }

    public static PersistentBuffer getPersistentBuffer(RandomAccessFile raf, ProtectionLevel protectionLevel, long maximumCapacity) throws IOException {
        long len;
        if (maximumCapacity < 0x40000000L && maximumCapacity < (len = raf.length())) {
            maximumCapacity = len;
        }
        if (maximumCapacity < 0x40000000L) {
            return new MappedPersistentBuffer(raf, protectionLevel);
        }
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new RandomAccessFileBuffer(raf, protectionLevel);
        }
        if (!"64".equals(dataModel)) {
            logger.log(Level.WARNING, "Unexpected value for system property sun.arch.data.model, assuming 64-bit virtual machine: sun.arch.data.model={0}", dataModel);
        }
        return new LargeMappedPersistentBuffer(raf, protectionLevel);
    }

    public static <E> Serializer<E> getSerializer(Class<E> type) {
        if (type == Boolean.class) {
            return new BooleanSerializer();
        }
        if (type == Byte.class) {
            return new ByteSerializer();
        }
        if (type == Character.class) {
            return new CharacterSerializer();
        }
        if (type == Double.class) {
            return new DoubleSerializer();
        }
        if (type == Float.class) {
            return new FloatSerializer();
        }
        if (type == Integer.class) {
            return new IntegerSerializer();
        }
        if (type == Long.class) {
            return new LongSerializer();
        }
        if (type == Short.class) {
            return new ShortSerializer();
        }
        Class<?> componentType = type.getComponentType();
        if (componentType != null) {
            if (componentType == Byte.class) {
                return new ByteArraySerializer();
            }
            if (componentType == Character.class) {
                return new CharArraySerializer();
            }
        }
        return new ObjectSerializer<E>(type);
    }

    public static PersistentBlockBuffer getPersistentBlockBuffer(Serializer<?> serializer, PersistentBuffer pbuffer, long additionalBlockSpace) throws IOException {
        if (additionalBlockSpace < 0L) {
            throw new IllegalArgumentException("additionalBlockSpace<0: " + additionalBlockSpace);
        }
        if (serializer.isFixedSerializedSize()) {
            long highestOneBit;
            long serSize = serializer.getSerializedSize(null);
            long minimumSize = serSize + additionalBlockSpace;
            if (minimumSize < 0L) {
                throw new AssertionError((Object)("Long wraparound: " + serSize + "+" + minimumSize + "=" + minimumSize));
            }
            if (minimumSize == 0L) {
                minimumSize = 1L;
            }
            return new FixedPersistentBlockBuffer(pbuffer, (highestOneBit = Long.highestOneBit(minimumSize)) == 0x4000000000000000L ? minimumSize : (minimumSize == highestOneBit ? minimumSize : highestOneBit << 1));
        }
        return new DynamicPersistentBlockBuffer(pbuffer);
    }
}

