/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LongSerializer
implements Serializer<Long> {
    private final byte[] buffer = new byte[8];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Long value) {
        return 8L;
    }

    @Override
    public void serialize(Long value, OutputStream out) throws IOException {
        IoUtils.longToBuffer((long)value, (byte[])this.buffer);
        out.write(this.buffer, 0, 8);
    }

    @Override
    public Long deserialize(InputStream in) throws IOException {
        IoUtils.readFully((InputStream)in, (byte[])this.buffer, (int)0, (int)8);
        return IoUtils.bufferToLong((byte[])this.buffer);
    }
}

