/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.FileUtils;
import com.aoindustries.util.persistent.AbstractPersistentBuffer;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.ProtectionLevel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class LargeMappedPersistentBuffer
extends AbstractPersistentBuffer {
    private static final int BUFFER_NUM_BIT_SHIFT = 30;
    private static final int BUFFER_SIZE = 0x40000000;
    private static final int BUFFER_INDEX_MASK = 0x3FFFFFFF;
    private final File tempFile;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final List<MappedByteBuffer> mappedBuffers = new ArrayList<MappedByteBuffer>();
    private final List<Boolean> modifiedBuffers;
    private boolean closed;

    public LargeMappedPersistentBuffer() throws IOException {
        super(ProtectionLevel.NONE);
        this.tempFile = File.createTempFile("LargeMappedPersistentBuffer", null);
        this.tempFile.deleteOnExit();
        this.raf = new RandomAccessFile(this.tempFile, "rw");
        this.channel = this.raf.getChannel();
        this.channel.lock(0L, Long.MAX_VALUE, false);
        this.modifiedBuffers = null;
        this.fillMappedBuffers();
    }

    public LargeMappedPersistentBuffer(String name) throws IOException {
        this(new RandomAccessFile(name, "rw"), ProtectionLevel.BARRIER);
    }

    public LargeMappedPersistentBuffer(String name, ProtectionLevel protectionLevel) throws IOException {
        this(new RandomAccessFile(name, protectionLevel == ProtectionLevel.READ_ONLY ? "r" : "rw"), protectionLevel);
    }

    public LargeMappedPersistentBuffer(File file) throws IOException {
        this(new RandomAccessFile(file, "rw"), ProtectionLevel.BARRIER);
    }

    public LargeMappedPersistentBuffer(File file, ProtectionLevel protectionLevel) throws IOException {
        this(new RandomAccessFile(file, protectionLevel == ProtectionLevel.READ_ONLY ? "r" : "rw"), protectionLevel);
    }

    public LargeMappedPersistentBuffer(RandomAccessFile raf, ProtectionLevel protectionLevel) throws IOException {
        super(protectionLevel);
        this.tempFile = null;
        this.raf = raf;
        this.channel = raf.getChannel();
        this.channel.lock(0L, Long.MAX_VALUE, protectionLevel == ProtectionLevel.READ_ONLY);
        this.modifiedBuffers = protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0 ? new ArrayList<Boolean>() : null;
        this.fillMappedBuffers();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.raf.close();
        if (this.tempFile != null && this.tempFile.exists()) {
            FileUtils.delete((File)this.tempFile);
        }
    }

    @Override
    public long capacity() throws IOException {
        return this.raf.length();
    }

    private void fillMappedBuffers() throws IOException {
        long len = this.raf.length();
        long maxBuffNum = len >>> 30;
        if (maxBuffNum >= Integer.MAX_VALUE) {
            throw new IOException("file too large for LargeMappedPersistentBuffer: " + len);
        }
        int buffNumInt = (int)maxBuffNum;
        while (this.mappedBuffers.size() <= buffNumInt) {
            long mapStart = (long)this.mappedBuffers.size() << 30;
            long size = this.raf.length() - mapStart;
            if (size > 0x40000000L) {
                size = 0x40000000L;
            }
            this.mappedBuffers.add(this.channel.map(this.protectionLevel == ProtectionLevel.READ_ONLY ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, mapStart, size));
            if (this.modifiedBuffers == null) continue;
            this.modifiedBuffers.add(false);
        }
    }

    private static int getBufferNum(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position<0: " + position);
        }
        long buffNum = position >>> 30;
        if (buffNum >= Integer.MAX_VALUE) {
            throw new IOException("position too large for LargeMappedPersistentBuffer: " + position);
        }
        return (int)buffNum;
    }

    private static int getIndex(long position) throws IOException {
        return (int)(position & 0x3FFFFFFFL);
    }

    @Override
    public void setCapacity(long newLength) throws IOException {
        long oldLength = this.capacity();
        if (oldLength != newLength) {
            long affectedFrom = LargeMappedPersistentBuffer.getBufferNum(Math.min(oldLength, newLength));
            while ((long)this.mappedBuffers.size() > affectedFrom) {
                int index = this.mappedBuffers.size() - 1;
                MappedByteBuffer mappedBuffer = this.mappedBuffers.get(index);
                if (this.modifiedBuffers != null) {
                    if (this.modifiedBuffers.get(index).booleanValue()) {
                        mappedBuffer.force();
                    }
                    this.modifiedBuffers.remove(index);
                }
                this.mappedBuffers.remove(index);
            }
            this.raf.setLength(newLength);
            this.fillMappedBuffers();
            if (newLength > oldLength) {
                this.ensureZeros(oldLength, newLength - oldLength);
            }
        }
    }

    @Override
    public void get(long position, byte[] buff, int off, int len) throws IOException {
        if (len > 0) {
            int bufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
            int bufferStart = LargeMappedPersistentBuffer.getIndex(position);
            int bufferSize = 0x40000000 - bufferStart;
            while (true) {
                if (bufferSize > len) {
                    bufferSize = len;
                }
                MappedByteBuffer mappedBuffer = this.mappedBuffers.get(bufferNum);
                mappedBuffer.position(bufferStart);
                mappedBuffer.get(buff, off, bufferSize);
                if ((len -= bufferSize) <= 0) {
                    assert (len == 0);
                    break;
                }
                position += (long)bufferSize;
                off += bufferSize;
                ++bufferNum;
                bufferStart = 0;
                bufferSize = 0x40000000;
            }
        }
    }

    @Override
    public int getSome(long position, byte[] buff, int off, int len) throws IOException {
        this.get(position, buff, off, len);
        return len;
    }

    @Override
    public byte get(long position) throws IOException {
        return this.mappedBuffers.get(LargeMappedPersistentBuffer.getBufferNum(position)).get(LargeMappedPersistentBuffer.getIndex(position));
    }

    @Override
    public void ensureZeros(long position, long len) throws IOException {
        if (len > 0L) {
            int bufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
            int bufferStart = LargeMappedPersistentBuffer.getIndex(position);
            int bufferSize = 0x40000000 - bufferStart;
            while (true) {
                MappedByteBuffer mappedBuffer;
                if ((long)bufferSize > len) {
                    bufferSize = (int)len;
                }
                if (PersistentCollections.ensureZeros(mappedBuffer = this.mappedBuffers.get(bufferNum), bufferStart, bufferSize) && this.modifiedBuffers != null) {
                    this.modifiedBuffers.set(bufferNum, true);
                }
                if ((len -= (long)bufferSize) <= 0L) {
                    assert (len == 0L);
                    break;
                }
                position += (long)bufferSize;
                ++bufferNum;
                bufferStart = 0;
                bufferSize = 0x40000000;
            }
        }
    }

    @Override
    public void put(long position, byte value) throws IOException {
        int bufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
        this.mappedBuffers.get(bufferNum).put(LargeMappedPersistentBuffer.getIndex(position), value);
        if (this.modifiedBuffers != null) {
            this.modifiedBuffers.set(bufferNum, true);
        }
    }

    @Override
    public void put(long position, byte[] buff, int off, int len) throws IOException {
        if (len > 0) {
            int bufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
            int bufferStart = LargeMappedPersistentBuffer.getIndex(position);
            int bufferSize = 0x40000000 - bufferStart;
            while (true) {
                if (bufferSize > len) {
                    bufferSize = len;
                }
                MappedByteBuffer mappedBuffer = this.mappedBuffers.get(bufferNum);
                mappedBuffer.position(bufferStart);
                mappedBuffer.put(buff, off, bufferSize);
                if (this.modifiedBuffers != null) {
                    this.modifiedBuffers.set(bufferNum, true);
                }
                if ((len -= bufferSize) <= 0) {
                    assert (len == 0);
                    break;
                }
                position += (long)bufferSize;
                off += bufferSize;
                ++bufferNum;
                bufferStart = 0;
                bufferSize = 0x40000000;
            }
        }
    }

    @Override
    public void barrier(boolean force) throws IOException {
        if (this.protectionLevel.compareTo(ProtectionLevel.BARRIER) >= 0) {
            int len = this.mappedBuffers.size();
            for (int c = 0; c < len; ++c) {
                if (!this.modifiedBuffers.get(c).booleanValue()) continue;
                this.mappedBuffers.get(c).force();
                this.modifiedBuffers.set(c, false);
            }
        }
    }

    @Override
    public boolean getBoolean(long position) throws IOException {
        return this.get(position) != 0;
    }

    @Override
    public int getInt(long position) throws IOException {
        int endBufferNum;
        int startBufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
        if (startBufferNum == (endBufferNum = LargeMappedPersistentBuffer.getBufferNum(position + 3L))) {
            return this.mappedBuffers.get(startBufferNum).getInt(LargeMappedPersistentBuffer.getIndex(position));
        }
        return ((this.get(position) & 0xFF) << 24) + ((this.get(position + 1L) & 0xFF) << 16) + ((this.get(position + 2L) & 0xFF) << 8) + (this.get(position + 3L) & 0xFF);
    }

    @Override
    public long getLong(long position) throws IOException {
        int endBufferNum;
        int startBufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
        if (startBufferNum == (endBufferNum = LargeMappedPersistentBuffer.getBufferNum(position + 7L))) {
            return this.mappedBuffers.get(startBufferNum).getLong(LargeMappedPersistentBuffer.getIndex(position));
        }
        return (((long)this.get(position) & 0xFFL) << 56) + (((long)this.get(position + 1L) & 0xFFL) << 48) + (((long)this.get(position + 2L) & 0xFFL) << 40) + (((long)this.get(position + 3L) & 0xFFL) << 32) + (((long)this.get(position + 4L) & 0xFFL) << 24) + (((long)this.get(position + 5L) & 0xFFL) << 16) + (((long)this.get(position + 6L) & 0xFFL) << 8) + ((long)this.get(position + 7L) & 0xFFL);
    }

    @Override
    public void putInt(long position, int value) throws IOException {
        int endBufferNum;
        int startBufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
        if (startBufferNum == (endBufferNum = LargeMappedPersistentBuffer.getBufferNum(position + 3L))) {
            this.mappedBuffers.get(startBufferNum).putInt(LargeMappedPersistentBuffer.getIndex(position), value);
            if (this.modifiedBuffers != null) {
                this.modifiedBuffers.set(startBufferNum, true);
            }
        } else {
            this.put(position, (byte)(value >>> 24));
            this.put(position + 1L, (byte)(value >>> 16));
            this.put(position + 2L, (byte)(value >>> 8));
            this.put(position + 3L, (byte)value);
        }
    }

    @Override
    public void putLong(long position, long value) throws IOException {
        int endBufferNum;
        int startBufferNum = LargeMappedPersistentBuffer.getBufferNum(position);
        if (startBufferNum == (endBufferNum = LargeMappedPersistentBuffer.getBufferNum(position + 7L))) {
            this.mappedBuffers.get(startBufferNum).putLong(LargeMappedPersistentBuffer.getIndex(position), value);
            if (this.modifiedBuffers != null) {
                this.modifiedBuffers.set(startBufferNum, true);
            }
        } else {
            this.put(position, (byte)(value >>> 56));
            this.put(position + 1L, (byte)(value >>> 48));
            this.put(position + 2L, (byte)(value >>> 40));
            this.put(position + 3L, (byte)(value >>> 32));
            this.put(position + 4L, (byte)(value >>> 24));
            this.put(position + 5L, (byte)(value >>> 16));
            this.put(position + 6L, (byte)(value >>> 8));
            this.put(position + 7L, (byte)value);
        }
    }
}

