/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.persistent.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPSerializer<E>
implements Serializer<E> {
    private final Serializer<E> wrapped;
    private E lastSerialized = null;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public GZIPSerializer(Serializer<E> wrapped) {
        this.wrapped = wrapped;
    }

    private void serializeToBuffer(E value) throws IOException {
        if (this.lastSerialized != value) {
            this.lastSerialized = null;
            this.buffer.reset();
            GZIPOutputStream gzout = new GZIPOutputStream(this.buffer);
            try {
                this.wrapped.serialize(value, gzout);
            }
            finally {
                gzout.close();
            }
            this.lastSerialized = value;
        }
    }

    @Override
    public boolean isFixedSerializedSize() {
        return false;
    }

    @Override
    public long getSerializedSize(E value) throws IOException {
        this.serializeToBuffer(value);
        return this.buffer.size();
    }

    @Override
    public void serialize(E value, OutputStream out) throws IOException {
        this.serializeToBuffer(value);
        this.buffer.writeTo(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E deserialize(InputStream in) throws IOException {
        GZIPInputStream gzin = new GZIPInputStream(in);
        try {
            E e = this.wrapped.deserialize(gzin);
            return e;
        }
        finally {
            gzin.close();
        }
    }
}

