/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FloatSerializer
implements Serializer<Float> {
    private final byte[] buffer = new byte[4];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Float value) {
        return 4L;
    }

    @Override
    public void serialize(Float value, OutputStream out) throws IOException {
        IoUtils.intToBuffer((int)Float.floatToRawIntBits(value.floatValue()), (byte[])this.buffer);
        out.write(this.buffer, 0, 4);
    }

    @Override
    public Float deserialize(InputStream in) throws IOException {
        IoUtils.readFully((InputStream)in, (byte[])this.buffer, (int)0, (int)4);
        return Float.valueOf(Float.intBitsToFloat(IoUtils.bufferToInt((byte[])this.buffer)));
    }
}

