/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.WrappedException;
import com.aoindustries.util.persistent.AbstractPersistentBlockBuffer;
import com.aoindustries.util.persistent.PersistentBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;

public class DynamicPersistentBlockBuffer
extends AbstractPersistentBlockBuffer {
    private static final Logger logger = Logger.getLogger(DynamicPersistentBlockBuffer.class.getName());
    private final List<SortedSet<Long>> freeSpaceMaps = new ArrayList<SortedSet<Long>>(64);
    private int modCount;
    private static final long PAGE_SIZE = 4096L;
    private static final long PAGE_OFFSET_MASK = 4095L;
    private static final long PAGE_MASK = -4096L;

    public DynamicPersistentBlockBuffer(PersistentBuffer pbuffer) throws IOException {
        super(pbuffer);
        for (int c = 0; c < 64; ++c) {
            this.freeSpaceMaps.add(null);
        }
        long capacity = pbuffer.capacity();
        long id = 0L;
        while (id < capacity) {
            byte header = pbuffer.get(id);
            int blockSizeBits = DynamicPersistentBlockBuffer.getBlockSizeBits(header);
            if (!this.isBlockAligned(id, blockSizeBits)) {
                throw new IOException("Block not aligned: " + id);
            }
            long blockEnd = id + DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits);
            if (blockEnd > capacity) {
                logger.warning("Expanding capacity to match block end: capacity=" + capacity + ", blockEnd=" + blockEnd);
                capacity = blockEnd;
                pbuffer.setCapacity(capacity);
            }
            if (!DynamicPersistentBlockBuffer.isAllocated(header)) {
                this.addFreeSpaceMap(id, blockSizeBits, capacity, true);
            }
            id = blockEnd;
        }
    }

    private static boolean isAllocated(byte header) {
        return (header & 0x80) != 0;
    }

    private static int getBlockSizeBits(byte header) {
        return header & 0x3F;
    }

    private static long getBlockSize(int blockSizeBits) {
        return 1L << blockSizeBits;
    }

    private static long getPageOffset(long id) {
        return id & 0xFFFL;
    }

    private static long getNearestPage(long id) {
        if (DynamicPersistentBlockBuffer.getPageOffset(id) != 0L) {
            id = (id & 0xFFFFFFFFFFFFF000L) + 4096L;
        }
        return id;
    }

    private static boolean isValidBlockSizeBits(int blockSizeBits) {
        return blockSizeBits >= 0 && blockSizeBits <= 63;
    }

    private boolean isValidRange(long id) throws IOException {
        return id >= 0L && id < this.pbuffer.capacity();
    }

    private boolean isBlockAligned(long id, int blockSizeBits) throws IOException {
        return (DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits) - 1L & id) == 0L;
    }

    private boolean isBlockComplete(long id, int blockSizeBits) throws IOException {
        return id + DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits) <= this.pbuffer.capacity();
    }

    private boolean isAllocated(long id) throws IOException {
        byte header = this.pbuffer.get(id);
        return DynamicPersistentBlockBuffer.isAllocated(header);
    }

    private void addFreeSpaceMap(long id, int blockSizeBits, long capacity, boolean groupPrevOnly) throws IOException {
        SortedSet<Long> fsm;
        long blockSize;
        long blockOffsetMask;
        boolean blockSizeBitsUpdated = false;
        while (blockSizeBits < 63 && (id & (blockOffsetMask = (blockSize = DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits)) - 1L)) == 0L) {
            long nextId;
            byte nextHeader;
            long biggerBlockSize = blockSize << 1;
            long biggerBlockMask = -biggerBlockSize;
            long idBiggerBlockMask = id & biggerBlockMask;
            long prevId = id - blockSize;
            if (prevId >= 0L && (prevId & biggerBlockMask) == idBiggerBlockMask) {
                byte prevHeader = this.pbuffer.get(prevId);
                if (DynamicPersistentBlockBuffer.isAllocated(prevHeader) || blockSizeBits != DynamicPersistentBlockBuffer.getBlockSizeBits(prevHeader)) break;
                id = prevId;
                SortedSet<Long> fsm2 = this.freeSpaceMaps.get(blockSizeBits);
                if (fsm2 == null) {
                    throw new AssertionError((Object)("fsm is null for bits=" + blockSizeBits));
                }
                if (!fsm2.remove(prevId)) {
                    throw new AssertionError((Object)("fsm for bits=" + blockSizeBits + " did not contain prevId=" + prevId));
                }
                ++blockSizeBits;
                blockSizeBitsUpdated = true;
                continue;
            }
            if (groupPrevOnly || id + biggerBlockSize > capacity || DynamicPersistentBlockBuffer.isAllocated(nextHeader = this.pbuffer.get(nextId = id + blockSize)) || blockSizeBits != DynamicPersistentBlockBuffer.getBlockSizeBits(nextHeader)) break;
            SortedSet<Long> fsm3 = this.freeSpaceMaps.get(blockSizeBits);
            if (fsm3 == null) {
                throw new AssertionError((Object)("fsm is null for bits=" + blockSizeBits));
            }
            if (!fsm3.remove(nextId)) {
                throw new AssertionError((Object)("fsm for bits=" + blockSizeBits + " did not contain nextId=" + nextId));
            }
            ++blockSizeBits;
            blockSizeBitsUpdated = true;
        }
        if (blockSizeBitsUpdated) {
            this.pbuffer.put(id, (byte)blockSizeBits);
        }
        if ((fsm = this.freeSpaceMaps.get(blockSizeBits)) == null) {
            fsm = new TreeSet<Long>();
            this.freeSpaceMaps.set(blockSizeBits, fsm);
        }
        if (!fsm.add(id)) {
            throw new AssertionError((Object)("Free space map already contains entry: " + id));
        }
    }

    private long splitAllocate(int blockSizeBits, long capacity) throws IOException {
        return this.splitAllocate(blockSizeBits, capacity, 0);
    }

    private long splitAllocate(int blockSizeBits, long capacity, int recursionDepth) throws IOException {
        SortedSet<Long> fsm = this.freeSpaceMaps.get(blockSizeBits);
        if (fsm != null && !fsm.isEmpty()) {
            Long id = fsm.first();
            fsm.remove(id);
            return id;
        }
        if (blockSizeBits == 63) {
            return -1L;
        }
        long blockSize = DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits);
        if (blockSize > capacity) {
            return -1L;
        }
        long biggerAvailableId = this.splitAllocate(blockSizeBits + 1, capacity, recursionDepth + 1);
        if (biggerAvailableId == -1L) {
            return -1L;
        }
        long nextId = biggerAvailableId + blockSize;
        if (this.pbuffer.get(nextId) != blockSizeBits) {
            this.pbuffer.put(nextId, (byte)blockSizeBits);
            if (recursionDepth == 0) {
                this.barrier(false);
            }
        }
        if (fsm == null) {
            fsm = new TreeSet<Long>();
            this.freeSpaceMaps.set(blockSizeBits, fsm);
        }
        fsm.add(nextId);
        this.pbuffer.put(biggerAvailableId, (byte)blockSizeBits);
        return biggerAvailableId;
    }

    private void configureNewAllocation(long start, long capacity) throws IOException {
        while (start < capacity) {
            long blockEnd;
            int bits;
            for (bits = 1; bits < 63 && (start & (1L << bits) - 1L) == 0L && (blockEnd = start + (1L << bits)) >= 0L && blockEnd <= capacity; ++bits) {
            }
            if (--bits > 0) {
                this.pbuffer.put(start, (byte)bits);
            }
            this.addFreeSpaceMap(start, bits, capacity, true);
            start += 1L << bits;
        }
    }

    @Override
    public long allocate(long minimumSize) throws IOException {
        long capacity;
        if (minimumSize < 0L) {
            throw new IllegalArgumentException("minimumSize<0: " + minimumSize);
        }
        ++this.modCount;
        int blockSizeBits = 64 - Long.numberOfLeadingZeros(minimumSize);
        long id = this.splitAllocate(blockSizeBits, capacity = this.pbuffer.capacity());
        if (id != -1L) {
            this.pbuffer.put(id, (byte)(0x80 | blockSizeBits));
        } else {
            long newCapacity;
            long percentCapacity;
            long blockStart = capacity;
            long blockSize = DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits);
            long blockMask = blockSize - 1L;
            long blockOffset = blockStart & blockMask;
            if (blockOffset != 0L) {
                long expandBytes = blockSize - blockOffset;
                blockStart += expandBytes;
            }
            if ((percentCapacity = capacity + (capacity >> 2)) > (newCapacity = blockStart + blockSize)) {
                newCapacity = percentCapacity;
            }
            newCapacity = DynamicPersistentBlockBuffer.getNearestPage(newCapacity);
            this.pbuffer.setCapacity(newCapacity);
            this.configureNewAllocation(capacity, newCapacity);
            id = this.splitAllocate(blockSizeBits, newCapacity);
            if (id == -1L) {
                throw new AssertionError((Object)("Free space not available after expansion: capacity=" + capacity + ", newCapacity=" + newCapacity));
            }
            this.pbuffer.put(id, (byte)(0x80 | blockSizeBits));
        }
        return id;
    }

    @Override
    public void deallocate(long id) throws IOException, IllegalStateException {
        byte header = this.pbuffer.get(id);
        int blockSizeBits = DynamicPersistentBlockBuffer.getBlockSizeBits(header);
        if (!DynamicPersistentBlockBuffer.isAllocated(header)) {
            throw new AssertionError((Object)("Block not allocated: " + id));
        }
        ++this.modCount;
        this.pbuffer.put(id, (byte)(header & 0x7F));
        this.addFreeSpaceMap(id, blockSizeBits, this.pbuffer.capacity(), false);
    }

    @Override
    public Iterator<Long> iterateBlockIds() throws IOException {
        return new Iterator<Long>(){
            private int expectedModCount;
            private long lastId;
            private long nextId;
            {
                this.expectedModCount = DynamicPersistentBlockBuffer.this.modCount;
                this.lastId = -1L;
                this.nextId = 0L;
            }

            @Override
            public boolean hasNext() {
                if (this.expectedModCount != DynamicPersistentBlockBuffer.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                try {
                    long capacity = DynamicPersistentBlockBuffer.this.pbuffer.capacity();
                    while (this.nextId < capacity) {
                        byte header = DynamicPersistentBlockBuffer.this.pbuffer.get(this.nextId);
                        int blockSizeBits = DynamicPersistentBlockBuffer.getBlockSizeBits(header);
                        if (DynamicPersistentBlockBuffer.isAllocated(header)) {
                            return true;
                        }
                        this.nextId += DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits);
                    }
                    return false;
                }
                catch (IOException err) {
                    throw new WrappedException((Throwable)err);
                }
            }

            @Override
            public Long next() {
                if (this.expectedModCount != DynamicPersistentBlockBuffer.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                try {
                    long capacity = DynamicPersistentBlockBuffer.this.pbuffer.capacity();
                    while (this.nextId < capacity) {
                        byte header = DynamicPersistentBlockBuffer.this.pbuffer.get(this.nextId);
                        int blockSizeBits = DynamicPersistentBlockBuffer.getBlockSizeBits(header);
                        long ptr = this.nextId;
                        this.nextId += DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits);
                        if (!DynamicPersistentBlockBuffer.isAllocated(header)) continue;
                        this.lastId = ptr;
                        return this.lastId;
                    }
                    throw new NoSuchElementException();
                }
                catch (IOException err) {
                    throw new WrappedException((Throwable)err);
                }
            }

            @Override
            public void remove() {
                try {
                    if (this.expectedModCount != DynamicPersistentBlockBuffer.this.modCount) {
                        throw new ConcurrentModificationException();
                    }
                    if (this.lastId == -1L) {
                        throw new IllegalStateException();
                    }
                    DynamicPersistentBlockBuffer.this.deallocate(this.lastId);
                    ++this.expectedModCount;
                    this.lastId = -1L;
                }
                catch (IOException err) {
                    throw new WrappedException((Throwable)err);
                }
            }
        };
    }

    @Override
    public long getBlockSize(long id) throws IOException {
        byte header = this.pbuffer.get(id);
        int blockSizeBits = DynamicPersistentBlockBuffer.getBlockSizeBits(header);
        if (!DynamicPersistentBlockBuffer.isAllocated(header)) {
            throw new AssertionError((Object)("Block not allocated: " + id));
        }
        return DynamicPersistentBlockBuffer.getBlockSize(blockSizeBits) - 1L;
    }

    @Override
    protected long getBlockAddress(long id) throws IOException {
        return id + 1L;
    }

    @Override
    protected void ensureCapacity(long capacity) throws IOException {
    }
}

