/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CharacterSerializer
implements Serializer<Character> {
    private final byte[] buffer = new byte[2];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Character value) {
        return 2L;
    }

    @Override
    public void serialize(Character value, OutputStream out) throws IOException {
        IoUtils.charToBuffer((char)value.charValue(), (byte[])this.buffer);
        out.write(this.buffer, 0, 2);
    }

    @Override
    public Character deserialize(InputStream in) throws IOException {
        IoUtils.readFully((InputStream)in, (byte[])this.buffer, (int)0, (int)2);
        return Character.valueOf(IoUtils.bufferToChar((byte[])this.buffer));
    }
}

