/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.BufferManager;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CharArraySerializer
implements Serializer<char[]> {
    @Override
    public boolean isFixedSerializedSize() {
        return false;
    }

    @Override
    public long getSerializedSize(char[] value) {
        return 4 + value.length / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(char[] chars, OutputStream out) throws IOException {
        byte[] bytes = BufferManager.getBytes();
        try {
            int count;
            int len;
            IoUtils.intToBuffer((int)len, (byte[])bytes);
            out.write(bytes, 0, 4);
            int pos = 0;
            for (len = chars.length; len > 0; len -= count) {
                count = 2048;
                if (len < count) {
                    count = len;
                }
                int charsIndex = 0;
                int bytesIndex = 0;
                while (charsIndex < count) {
                    IoUtils.charToBuffer((char)chars[pos + charsIndex], (byte[])bytes, (int)bytesIndex);
                    ++charsIndex;
                    bytesIndex += 2;
                }
                out.write(bytes, 0, count * 2);
                pos += count;
            }
        }
        finally {
            BufferManager.release((byte[])bytes, (boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] deserialize(InputStream in) throws IOException {
        byte[] bytes = BufferManager.getBytes();
        try {
            int count;
            int len;
            IoUtils.readFully((InputStream)in, (byte[])bytes, (int)0, (int)4);
            char[] chars = new char[len];
            int pos = 0;
            for (len = IoUtils.bufferToInt((byte[])bytes); len > 0; len -= count) {
                count = 2048;
                if (len < count) {
                    count = len;
                }
                IoUtils.readFully((InputStream)in, (byte[])bytes, (int)pos, (int)len);
                int charsIndex = 0;
                int bytesIndex = 0;
                while (charsIndex < count) {
                    chars[pos + charsIndex] = IoUtils.bufferToChar((byte[])bytes, (int)bytesIndex);
                    ++charsIndex;
                    bytesIndex += 2;
                }
                pos += count;
            }
            char[] cArray = chars;
            return cArray;
        }
        finally {
            BufferManager.release((byte[])bytes, (boolean)false);
        }
    }
}

