/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.persistent.Serializer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class BufferedSerializer<E>
implements Serializer<E> {
    private E lastSerialized = null;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    private void serializeToBuffer(E value) throws IOException {
        if (this.lastSerialized != value) {
            this.lastSerialized = null;
            this.buffer.reset();
            this.serialize(value, this.buffer);
            this.lastSerialized = value;
        }
    }

    @Override
    public final boolean isFixedSerializedSize() {
        return false;
    }

    @Override
    public final long getSerializedSize(E value) throws IOException {
        this.serializeToBuffer(value);
        return this.buffer.size();
    }

    @Override
    public final void serialize(E value, OutputStream out) throws IOException {
        this.serializeToBuffer(value);
        this.buffer.writeTo(out);
    }

    protected abstract void serialize(E var1, ByteArrayOutputStream var2) throws IOException;
}

