/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n.servlet;

import com.aoindustries.servlet.http.Cookies;
import com.aoindustries.util.i18n.EditableResourceBundle;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditableResourceServletFilter
implements Filter {
    private static final String FILTER_ENABLED_REQUEST_ATTRIBUTE_KEY = EditableResourceServletFilter.class.getName() + ".enabled";
    private String role;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.role = filterConfig.getInitParameter("role");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(FILTER_ENABLED_REQUEST_ATTRIBUTE_KEY) == null && request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            request.setAttribute(FILTER_ENABLED_REQUEST_ATTRIBUTE_KEY, (Object)Boolean.TRUE);
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                if ("*".equals(this.role) || httpRequest.isUserInRole(this.role)) {
                    try {
                        boolean modifyAllText = "visible".equals(Cookies.getCookie(httpRequest, "EditableResourceBundleEditorVisibility"));
                        StringBuilder url = new StringBuilder();
                        url.append(httpRequest.isSecure() ? "https://" : "http://").append(httpRequest.getServerName());
                        int port = httpRequest.getServerPort();
                        if (httpRequest.isSecure() ? port != 443 : port != 80) {
                            url.append(':').append(port);
                        }
                        url.append(httpRequest.getContextPath()).append('/');
                        int baseUrlLen = url.length();
                        url.append("SetResourceBundleValue");
                        String setValueUrl = url.toString();
                        EditableResourceBundle.resetRequest(true, setValueUrl, modifyAllText);
                        chain.doFilter(request, response);
                    }
                    finally {
                        EditableResourceBundle.resetRequest(false, null, false);
                    }
                }
                EditableResourceBundle.resetRequest(false, null, false);
                chain.doFilter(request, response);
            }
            finally {
                request.removeAttribute(FILTER_ENABLED_REQUEST_ATTRIBUTE_KEY);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

