/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.io.FileUtils;
import com.aoindustries.util.i18n.ApplicationResources;
import com.aoindustries.util.i18n.ModifiableResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.util.ResourceBundleEnumeration;

public abstract class ModifiablePropertiesResourceBundle
extends ModifiableResourceBundle {
    private static final Logger logger = Logger.getLogger(ModifiablePropertiesResourceBundle.class.getName());
    private static final Charset propertiesCharset = Charset.forName("ISO-8859-1");
    private static final String EOL = System.getProperty("line.separator");
    private static final String VALIDATED_SUFFIX = ".ModifiableResourceBundle.validated";
    private static final String MODIFIED_SUFFIX = ".ModifiableResourceBundle.modified";
    private final File sourceFile;
    private final List<String> sourceFileComments;
    private final boolean isModifiable;
    private final Map<String, String> valueMap = new ConcurrentHashMap<String, String>();
    private final Map<String, Long> validatedMap = new ConcurrentHashMap<String, Long>();
    private final Map<String, Long> modifiedMap = new ConcurrentHashMap<String, Long>();
    private final Properties properties = new Properties();

    public static boolean isTrackingKey(String key) {
        return key.endsWith(VALIDATED_SUFFIX) || key.endsWith(MODIFIED_SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModifiablePropertiesResourceBundle(File ... sourceFiles) {
        File goodSourceFile = null;
        if (sourceFiles != null) {
            for (File file : sourceFiles) {
                try {
                    if (!file.canRead() || !file.canWrite()) continue;
                    if (goodSourceFile != null) {
                        throw new IllegalStateException(ApplicationResources.accessor.getMessage("ModifiablePropertiesResourceBundle.init.moreThanOneSourceFile", new Object[]{goodSourceFile, file}));
                    }
                    goodSourceFile = file;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        this.sourceFile = goodSourceFile;
        List<String> mySourceFileComments = null;
        boolean myIsModifiable = false;
        boolean loaded = false;
        if (goodSourceFile != null) {
            try {
                CommentCaptureInputStream in = new CommentCaptureInputStream(new BufferedInputStream(new FileInputStream(goodSourceFile)));
                try {
                    this.properties.load(in);
                }
                finally {
                    in.close();
                }
                mySourceFileComments = in.getComments();
            }
            catch (IOException err) {
                logger.log(Level.WARNING, ApplicationResources.accessor.getMessage("ModifiablePropertiesResourceBundle.init.ioException", new Object[]{goodSourceFile}), err);
            }
            loaded = true;
            myIsModifiable = true;
        }
        this.sourceFileComments = mySourceFileComments;
        this.isModifiable = myIsModifiable;
        if (!loaded) {
            Class<?> clazz = this.getClass();
            String resourceName = '/' + clazz.getName().replace('.', '/') + ".properties";
            InputStream in = this.getClass().getResourceAsStream(resourceName);
            if (in == null) {
                throw new RuntimeException(ApplicationResources.accessor.getMessage("ModifiablePropertiesResourceBundle.init.resourceNotFound", new Object[]{resourceName}));
            }
            try {
                try {
                    this.properties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (IOException err) {
                throw new RuntimeException(err);
            }
        }
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.endsWith(VALIDATED_SUFFIX)) {
                this.validatedMap.put(key.substring(0, key.length() - VALIDATED_SUFFIX.length()), Long.parseLong(value));
                continue;
            }
            if (key.endsWith(MODIFIED_SUFFIX)) {
                this.modifiedMap.put(key.substring(0, key.length() - MODIFIED_SUFFIX.length()), Long.parseLong(value));
                continue;
            }
            this.valueMap.put(key, value);
        }
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.valueMap.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle myParent = this.parent;
        return new ResourceBundleEnumeration(this.valueMap.keySet(), myParent != null ? myParent.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.valueMap.keySet();
    }

    public Set<String> keySetNoParents() {
        return this.valueMap.keySet();
    }

    @Override
    public boolean isModifiable() {
        return this.isModifiable;
    }

    private static void checkKey(String key) throws IllegalArgumentException {
        if (key.endsWith(VALIDATED_SUFFIX)) {
            throw new IllegalArgumentException("Key may not end with .ModifiableResourceBundle.validated: " + key);
        }
        if (key.endsWith(MODIFIED_SUFFIX)) {
            throw new IllegalArgumentException("Key may not end with .ModifiableResourceBundle.modified: " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties() {
        assert (Thread.holdsLock(this.properties));
        try {
            Properties writer = new Properties(){
                private static final long serialVersionUID = 6953022173340009928L;

                @Override
                public Enumeration<Object> keys() {
                    TreeSet<Object> sortedSet = new TreeSet<Object>(Collator.getInstance(Locale.ROOT));
                    Enumeration<Object> e = super.keys();
                    while (e.hasMoreElements()) {
                        sortedSet.add(e.nextElement());
                    }
                    return Collections.enumeration(sortedSet);
                }
            };
            writer.putAll((Map<?, ?>)this.properties);
            File tmpFile = File.createTempFile("ApplicationResources", null, this.sourceFile.getParentFile());
            FilterOutputStream out = new BufferedOutputStream(new FileOutputStream(tmpFile));
            try {
                if (this.sourceFileComments != null) {
                    for (String line : this.sourceFileComments) {
                        ((OutputStream)out).write(line.getBytes(propertiesCharset));
                        ((OutputStream)out).write(EOL.getBytes(propertiesCharset));
                    }
                }
                out = new SkipCommentsFilterOutputStream(out);
                writer.store(out, null);
            }
            finally {
                ((OutputStream)out).close();
            }
            FileUtils.renameAllowNonAtomic((File)tmpFile, (File)this.sourceFile);
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleRemoveKey(String key) {
        ModifiablePropertiesResourceBundle.checkKey(key);
        Properties properties = this.properties;
        synchronized (properties) {
            this.properties.remove(key);
            this.properties.remove(key + VALIDATED_SUFFIX);
            this.properties.remove(key + MODIFIED_SUFFIX);
            this.saveProperties();
            this.valueMap.remove(key);
            this.validatedMap.remove(key);
            this.modifiedMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleSetObject(String key, Object value, boolean modified) {
        ModifiablePropertiesResourceBundle.checkKey(key);
        Properties properties = this.properties;
        synchronized (properties) {
            Long currentTimeLong = System.currentTimeMillis();
            String currentTimeString = currentTimeLong.toString();
            this.properties.setProperty(key, (String)value);
            this.properties.setProperty(key + VALIDATED_SUFFIX, currentTimeString);
            if (modified) {
                this.properties.setProperty(key + MODIFIED_SUFFIX, currentTimeString);
            }
            this.saveProperties();
            this.valueMap.put(key, (String)value);
            this.validatedMap.put(key, currentTimeLong);
            if (modified) {
                this.modifiedMap.put(key, currentTimeLong);
            }
        }
    }

    protected String getValue(String key) {
        return this.valueMap.get(key);
    }

    public Long getValidatedTime(String key) {
        return this.validatedMap.get(key);
    }

    public Long getModifiedTime(String key) {
        return this.modifiedMap.get(key);
    }

    static class SkipCommentsFilterOutputStream
    extends FilterOutputStream {
        private boolean lastCharNewline = true;
        private boolean isCommentLine = false;

        SkipCommentsFilterOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int ch) throws IOException {
            if (this.lastCharNewline) {
                this.isCommentLine = ch == 35;
            }
            boolean bl = this.lastCharNewline = ch == 10;
            if (!this.isCommentLine) {
                this.out.write(ch);
            }
        }
    }

    static class CommentCaptureInputStream
    extends InputStream {
        private final InputStream in;
        private boolean lastCharNewline = true;
        private boolean isCommentLine = false;
        private final StringBuilder currentComment = new StringBuilder();
        private final List<String> comments = new ArrayList<String>();

        CommentCaptureInputStream(InputStream in) {
            this.in = in;
        }

        private void addComment() {
            if (this.currentComment.length() > 0) {
                this.comments.add(this.currentComment.toString());
                this.currentComment.setLength(0);
            }
        }

        @Override
        public int read() throws IOException {
            int ch = this.in.read();
            if (ch == -1) {
                this.lastCharNewline = true;
                this.isCommentLine = false;
                this.addComment();
            } else {
                if (this.lastCharNewline) {
                    this.isCommentLine = ch == 35;
                }
                boolean bl = this.lastCharNewline = ch == 10;
                if (this.lastCharNewline) {
                    this.addComment();
                }
                if (this.isCommentLine && ch != 10 && ch != 13) {
                    this.currentComment.append((char)ch);
                }
            }
            return ch;
        }

        @Override
        public void close() throws IOException {
            this.addComment();
            super.close();
        }

        List<String> getComments() {
            return this.comments;
        }
    }
}

