/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.util.i18n.ApplicationResources;
import com.aoindustries.util.i18n.ApplicationResourcesAccessor;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import java.util.IdentityHashMap;
import java.util.Locale;

public final class BundleLookupThreadContext {
    static final ThreadLocal<BundleLookupThreadContext> threadContext = new ThreadLocal();
    private final IdentityHashMap<String, BundleLookupMarkup> lookupResults = new IdentityHashMap();

    public static BundleLookupThreadContext getThreadContext(boolean createIfMissing) {
        BundleLookupThreadContext context = threadContext.get();
        if (createIfMissing && context == null) {
            context = new BundleLookupThreadContext();
            threadContext.set(context);
        }
        return context;
    }

    public static void removeThreadContext() {
        threadContext.set(null);
    }

    private BundleLookupThreadContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLookupMarkup(String lookupResult, BundleLookupMarkup lookupMarkup) throws IllegalStateException {
        IdentityHashMap<String, BundleLookupMarkup> identityHashMap = this.lookupResults;
        synchronized (identityHashMap) {
            if (this.lookupResults.put(lookupResult, lookupMarkup) != null) {
                throw new IllegalStateException(ApplicationResources.accessor.getMessage("BundleLookupThreadContext.addLookupMarkup.stringAlreadyAdded"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        IdentityHashMap<String, BundleLookupMarkup> identityHashMap = this.lookupResults;
        synchronized (identityHashMap) {
            this.lookupResults.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleLookupMarkup getLookupMarkup(String result) {
        IdentityHashMap<String, BundleLookupMarkup> identityHashMap = this.lookupResults;
        synchronized (identityHashMap) {
            return this.lookupResults.get(result);
        }
    }

    static {
        ApplicationResourcesAccessor.addListener((ApplicationResourcesAccessor.Listener)new ApplicationResourcesAccessor.Listener(){

            public void onGetMessage(ApplicationResourcesAccessor accessor, Locale locale, String key, Object[] args, String resource, String result) {
                BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext(false);
                if (threadContext != null) {
                    BundleLookupMarkup lookupMarkup = threadContext.getLookupMarkup(resource);
                    threadContext.addLookupMarkup(result, lookupMarkup);
                }
            }
        });
    }
}

