/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.util.StringUtility;
import java.util.ArrayList;
import java.util.List;

public abstract class WildcardPatternMatcher {
    private static final WildcardPatternMatcher matchNone = new WildcardPatternMatcher(){

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isMatch(String paramName) {
            return false;
        }
    };
    private static final WildcardPatternMatcher matchAll = new WildcardPatternMatcher(){

        @Override
        public boolean isMatch(String paramName) {
            return true;
        }
    };

    public static WildcardPatternMatcher matchNone() {
        return matchNone;
    }

    @Deprecated
    public static WildcardPatternMatcher getMatchNone() {
        return WildcardPatternMatcher.matchNone();
    }

    public static WildcardPatternMatcher matchAll() {
        return matchAll;
    }

    @Deprecated
    public static WildcardPatternMatcher getMatchAll() {
        return WildcardPatternMatcher.matchAll();
    }

    public static WildcardPatternMatcher compile(String patterns) {
        if (patterns == null || patterns.isEmpty()) {
            return matchNone;
        }
        List<String> list = StringUtility.splitStringCommaSpace(patterns);
        if (list.isEmpty()) {
            return matchNone;
        }
        final ArrayList<WildcardPatternMatcher> matchers = new ArrayList<WildcardPatternMatcher>(list.size());
        for (String pattern : list) {
            boolean endsWildcard;
            boolean startsWildcard;
            int end = pattern.length();
            if (end <= 0) continue;
            int pos = 0;
            if (pattern.charAt(0) == '*') {
                startsWildcard = true;
                ++pos;
                while (pos < end && pattern.charAt(pos) == '*') {
                    ++pos;
                }
                if (pos >= end) {
                    return matchAll;
                }
            } else {
                startsWildcard = false;
            }
            if (pattern.charAt(end - 1) == '*') {
                endsWildcard = true;
                --end;
                while (end > pos && pattern.charAt(end - 1) == '*') {
                    --end;
                }
                assert (end > pos);
            } else {
                endsWildcard = false;
            }
            final ArrayList<String> sequences = new ArrayList<String>();
            while (pos < end) {
                assert (pattern.charAt(pos) != '*');
                int starPos = pattern.indexOf(42, pos + 1);
                if (starPos == -1 || starPos >= end) {
                    sequences.add(pattern.substring(pos, end));
                    pos = end;
                    continue;
                }
                sequences.add(pattern.substring(pos, starPos));
                for (pos = starPos + 1; pos < end && pattern.charAt(pos) == '*'; ++pos) {
                }
            }
            int seqCount = sequences.size();
            assert (seqCount >= 1);
            if (seqCount == 1) {
                final String sequence = (String)sequences.get(0);
                if (startsWildcard) {
                    if (endsWildcard) {
                        matchers.add(new WildcardPatternMatcher(){

                            @Override
                            public boolean isMatch(String paramName) {
                                return paramName.contains(sequence);
                            }
                        });
                        continue;
                    }
                    matchers.add(new WildcardPatternMatcher(){

                        @Override
                        public boolean isMatch(String paramName) {
                            return paramName.endsWith(sequence);
                        }
                    });
                    continue;
                }
                if (endsWildcard) {
                    matchers.add(new WildcardPatternMatcher(){

                        @Override
                        public boolean isMatch(String paramName) {
                            return paramName.startsWith(sequence);
                        }
                    });
                    continue;
                }
                matchers.add(new WildcardPatternMatcher(){

                    @Override
                    public boolean isMatch(String paramName) {
                        return paramName.equals(sequence);
                    }
                });
                continue;
            }
            matchers.add(new WildcardPatternMatcher(){

                @Override
                public boolean isMatch(String paramName) {
                    int index = 0;
                    int indexEnd = sequences.size();
                    int pos = 0;
                    int end = paramName.length();
                    if (!startsWildcard) {
                        String prefix = (String)sequences.get(0);
                        if (!paramName.startsWith(prefix)) {
                            return false;
                        }
                        ++index;
                        pos += prefix.length();
                    }
                    if (!endsWildcard) {
                        String suffix;
                        if (!paramName.endsWith(suffix = (String)sequences.get(--indexEnd))) {
                            return false;
                        }
                        end -= suffix.length();
                    }
                    if (end < pos) {
                        return false;
                    }
                    while (index < indexEnd) {
                        String sequence = (String)sequences.get(index++);
                        int sequenceLen = sequence.length();
                        assert (sequenceLen > 0);
                        int foundAt = paramName.indexOf(sequence, pos);
                        if (foundAt == -1 || foundAt > end - sequenceLen) {
                            return false;
                        }
                        pos += sequenceLen;
                    }
                    return true;
                }
            });
        }
        if (matchers.isEmpty()) {
            return matchNone;
        }
        if (matchers.size() == 1) {
            return (WildcardPatternMatcher)matchers.get(0);
        }
        return new WildcardPatternMatcher(){

            @Override
            public boolean isMatch(String paramName) {
                for (WildcardPatternMatcher matcher : matchers) {
                    if (!matcher.isMatch(paramName)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Deprecated
    public static WildcardPatternMatcher getInstance(String patterns) {
        return WildcardPatternMatcher.compile(patterns);
    }

    private WildcardPatternMatcher() {
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract boolean isMatch(String var1);
}

