/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.sql.SQLUtility;
import com.aoindustries.util.InternUtils;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.GregorianCalendar;
import java.util.List;

public final class StringUtility {
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final Calendar calendar = Calendar.getInstance();
    private static final char[] wordWrapChars = new char[]{' ', '\t', '-', '=', ',', ';'};
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Deprecated
    public static String getMonth(int month) {
        return MONTHS[month];
    }

    private StringUtility() {
    }

    @Deprecated
    public static String buildEmailList(String[] list) {
        StringBuilder SB = new StringBuilder();
        int len = list.length;
        for (int c = 0; c < len; ++c) {
            if (c == 0) {
                SB.append('<');
            } else {
                SB.append(",<");
            }
            SB.append(list[c]).append('>');
        }
        return SB.toString();
    }

    @Deprecated
    public static String buildList(String[] list) {
        return StringUtility.join(list, ", ");
    }

    @Deprecated
    public static String buildList(Object[] objects) {
        return StringUtility.join(objects, ", ");
    }

    @Deprecated
    public static String buildList(Iterable<?> objects) {
        return StringUtility.join(objects, ", ");
    }

    public static String join(Iterable<?> objects, String delimiter) throws ConcurrentModificationException {
        int delimiterLength = delimiter.length();
        int totalLength = 0;
        boolean didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                totalLength += delimiterLength;
            } else {
                didOne = true;
            }
            totalLength += String.valueOf(obj).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                sb.append(delimiter);
            } else {
                didOne = true;
            }
            sb.append(obj);
        }
        if (totalLength != sb.length()) {
            throw new ConcurrentModificationException();
        }
        return sb.toString();
    }

    public static String join(Object[] objects, String delimiter) throws ConcurrentModificationException {
        int delimiterLength = delimiter.length();
        int totalLength = 0;
        boolean didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                totalLength += delimiterLength;
            } else {
                didOne = true;
            }
            totalLength += String.valueOf(obj).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        didOne = false;
        for (Object obj : objects) {
            if (didOne) {
                sb.append(delimiter);
            } else {
                didOne = true;
            }
            sb.append(obj);
        }
        if (totalLength != sb.length()) {
            throw new ConcurrentModificationException();
        }
        return sb.toString();
    }

    public static int compareToDDMMYYYY(String date1, String date2) {
        if (date1.length() != 8 || date2.length() != 8) {
            return 0;
        }
        return StringUtility.compareToDDMMYYYY0(date1) - StringUtility.compareToDDMMYYYY0(date2);
    }

    private static int compareToDDMMYYYY0(String date) {
        return (date.charAt(4) - 48) * 10000000 + (date.charAt(5) - 48) * 1000000 + (date.charAt(6) - 48) * 100000 + (date.charAt(7) - 48) * 10000 + (date.charAt(0) - 48) * 1000 + (date.charAt(1) - 48) * 100 + (date.charAt(2) - 48) * 10 + (date.charAt(3) - 48);
    }

    public static boolean containsIgnoreCase(String line, String word) {
        int word_len = word.length();
        int line_len = line.length();
        int end_pos = line_len - word_len;
        block0: for (int c = 0; c <= end_pos; ++c) {
            for (int d = 0; d < word_len; ++d) {
                char ch1 = line.charAt(c + d);
                char ch2 = word.charAt(d);
                if (ch1 >= 'A' && ch1 <= 'Z') {
                    ch1 = (char)(ch1 + 32);
                }
                if (ch2 >= 'A' && ch2 <= 'Z') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertStringDateToTime(String date) throws IllegalArgumentException {
        Class<StringUtility> clazz = StringUtility.class;
        synchronized (StringUtility.class) {
            if (date.length() < 9) {
                throw new IllegalArgumentException("Invalid date");
            }
            int day = Integer.parseInt(date.substring(0, 2));
            if (day < 0 || day > 31) {
                throw new IllegalArgumentException("Invalid date");
            }
            String monthString = date.substring(2, 5);
            int month = -1;
            for (int c = 0; c < MONTHS.length; ++c) {
                if (!MONTHS[c].equalsIgnoreCase(monthString)) continue;
                month = c;
                break;
            }
            if (month == -1) {
                throw new IllegalArgumentException("Invalid month: " + monthString);
            }
            if (day > 30 && (month == 1 || month == 3 || month == 5 || month == 8 || month == 10)) {
                throw new IllegalArgumentException("Invalid date");
            }
            int year = Integer.parseInt(date.substring(5, 9));
            if (month == 1) {
                if (day > 29) {
                    throw new IllegalArgumentException("Invalid date");
                }
                if (day == 29 && !StringUtility.leapYear(year)) {
                    throw new IllegalArgumentException("Invalid date");
                }
            }
            calendar.set(5, day);
            calendar.set(2, month);
            calendar.set(1, year);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return calendar.getTime().getTime();
        }
    }

    @Deprecated
    public static int countOccurances(byte[] buff, int len, String word) {
        return StringUtility.countOccurrences(buff, len, word);
    }

    public static int countOccurrences(byte[] buff, int len, String word) {
        int wordlen = word.length();
        int end = len - wordlen;
        int count = 0;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch2;
                char ch1 = (char)buff[c + d];
                if (ch1 <= 'Z' && ch1 >= 'A') {
                    ch1 = (char)(ch1 + 32);
                }
                if ((ch2 = word.charAt(d)) <= 'Z' && ch2 >= 'A') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            c += wordlen - 1;
            ++count;
        }
        return count;
    }

    @Deprecated
    public static int countOccurances(byte[] buff, String word) {
        return StringUtility.countOccurrences(buff, word);
    }

    public static int countOccurrences(byte[] buff, String word) {
        int wordlen = word.length();
        int end = buff.length - wordlen;
        int count = 0;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch2;
                char ch1 = (char)buff[c + d];
                if (ch1 <= 'Z' && ch1 >= 'A') {
                    ch1 = (char)(ch1 + 32);
                }
                if ((ch2 = word.charAt(d)) <= 'Z' && ch2 >= 'A') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            c += wordlen - 1;
            ++count;
        }
        return count;
    }

    @Deprecated
    public static int countOccurances(String line, String word) {
        return StringUtility.countOccurrences(line, word);
    }

    public static int countOccurrences(String line, String word) {
        int wordlen = word.length();
        int end = line.length() - wordlen;
        int count = 0;
        block0: for (int c = 0; c <= end; ++c) {
            for (int d = 0; d < wordlen; ++d) {
                char ch2;
                char ch1 = line.charAt(c + d);
                if (ch1 <= 'Z' && ch1 >= 'A') {
                    ch1 = (char)(ch1 + 32);
                }
                if ((ch2 = word.charAt(d)) <= 'Z' && ch2 >= 'A') {
                    ch2 = (char)(ch2 + 32);
                }
                if (ch1 != ch2) continue block0;
            }
            c += wordlen - 1;
            ++count;
        }
        return count;
    }

    @Deprecated
    public static String escapeSQL(String s) {
        return SQLUtility.escapeSQL(s.replace('*', '%'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDateMMDDYYYY(String date) throws NumberFormatException, IllegalArgumentException {
        Class<StringUtility> clazz = StringUtility.class;
        synchronized (StringUtility.class) {
            int len = date.length();
            if (len == 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            if (len != 8) {
                throw new IllegalArgumentException("Date must be in MMDDYYYY format: " + date);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new Date(new GregorianCalendar(Integer.parseInt(date.substring(4, 8)), Integer.parseInt(date.substring(0, 2)) - 1, Integer.parseInt(date.substring(2, 4))).getTime().getTime());
        }
    }

    @Deprecated
    public static String getDateString(long time) {
        return StringUtility.getDateString(new java.util.Date(time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getDateString(java.util.Date date) {
        Class<StringUtility> clazz = StringUtility.class;
        synchronized (StringUtility.class) {
            calendar.setTime(date);
            int day = calendar.get(5);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (day >= 0 && day <= 9 ? "0" : "") + String.valueOf(calendar.get(5)) + MONTHS[calendar.get(2)] + calendar.get(1);
        }
    }

    @Deprecated
    public static String getDateStringMMDDYYYY(java.util.Date date) {
        if (date == null) {
            return "";
        }
        Calendar C = Calendar.getInstance();
        C.setTime(date);
        int day = C.get(5);
        int month = C.get(2) + 1;
        return (month >= 0 && month <= 9 ? "0" : "") + month + (day >= 0 && day <= 9 ? "0" : "") + day + C.get(1);
    }

    @Deprecated
    public static String getDateStringSecond(long time) {
        java.util.Date date = new java.util.Date(time);
        Calendar C = Calendar.getInstance();
        C.setTime(date);
        int day = C.get(5);
        int hour = C.get(11);
        int minute = C.get(12);
        int second = C.get(13);
        return (day >= 0 && day <= 9 ? "0" : "") + day + MONTHS[C.get(2)] + C.get(1) + ' ' + (hour >= 0 && hour <= 9 ? "0" : "") + hour + ':' + (minute >= 0 && minute <= 9 ? "0" : "") + minute + ':' + (second >= 0 && second <= 9 ? "0" : "") + second;
    }

    @Deprecated
    public static String getDateStringSecond(String time) {
        return time.substring(6, 8) + MONTHS[Integer.parseInt(time.substring(4, 6))] + time.substring(0, 4) + ' ' + time.substring(8, 10) + ':' + time.substring(10, 12) + ':' + time.substring(12, 14);
    }

    @Deprecated
    public static String[] getStringArray(List<?> V) {
        if (V == null) {
            return null;
        }
        int len = V.size();
        String[] SA = new String[len];
        for (int c = 0; c < len; ++c) {
            Object O = V.get(c);
            SA[c] = O == null ? null : O.toString();
        }
        return SA;
    }

    public static String getTimeLengthString(long time) {
        StringBuilder SB = new StringBuilder();
        if (time < 0L) {
            SB.append('-');
            time = -time;
        }
        long days = time / 86400000L;
        int hours = (int)((time -= days * 86400000L) / 3600000L);
        int minutes = (int)((time -= (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((time -= (long)(minutes * 60000)) / 1000L);
        time -= (long)(seconds * 1000);
        if (days == 0L) {
            if (hours == 0) {
                if (minutes == 0) {
                    if (seconds == 0) {
                        if (time == 0L) {
                            SB.append("0 minutes");
                        } else {
                            SB.append(time).append(time == 1L ? " millisecond" : " milliseconds");
                        }
                    } else {
                        SB.append(seconds).append(seconds == 1 ? " second" : " seconds");
                    }
                } else {
                    SB.append(minutes).append(minutes == 1 ? " minute" : " minutes");
                }
            } else if (minutes == 0) {
                SB.append(hours).append(hours == 1 ? " hour" : " hours");
            } else {
                SB.append(hours).append(hours == 1 ? " hour and " : " hours and ").append(minutes).append(minutes == 1 ? " minute" : " minutes");
            }
        } else if (hours == 0) {
            if (minutes == 0) {
                SB.append(days).append(days == 1L ? " day" : " days");
            } else {
                SB.append(days).append(days == 1L ? " day and " : " days and ").append(minutes).append(minutes == 1 ? " minute" : " minutes");
            }
        } else if (minutes == 0) {
            SB.append(days).append(days == 1L ? " day and " : " days and ").append(hours).append(hours == 1 ? " hour" : " hours");
        } else {
            SB.append(days).append(days == 1L ? " day, " : " days, ").append(hours).append(hours == 1 ? " hour and " : " hours and ").append(minutes).append(minutes == 1 ? " minute" : " minutes");
        }
        return SB.toString();
    }

    public static String getDecimalTimeLengthString(long time) {
        return StringUtility.getDecimalTimeLengthString(time, true);
    }

    public static String getDecimalTimeLengthString(long time, boolean alwaysShowMillis) {
        StringBuilder SB = new StringBuilder();
        if (time < 0L) {
            SB.append('-');
            time = -time;
        }
        long days = time / 86400000L;
        int hours = (int)((time -= days * 86400000L) / 3600000L);
        int minutes = (int)((time -= (long)(hours * 3600000)) / 60000L);
        int seconds = (int)((time -= (long)(minutes * 60000)) / 1000L);
        time -= (long)(seconds * 1000);
        if (days > 0L) {
            SB.append(days).append(days == 1L ? " day, " : " days, ");
        }
        SB.append(hours).append(':');
        if (minutes < 10) {
            SB.append('0');
        }
        SB.append(minutes).append(':');
        if (seconds < 10) {
            SB.append('0');
        }
        SB.append(seconds);
        if (alwaysShowMillis || time != 0L) {
            SB.append('.');
            if (time < 10L) {
                SB.append("00");
            } else if (time < 100L) {
                SB.append('0');
            }
            SB.append(time);
        }
        return SB.toString();
    }

    public static int indexOf(String S, char[] chars) {
        return StringUtility.indexOf(S, chars, 0);
    }

    public static int indexOf(String S, char[] chars, int start) {
        int Slen = S.length();
        int clen = chars.length;
        for (int c = start; c < Slen; ++c) {
            char ch = S.charAt(c);
            for (int d = 0; d < clen; ++d) {
                if (ch != chars[d]) continue;
                return c;
            }
        }
        return -1;
    }

    @Deprecated
    public static boolean isValidDate(String date) {
        try {
            StringUtility.convertStringDateToTime(date);
            return true;
        }
        catch (IllegalArgumentException err) {
            return false;
        }
    }

    @Deprecated
    public static boolean leapYear(int year) {
        return year % 4 == 0 && year % 400 == 0;
    }

    @Deprecated
    public static String removeChars(String S, char[] chars) {
        int pos;
        while ((pos = StringUtility.indexOf(S, chars)) != -1) {
            S = S.substring(0, pos) + S.substring(pos + 1);
        }
        return S;
    }

    @Deprecated
    public static String removeChars(String S, char ch) {
        int pos;
        while ((pos = S.indexOf(ch)) != -1) {
            S = S.substring(0, pos) + S.substring(pos + 1);
        }
        return S;
    }

    public static String replace(String string, char ch, String replacement) {
        int pos = string.indexOf(ch);
        if (pos == -1) {
            return string;
        }
        StringBuilder SB = new StringBuilder();
        int lastpos = 0;
        do {
            SB.append(string, lastpos, pos).append(replacement);
        } while ((pos = string.indexOf(ch, lastpos = pos + 1)) != -1);
        int len = string.length();
        if (lastpos < len) {
            SB.append(string, lastpos, len);
        }
        return SB.toString();
    }

    public static String replace(String string, String find, String replacement) {
        int pos = string.indexOf(find);
        if (pos == -1) {
            return string;
        }
        StringBuilder SB = new StringBuilder();
        int lastpos = 0;
        int findLen = find.length();
        do {
            SB.append(string, lastpos, pos).append(replacement);
        } while ((pos = string.indexOf(find, lastpos = pos + findLen)) != -1);
        int len = string.length();
        if (lastpos < len) {
            SB.append(string, lastpos, len);
        }
        return SB.toString();
    }

    public static void replace(String string, String find, String replacement, Appendable out) throws IOException {
        int pos = string.indexOf(find);
        if (pos == -1) {
            out.append(string);
        } else {
            int lastpos = 0;
            int findLen = find.length();
            do {
                out.append(string, lastpos, pos).append(replacement);
            } while ((pos = string.indexOf(find, lastpos = pos + findLen)) != -1);
            int len = string.length();
            if (lastpos < len) {
                out.append(string, lastpos, len);
            }
        }
    }

    public static void replace(StringBuffer sb, String find, String replacement) {
        for (int pos = 0; pos < sb.length() && (pos = sb.indexOf(find, pos)) != -1; pos += replacement.length()) {
            sb.replace(pos, pos + find.length(), replacement);
        }
    }

    public static void replace(StringBuilder sb, String find, String replacement) {
        for (int pos = 0; pos < sb.length() && (pos = sb.indexOf(find, pos)) != -1; pos += replacement.length()) {
            sb.replace(pos, pos + find.length(), replacement);
        }
    }

    public static List<String> splitLines(String S) {
        int pos;
        ArrayList<String> V = new ArrayList<String>();
        int start = 0;
        while ((pos = S.indexOf(10, start)) != -1) {
            String line = pos > start && S.charAt(pos - 1) == '\r' ? S.substring(start, pos - 1) : S.substring(start, pos);
            V.add(line);
            start = pos + 1;
        }
        int slen = S.length();
        if (start < slen) {
            if (S.charAt(slen - 1) == '\r') {
                --slen;
            }
            String line = S.substring(start, slen);
            V.add(line);
        }
        return V;
    }

    public static String[] splitString(String line) {
        int len = line.length();
        int wordCount = 0;
        int pos = 0;
        while (pos < len) {
            while (pos < len && line.charAt(pos) <= ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) > ' ') {
                ++pos;
            }
            if (pos <= start) continue;
            ++wordCount;
        }
        String[] words = new String[wordCount];
        int wordPos = 0;
        pos = 0;
        while (pos < len) {
            while (pos < len && line.charAt(pos) <= ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) > ' ') {
                ++pos;
            }
            if (pos <= start) continue;
            words[wordPos++] = line.substring(start, pos);
        }
        return words;
    }

    public static int splitString(String line, char[][][] buff) {
        int len = line.length();
        int wordCount = 0;
        int pos = 0;
        while (pos < len) {
            while (pos < len && line.charAt(pos) <= ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) > ' ') {
                ++pos;
            }
            if (pos <= start) continue;
            ++wordCount;
        }
        Object words = buff[0];
        if (words == null || ((char[][])words).length < wordCount) {
            char[][] cArrayArray = new char[wordCount][];
            words = cArrayArray;
            buff[0] = cArrayArray;
        }
        int wordPos = 0;
        pos = 0;
        while (pos < len) {
            while (pos < len && line.charAt(pos) <= ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) > ' ') {
                ++pos;
            }
            if (pos <= start) continue;
            int chlen = pos - start;
            int n = wordPos++;
            char[] cArray = new char[chlen];
            words[n] = cArray;
            char[] tch = cArray;
            System.arraycopy(line.toCharArray(), start, tch, 0, chlen);
        }
        return wordCount;
    }

    public static int splitString(String line, String[][] buff) {
        int len = line.length();
        int wordCount = 0;
        int pos = 0;
        while (pos < len) {
            while (pos < len && line.charAt(pos) <= ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) > ' ') {
                ++pos;
            }
            if (pos <= start) continue;
            ++wordCount;
        }
        String[] words = buff[0];
        if (words == null || words.length < wordCount) {
            words = new String[wordCount];
            buff[0] = words;
        }
        int wordPos = 0;
        pos = 0;
        while (pos < len) {
            while (pos < len && line.charAt(pos) <= ' ') {
                ++pos;
            }
            int start = pos;
            while (pos < len && line.charAt(pos) > ' ') {
                ++pos;
            }
            if (pos <= start) continue;
            words[wordPos++] = line.substring(start, pos);
        }
        return wordCount;
    }

    public static List<String> splitString(String line, char delim) {
        return StringUtility.splitString(line, 0, line.length(), delim, new ArrayList());
    }

    public static <C extends Collection<String>> C splitString(String line, char delim, C words) {
        return StringUtility.splitString(line, 0, line.length(), delim, words);
    }

    public static List<String> splitString(String line, int begin, int end, char delim) {
        return StringUtility.splitString(line, begin, end, delim, new ArrayList());
    }

    public static <C extends Collection<String>> C splitString(String line, int begin, int end, char delim, C words) {
        for (int pos = begin; pos < end; ++pos) {
            int start = pos;
            if ((pos = line.indexOf(delim, pos)) == -1 || pos > end) {
                pos = end;
            }
            words.add((String)line.substring(start, pos));
        }
        if (end > begin && line.charAt(end - 1) == delim) {
            words.add((String)"");
        }
        return words;
    }

    public static List<String> splitString(String line, String delim) {
        int delimLen = delim.length();
        if (delimLen == 0) {
            throw new IllegalArgumentException("Delimiter may not be empty");
        }
        ArrayList<String> words = new ArrayList<String>();
        int len = line.length();
        int pos = 0;
        while (pos < len) {
            int start = pos;
            if ((pos = line.indexOf(delim, pos)) == -1) {
                words.add(line.substring(start, len));
                pos = len;
                continue;
            }
            words.add(line.substring(start, pos));
            pos += delimLen;
        }
        if (len >= delimLen && line.endsWith(delim)) {
            words.add("");
        }
        return words;
    }

    public static List<String> splitStringCommaSpace(String line) {
        ArrayList<String> words = new ArrayList<String>();
        int len = line.length();
        int pos = 0;
        while (pos < len) {
            char ch;
            while (pos < len && ((ch = line.charAt(pos)) <= ' ' || ch == ',')) {
                ++pos;
            }
            int start = pos;
            while (pos < len && (ch = line.charAt(pos)) > ' ' && ch != ',') {
                ++pos;
            }
            if (pos <= start) continue;
            words.add(line.substring(start, pos));
        }
        return words;
    }

    @Deprecated
    public static String wordWrap(String string, int width) {
        int inputLength = string.length();
        int estimatedLines = 2 * inputLength / width;
        int initialLength = inputLength + estimatedLines * 2;
        try {
            StringBuilder buffer = new StringBuilder(initialLength);
            StringUtility.wordWrap(string, width, buffer);
            return buffer.toString();
        }
        catch (IOException e) {
            AssertionError ae = new AssertionError((Object)"Should not get IOException from StringBuilder");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public static void wordWrap(String string, int width, Appendable out) throws IOException {
        ++width;
        boolean useCR = false;
        do {
            int d;
            boolean isBreak;
            char ch;
            int c;
            int pos = string.indexOf(10);
            if (!useCR && pos > 0 && string.charAt(pos - 1) == '\r') {
                useCR = true;
            }
            int linelength = pos == -1 ? string.length() : pos + 1;
            if ((pos == -1 ? linelength - 1 : pos) <= width) {
                out.append(string, 0, linelength);
                string = string.substring(linelength);
                continue;
            }
            int lastBreakChar = 0;
            for (c = 0; c < width; ++c) {
                ch = string.charAt(c);
                isBreak = false;
                for (d = 0; d < wordWrapChars.length; ++d) {
                    if (ch != wordWrapChars[d]) continue;
                    isBreak = true;
                    break;
                }
                if (!isBreak) continue;
                lastBreakChar = c + 1;
            }
            if (lastBreakChar == 0) {
                for (c = width; c < linelength; ++c) {
                    ch = string.charAt(c);
                    isBreak = false;
                    for (d = 0; d < wordWrapChars.length; ++d) {
                        if (ch != wordWrapChars[d]) continue;
                        isBreak = true;
                        break;
                    }
                    if (!isBreak) continue;
                    lastBreakChar = c + 1;
                    break;
                }
            }
            if (lastBreakChar == 0) {
                out.append(string, 0, linelength);
                string = string.substring(linelength);
                continue;
            }
            out.append(string, 0, lastBreakChar);
            if (useCR) {
                out.append("\r\n");
            } else {
                out.append('\n');
            }
            string = string.substring(lastBreakChar);
        } while (string.length() > 0);
    }

    public static char getHexChar(int v) {
        return hexChars[v & 0xF];
    }

    public static int getHex(char ch) throws IllegalArgumentException {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        throw new IllegalArgumentException("Invalid hex character: " + ch);
    }

    public static void convertToHex(byte[] bytes, Appendable out) throws IOException {
        if (bytes != null) {
            for (byte b : bytes) {
                out.append(StringUtility.getHexChar(b >> 4));
                out.append(StringUtility.getHexChar(b));
            }
        }
    }

    public static String convertToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        StringBuilder SB = new StringBuilder(len * 2);
        try {
            StringUtility.convertToHex(bytes, (Appendable)SB);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return SB.toString();
    }

    public static byte[] convertByteArrayFromHex(char[] hex) {
        int hexLen = hex.length;
        if ((hexLen & 1) != 0) {
            throw new IllegalArgumentException("Uneven number of characters: " + hexLen);
        }
        byte[] result = new byte[hexLen / 2];
        int resultPos = 0;
        int hexPos = 0;
        while (hexPos < hexLen) {
            int h = StringUtility.getHex(hexChars[hexPos++]);
            int l = StringUtility.getHex(hexChars[hexPos++]);
            result[resultPos++] = (byte)(h << 4 | l);
        }
        return result;
    }

    public static void convertToHex(int value, Appendable out) throws IOException {
        out.append(StringUtility.getHexChar(value >>> 28));
        out.append(StringUtility.getHexChar(value >>> 24));
        out.append(StringUtility.getHexChar(value >>> 20));
        out.append(StringUtility.getHexChar(value >>> 16));
        out.append(StringUtility.getHexChar(value >>> 12));
        out.append(StringUtility.getHexChar(value >>> 8));
        out.append(StringUtility.getHexChar(value >>> 4));
        out.append(StringUtility.getHexChar(value));
    }

    public static String convertToHex(int value) {
        StringBuilder SB = new StringBuilder(8);
        try {
            StringUtility.convertToHex(value, (Appendable)SB);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return SB.toString();
    }

    public static int convertIntArrayFromHex(char[] hex) {
        int hexLen = hex.length;
        if (hexLen < 8) {
            throw new IllegalArgumentException("Too few characters: " + hexLen);
        }
        return StringUtility.getHex(hex[0]) << 28 | StringUtility.getHex(hex[1]) << 24 | StringUtility.getHex(hex[2]) << 20 | StringUtility.getHex(hex[3]) << 16 | StringUtility.getHex(hex[4]) << 12 | StringUtility.getHex(hex[5]) << 8 | StringUtility.getHex(hex[6]) << 4 | StringUtility.getHex(hex[7]);
    }

    public static void convertToHex(long value, Appendable out) throws IOException {
        StringUtility.convertToHex((int)(value >>> 32), out);
        StringUtility.convertToHex((int)value, out);
    }

    public static String convertToHex(long value) {
        StringBuilder SB = new StringBuilder(16);
        try {
            StringUtility.convertToHex(value, (Appendable)SB);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return SB.toString();
    }

    public static long convertLongArrayFromHex(char[] hex) {
        int hexLen = hex.length;
        if (hexLen < 16) {
            throw new IllegalArgumentException("Too few characters: " + hexLen);
        }
        int h = StringUtility.getHex(hex[0]) << 28 | StringUtility.getHex(hex[1]) << 24 | StringUtility.getHex(hex[2]) << 20 | StringUtility.getHex(hex[3]) << 16 | StringUtility.getHex(hex[4]) << 12 | StringUtility.getHex(hex[5]) << 8 | StringUtility.getHex(hex[6]) << 4 | StringUtility.getHex(hex[7]);
        int l = StringUtility.getHex(hex[8]) << 28 | StringUtility.getHex(hex[9]) << 24 | StringUtility.getHex(hex[10]) << 20 | StringUtility.getHex(hex[11]) << 16 | StringUtility.getHex(hex[12]) << 12 | StringUtility.getHex(hex[13]) << 8 | StringUtility.getHex(hex[14]) << 4 | StringUtility.getHex(hex[15]);
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static String getApproximateSize(long size) {
        long unitSize;
        String unitName;
        if (size == 1L) {
            return "1 byte";
        }
        if (size < 1024L) {
            return (int)size + " bytes";
        }
        if (size < 0x100000L) {
            unitName = " k";
            unitSize = 1024L;
        } else if (size < 0x40000000L) {
            unitName = " M";
            unitSize = 0x100000L;
        } else if (size < 0x10000000000L) {
            unitName = " G";
            unitSize = 0x40000000L;
        } else {
            unitName = " T";
            unitSize = 0x10000000000L;
        }
        long whole = size / unitSize;
        if (whole < 100L) {
            int fraction = (int)(size % unitSize * 10L / unitSize);
            return "" + whole + '.' + fraction + unitName;
        }
        return whole + unitName;
    }

    public static String getApproximateBitRate(long bit_rate) {
        long unitSize;
        String unitName;
        if (bit_rate < 1000L) {
            return Integer.toString((int)bit_rate);
        }
        if (bit_rate < 1000000L) {
            unitName = " k";
            unitSize = 1000L;
        } else if (bit_rate < 1000000000L) {
            unitName = " M";
            unitSize = 1000000L;
        } else if (bit_rate < 1000000000000L) {
            unitName = " G";
            unitSize = 1000000000L;
        } else {
            unitName = " T";
            unitSize = 1000000000000L;
        }
        long whole = bit_rate / unitSize;
        if (whole < 100L) {
            int fraction = (int)(bit_rate % unitSize * 10L / unitSize);
            return "" + whole + '.' + fraction + unitName;
        }
        return whole + unitName;
    }

    public static int compareToIgnoreCaseCarefulEquals(String S1, String S2) {
        int diff = S1.compareToIgnoreCase(S2);
        if (diff == 0) {
            diff = S1.compareTo(S2);
        }
        return diff;
    }

    @Deprecated
    public static String intern(String S) {
        return InternUtils.intern((String)S);
    }

    public static int indexOf(String source, String target, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex>toIndex: fromIndex=" + fromIndex + ", toIndex=" + toIndex);
        }
        int sourceCount = source.length();
        if (toIndex < sourceCount) {
            sourceCount = toIndex;
        }
        int targetCount = target.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static String firstLineOnly(String value, int maxCharacters) {
        if (value == null) {
            return value;
        }
        int pos = value.indexOf(lineSeparator);
        if (pos == -1) {
            pos = value.length();
        }
        if (pos > maxCharacters) {
            pos = maxCharacters;
        }
        return pos == value.length() ? value : value.substring(0, pos) + '\u2026';
    }

    public static String nullIfEmpty(String value) {
        return value == null || value.isEmpty() ? null : value;
    }
}

