/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.util.ArrayList;
import java.util.Collection;

public class AutoGrowArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 4698056683308968140L;

    public AutoGrowArrayList() {
    }

    public AutoGrowArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public AutoGrowArrayList(Collection<E> c) {
        super(c);
    }

    @Override
    public E set(int index, E element) {
        int minSize = index + 1;
        this.ensureCapacity(minSize);
        while (this.size() < minSize) {
            this.add(null);
        }
        return super.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.ensureCapacity(index + 1);
        while (this.size() < index) {
            this.add(null);
        }
        super.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.ensureCapacity(index + c.size());
        while (this.size() < index) {
            this.add(null);
        }
        return super.addAll(index, c);
    }
}

