/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.swing;

import com.aoindustries.swing.ApplicationResources;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;

public class SynchronizingListModel<E>
extends DefaultListModel {
    private static final long serialVersionUID = -4928047430792677729L;
    private final E constantFirstRow;

    public SynchronizingListModel() {
        this.constantFirstRow = null;
    }

    public SynchronizingListModel(E constantFirstRow) {
        this.constantFirstRow = constantFirstRow;
        this.addElement(constantFirstRow);
    }

    public void synchronize(List<? extends E> list) {
        int modelOffset;
        assert (SwingUtilities.isEventDispatchThread()) : ApplicationResources.accessor.getMessage("assert.notRunningInSwingEventThread");
        if (this.constantFirstRow != null) {
            modelOffset = 1;
            if (this.isEmpty()) {
                this.addElement(this.constantFirstRow);
            } else if (!this.getElementAt(0).equals(this.constantFirstRow)) {
                this.insertElementAt(this.constantFirstRow, 0);
            }
        } else {
            modelOffset = 0;
        }
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            E obj = list.get(index);
            if (index >= this.size() - modelOffset) {
                this.addElement(obj);
                continue;
            }
            if (obj.equals(this.getElementAt(index + modelOffset))) continue;
            int foundIndex = -1;
            for (int searchIndex = index + 1; searchIndex < this.size() - modelOffset; ++searchIndex) {
                if (!obj.equals(this.getElementAt(searchIndex + modelOffset))) continue;
                foundIndex = searchIndex;
                break;
            }
            if (foundIndex != -1) {
                this.removeRange(index + modelOffset, foundIndex - 1 + modelOffset);
                continue;
            }
            this.insertElementAt(obj, index + modelOffset);
        }
        if (this.size() - modelOffset > size) {
            this.removeRange(size + modelOffset, this.size() - 1);
        }
    }
}

