/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.swing;

import com.aoindustries.awt.MultiBorderLayout;
import com.aoindustries.swing.DefaultJDialog;
import com.aoindustries.swing.EnterJButton;
import com.aoindustries.util.ErrorPrinter;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorDialog
extends DefaultJDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private EnterJButton closeButton;

    public ErrorDialog(Component parent, String title, Throwable T) {
        this(parent, title, T, null);
    }

    public ErrorDialog(Component parent, String title, Throwable T, Object[] extraInfo) {
        super(parent instanceof JFrame ? (JFrame)parent : new JFrame(), title, true, 400, 300);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new MultiBorderLayout());
        contentPane.add((Component)new JLabel(" "), "North");
        contentPane.add((Component)new JLabel("An application error has occurred.  Please provide a", 0), "North");
        contentPane.add((Component)new JLabel("copy of this error to your system administrator.", 0), "North");
        contentPane.add((Component)new JLabel(" "), "North");
        CharArrayWriter cout = new CharArrayWriter();
        PrintWriter pout = new PrintWriter(cout);
        ErrorPrinter.printStackTraces((Throwable)T, (Appendable)pout, (Object[])extraInfo);
        pout.flush();
        String errorText = cout.toString();
        JTextArea textArea = new JTextArea(errorText, 25, 80);
        textArea.setEditable(false);
        textArea.setCaretPosition(0);
        contentPane.add(new JScrollPane(textArea));
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 0, 0));
        contentPane.add((Component)buttonPanel, "South");
        this.closeButton = new EnterJButton("Close");
        buttonPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.closeButton.setToolTipText("Close this window.");
        this.pack();
        this.center(parent);
        this.closeButton.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.closeButton) {
            this.closeWindow();
        }
    }
}

