/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class DefaultJDialog
extends JDialog
implements WindowListener,
ComponentListener {
    public static final int DEFAULT_MIN_WIDTH = 800;
    public static final int DEFAULT_MIN_HEIGHT = 600;
    private static final long serialVersionUID = 1L;
    private final int minWidth;
    private final int minHeight;

    public DefaultJDialog(JFrame parent, String title, boolean modal) {
        this(parent, title, modal, 800, 600);
    }

    public DefaultJDialog(JFrame parent, String title, boolean modal, int minWidth, int minHeight) {
        super(parent, title, modal);
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
    }

    public final void center(Component parent) {
        Rectangle parentBounds = parent.getBounds();
        Dimension size = this.getSize();
        this.setBounds(parentBounds.x + (parentBounds.width - size.width) / 2, parentBounds.y + (parentBounds.height - size.height) / 2, size.width, size.height);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Object source = e.getSource();
        if (source == this) {
            this.closeWindow();
        }
    }

    public final void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.checkMin();
    }

    private void checkMin() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width < this.minWidth || height < this.minHeight) {
            this.setSize(Math.max(width, this.minWidth), Math.max(height, this.minHeight));
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void pack() {
        super.pack();
        this.checkMin();
    }
}

