/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.sql;

import com.aoindustries.util.CalendarUtils;
import com.aoindustries.util.EncodingUtils;
import com.aoindustries.util.StringUtility;
import java.io.IOException;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;

public class SQLUtility {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String EOL = System.getProperty("line.separator");

    private SQLUtility() {
    }

    @Deprecated
    public static String escapeSQL(String S) {
        StringBuilder B = new StringBuilder();
        SQLUtility.escapeSQL(S, B);
        return B.toString();
    }

    @Deprecated
    public static void escapeSQL(String S, StringBuilder B) {
        for (int i = 0; i < S.length(); ++i) {
            char c = S.charAt(i);
            if (c == '\\' || c == '\'' || c == '\"' || c == '%' || c == '_') {
                B.append('\\');
            }
            B.append(c);
        }
    }

    public static String encodeString(String S) {
        if (S == null) {
            return null;
        }
        StringBuilder SB = null;
        int len = S.length();
        for (int c = 0; c < len; ++c) {
            char ch = S.charAt(c);
            if (ch < ' ' || ch > '~' || ch == '\\') {
                if (SB == null) {
                    SB = new StringBuilder();
                    if (c > 0) {
                        SB.append(S, 0, c);
                    }
                }
                if (ch == '\\') {
                    SB.append("\\\\");
                    continue;
                }
                if (ch == '\b') {
                    SB.append("\\b");
                    continue;
                }
                if (ch == '\f') {
                    SB.append("\\f");
                    continue;
                }
                if (ch == '\n') {
                    SB.append('\n');
                    continue;
                }
                if (ch == '\r') {
                    SB.append("\\r");
                    continue;
                }
                if (ch == '\t') {
                    SB.append("\\t");
                    continue;
                }
                char ich = ch;
                SB.append("\\u").append(hexChars[ich >>> 12 & 0xF]).append(hexChars[ich >>> 8 & 0xF]).append(hexChars[ich >>> 4 & 0xF]).append(hexChars[ich & 0xF]);
                continue;
            }
            if (SB == null) continue;
            SB.append(ch);
        }
        return SB == null ? S : SB.toString();
    }

    public static String decodeString(String S) {
        if (S == null) {
            return null;
        }
        StringBuilder SB = null;
        int len = S.length();
        for (int c = 0; c < len; ++c) {
            char ch = S.charAt(c);
            if (ch == '\\') {
                if (SB == null) {
                    SB = new StringBuilder();
                    if (c > 0) {
                        SB.append(S, 0, c);
                    }
                }
                if (++c < len) {
                    ch = S.charAt(c);
                    if (ch == '\\') {
                        SB.append('\\');
                        continue;
                    }
                    if (ch == 'b' || ch == 'B') {
                        SB.append('\b');
                        continue;
                    }
                    if (ch == 'f' || ch == 'F') {
                        SB.append('\f');
                        continue;
                    }
                    if (ch == 'r' || ch == 'R') {
                        SB.append('\r');
                        continue;
                    }
                    if (ch == 't' || ch == 'T') {
                        SB.append('\t');
                        continue;
                    }
                    if (ch == 'u' || ch == 'U') {
                        if (++c < len) {
                            char ch1 = S.charAt(c);
                            if (ch1 >= '0' && ch1 <= '9' || ch1 >= 'a' && ch1 <= 'f' || ch1 >= 'A' && ch1 <= 'F') {
                                if (++c < len) {
                                    char ch2 = S.charAt(c);
                                    if (ch2 >= '0' && ch2 <= '9' || ch2 >= 'a' && ch2 <= 'f' || ch2 >= 'A' && ch2 <= 'F') {
                                        if (++c < len) {
                                            char ch3 = S.charAt(c);
                                            if (ch3 >= '0' && ch3 <= '9' || ch3 >= 'a' && ch3 <= 'f' || ch3 >= 'A' && ch3 <= 'F') {
                                                if (++c < len) {
                                                    char ch4 = S.charAt(c);
                                                    if (ch4 >= '0' && ch4 <= '9' || ch4 >= 'a' && ch4 <= 'f' || ch4 >= 'A' && ch4 <= 'F') {
                                                        SB.append((char)(StringUtility.getHex(ch1) << 12 | StringUtility.getHex(ch2) << 8 | StringUtility.getHex(ch3) << 4 | StringUtility.getHex(ch4)));
                                                        continue;
                                                    }
                                                    SB.append('\\').append(ch).append(ch1).append(ch2).append(ch3).append(ch4);
                                                    continue;
                                                }
                                                SB.append('\\').append(ch).append(ch1).append(ch2).append(ch3);
                                                continue;
                                            }
                                            SB.append('\\').append(ch).append(ch1).append(ch2).append(ch3);
                                            continue;
                                        }
                                        SB.append('\\').append(ch).append(ch1).append(ch2);
                                        continue;
                                    }
                                    SB.append('\\').append(ch).append(ch1).append(ch2);
                                    continue;
                                }
                                SB.append('\\').append(ch).append(ch1);
                                continue;
                            }
                            SB.append('\\').append(ch).append(ch1);
                            continue;
                        }
                        SB.append('\\').append(ch);
                        continue;
                    }
                    SB.append('\\').append(ch);
                    continue;
                }
                SB.append('\\');
                continue;
            }
            if (SB == null) continue;
            SB.append(ch);
        }
        return SB == null ? S : SB.toString();
    }

    public static String getDate(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return CalendarUtils.formatDate((Calendar)cal);
    }

    public static Date getDate(String yyyy_mm_dd) throws IllegalArgumentException {
        return new Date(CalendarUtils.parseDate((String)yyyy_mm_dd).getTimeInMillis());
    }

    public static Date getDateTime(String s) throws IllegalArgumentException {
        if (s.length() != 19) {
            throw new IllegalArgumentException("Invalid date: " + s);
        }
        Calendar cal = Calendar.getInstance();
        int year = Integer.parseInt(s.substring(0, 4));
        cal.set(1, year);
        int month = Integer.parseInt(s.substring(5, 7));
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid date: " + s);
        }
        cal.set(2, month - 1);
        int day = Integer.parseInt(s.substring(8, 10));
        if (day < 1 || day > cal.getActualMaximum(5)) {
            throw new IllegalArgumentException("Invalid date: " + s);
        }
        cal.set(5, day);
        int hour = Integer.parseInt(s.substring(11, 13));
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Invalid hour: " + hour);
        }
        cal.set(11, hour);
        int minute = Integer.parseInt(s.substring(14, 16));
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("Invalid minute: " + minute);
        }
        cal.set(12, minute);
        int second = Integer.parseInt(s.substring(17, 19));
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Invalid second: " + second);
        }
        cal.set(13, second);
        cal.set(14, 0);
        return new Date(cal.getTimeInMillis());
    }

    public static String getDateTime(long time) {
        return time == -1L ? null : new Timestamp(time).toString().substring(0, 19);
    }

    public static String getTime(long time) {
        return time == -1L ? null : new Timestamp(time).toString().substring(11, 19);
    }

    public static long getDaysFromMillis(long time) {
        return time / 86400L;
    }

    public static long getMillisFromDays(long time) {
        return time * 86400L;
    }

    public static long roundToDay(long time) {
        return time / 86400L * 86400L;
    }

    public static String getDecimal(int pennies) {
        StringBuilder SB = new StringBuilder(10);
        if (pennies < 0) {
            SB.append('-');
            pennies = -pennies;
        }
        SB.append(pennies / 100).append('.');
        if ((pennies %= 100) < 10) {
            SB.append('0');
        }
        return SB.append(pennies).toString();
    }

    public static String getDecimal(long pennies) {
        StringBuilder SB = new StringBuilder(10);
        if (pennies < 0L) {
            SB.append('-');
            pennies = -pennies;
        }
        SB.append(pennies / 100L).append('.');
        int i = (int)(pennies % 100L);
        if (i < 10) {
            SB.append('0');
        }
        return SB.append(i).toString();
    }

    public static String getMilliDecimal(int millis) {
        StringBuilder SB = new StringBuilder(10);
        if (millis < 0) {
            SB.append('-');
            millis = -millis;
        }
        SB.append(millis / 1000).append('.');
        if ((millis %= 1000) < 10) {
            SB.append("00");
        } else if (millis < 100) {
            SB.append('0');
        }
        return SB.append(millis).toString();
    }

    public static String getMilliDecimal(long millis) {
        StringBuilder SB = new StringBuilder(10);
        if (millis < 0L) {
            SB.append('-');
            millis = -millis;
        }
        SB.append(millis / 1000L).append('.');
        if ((millis %= 1000L) < 10L) {
            SB.append("00");
        } else if (millis < 100L) {
            SB.append('0');
        }
        return SB.append(millis).toString();
    }

    public static int getMillis(String decimal) {
        boolean isNegative;
        if (decimal.length() > 0 && decimal.charAt(0) == '-') {
            isNegative = true;
            decimal = decimal.substring(1);
        } else {
            isNegative = false;
        }
        if (decimal.length() > 0 && decimal.charAt(0) == '.') {
            decimal = '0' + decimal;
        }
        if (decimal.indexOf(46) == -1) {
            decimal = decimal + ".000";
        } else if (decimal.charAt(decimal.length() - 1) == '.') {
            decimal = decimal + "000";
        } else if (decimal.length() >= 2 && decimal.charAt(decimal.length() - 2) == '.') {
            decimal = decimal + "00";
        } else if (decimal.length() >= 3 && decimal.charAt(decimal.length() - 3) == '.') {
            decimal = decimal + '0';
        }
        int len = decimal.length();
        int whole = Integer.parseInt(decimal.substring(0, len - 4));
        int millis = Integer.parseInt(decimal.substring(len - 3));
        long result = (isNegative ? -1L : 1L) * ((long)whole * 1000L + (long)millis);
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new NumberFormatException("Out of range during conversion");
        }
        return (int)result;
    }

    public static int getPennies(String decimal) {
        boolean isNegative;
        if (decimal.length() > 0 && decimal.charAt(0) == '-') {
            isNegative = true;
            decimal = decimal.substring(1);
        } else {
            isNegative = false;
        }
        if (decimal.length() > 0 && decimal.charAt(0) == '.') {
            decimal = '0' + decimal;
        }
        if (decimal.indexOf(46) == -1) {
            decimal = decimal + ".00";
        } else if (decimal.charAt(decimal.length() - 1) == '.') {
            decimal = decimal + "00";
        } else if (decimal.length() >= 2 && decimal.charAt(decimal.length() - 2) == '.') {
            decimal = decimal + '0';
        }
        int len = decimal.length();
        int dollars = Integer.parseInt(decimal.substring(0, len - 3));
        int pennies = Integer.parseInt(decimal.substring(len - 2));
        long result = (isNegative ? -1L : 1L) * ((long)dollars * 100L + (long)pennies);
        if (result < Integer.MIN_VALUE || result > Integer.MAX_VALUE) {
            throw new NumberFormatException("Out of range during conversion");
        }
        return (int)result;
    }

    public static long getPenniesLong(String decimal) {
        boolean isNegative;
        if (decimal.length() > 0 && decimal.charAt(0) == '-') {
            isNegative = true;
            decimal = decimal.substring(1);
        } else {
            isNegative = false;
        }
        if (decimal.length() > 0 && decimal.charAt(0) == '.') {
            decimal = '0' + decimal;
        }
        if (decimal.indexOf(46) == -1) {
            decimal = decimal + ".00";
        } else if (decimal.charAt(decimal.length() - 1) == '.') {
            decimal = decimal + "00";
        } else if (decimal.length() >= 2 && decimal.charAt(decimal.length() - 2) == '.') {
            decimal = decimal + '0';
        }
        int len = decimal.length();
        long dollars = Long.parseLong(decimal.substring(0, len - 3));
        int pennies = Integer.parseInt(decimal.substring(len - 2));
        return (long)(isNegative ? -1 : 1) * (dollars * 100L + (long)pennies);
    }

    public static int negIntIfEmpty(String s) {
        return (s = StringUtility.nullIfEmpty(s)) == null ? -1 : Integer.parseInt(s);
    }

    public static long negLongIfEmpty(String s) {
        return (s = StringUtility.nullIfEmpty(s)) == null ? -1L : Long.parseLong(s);
    }

    @Deprecated
    public static String nullIfEmpty(String value) {
        return StringUtility.nullIfEmpty(value);
    }

    public static void printResultSetHTMLTable(ResultSet results, Appendable out, String title, boolean wordWrap) throws SQLException, IOException {
        int c;
        ResultSetMetaData metaData = results.getMetaData();
        int columnCount = metaData.getColumnCount();
        out.append("<table style='border:1px;' cellspacing='0' cellpadding='2'>\n");
        if (title != null) {
            out.append("  <tr><th colspan='").append(Integer.toString(columnCount)).append("'>");
            EncodingUtils.encodeHtml(title, out);
            out.append("</th></tr>\n");
        }
        out.append("  <tr>\n");
        for (c = 0; c < columnCount; ++c) {
            out.append("    <th>");
            EncodingUtils.encodeHtml(metaData.getColumnLabel(c + 1), out);
            out.append("</th>\n");
        }
        out.append("  </tr>\n");
        while (results.next()) {
            out.append("  <tr>\n");
            for (c = 0; c < columnCount; ++c) {
                String S = results.getString(c + 1);
                out.append(wordWrap ? "    <td>" : "    <td style='white-space:nowrap'>");
                if (S != null) {
                    EncodingUtils.encodeHtml(S, out);
                }
                out.append("</td>\n");
            }
            out.append("  </tr>\n");
        }
        out.append("</table>\n");
    }

    public static void printTable(Object[] titles, Object[] values, Appendable out, boolean isInteractive, boolean[] alignRights) throws IOException {
        if (isInteractive) {
            int d;
            int valuePos;
            int c;
            int columns = titles.length;
            int[] widest = new int[columns];
            int rows = values.length / columns;
            for (c = -1; c < rows; ++c) {
                Object[] row = c == -1 ? titles : values;
                valuePos = c == -1 ? 0 : c * columns;
                for (int d2 = 0; d2 < columns; ++d2) {
                    Object r = row[d2 + valuePos];
                    if (r == null) continue;
                    String S = r.toString();
                    int Slen = S.length();
                    int width = 0;
                    int pos = 0;
                    while (pos < Slen) {
                        char ch;
                        if ((ch = S.charAt(pos++)) == '\r') continue;
                        if (ch == '\n') {
                            if (width > widest[d2]) {
                                widest[d2] = width;
                            }
                            width = 0;
                            continue;
                        }
                        ++width;
                    }
                    if (width <= widest[d2]) continue;
                    widest[d2] = width;
                }
            }
            for (c = 0; c < columns; ++c) {
                String title = titles[c].toString();
                int titleLen = title.length();
                int width = widest[c];
                int before = (width - titleLen) / 2;
                for (int d3 = 0; d3 <= before; ++d3) {
                    out.append(' ');
                }
                out.append(title);
                if (c >= columns - 1) continue;
                int after = width - titleLen - before;
                for (d = 0; d <= after; ++d) {
                    out.append(' ');
                }
                out.append('|');
            }
            out.append(EOL);
            for (c = 0; c < columns; ++c) {
                int width = widest[c];
                for (int d4 = -2; d4 < width; ++d4) {
                    out.append('-');
                }
                if (c >= columns - 1) continue;
                out.append('+');
            }
            out.append(EOL);
            int[] lineCounts = new int[columns];
            int[] lineValueIndexes = new int[columns];
            valuePos = 0;
            for (int c2 = 0; c2 < rows; ++c2) {
                int maxLineCount = 1;
                for (int d5 = 0; d5 < columns; ++d5) {
                    int lineCount = 1;
                    Object value = values[valuePos + d5];
                    if (value != null) {
                        String val = value.toString();
                        int valLen = val.length();
                        for (int e = 0; e < valLen; ++e) {
                            if (val.charAt(e) != '\n') continue;
                            ++lineCount;
                        }
                    }
                    lineCounts[d5] = lineCount;
                    lineValueIndexes[d5] = 0;
                    if (lineCount <= maxLineCount) continue;
                    maxLineCount = lineCount;
                }
                for (int line = 0; line < maxLineCount; ++line) {
                    for (d = 0; d < columns; ++d) {
                        int printed;
                        Object value;
                        int width = widest[d];
                        Object object = value = line < lineCounts[d] ? values[valuePos + d] : null;
                        if (value == null) {
                            printed = 0;
                        } else {
                            boolean rightAlign = alignRights[d];
                            String val = value.toString();
                            int valLen = val.length();
                            if (valLen == 0) {
                                printed = 0;
                            } else {
                                int startPos = lineValueIndexes[d];
                                boolean trimmed = false;
                                int pos = startPos;
                                while (pos < valLen) {
                                    char ch;
                                    if ((ch = val.charAt(pos++)) != '\n') continue;
                                    val = val.substring(startPos, pos - 1);
                                    valLen = val.length();
                                    trimmed = true;
                                    break;
                                }
                                if (!trimmed) {
                                    val = val.substring(startPos);
                                    valLen = val.length();
                                }
                                lineValueIndexes[d] = pos;
                                if (valLen == 0) {
                                    printed = 0;
                                } else if (rightAlign) {
                                    int before = width - valLen + 1;
                                    for (int e = 0; e < before; ++e) {
                                        out.append(' ');
                                    }
                                    out.append(val);
                                    printed = before + valLen;
                                } else {
                                    out.append(' ');
                                    out.append(val);
                                    printed = valLen + 1;
                                }
                            }
                        }
                        if (d >= columns - 1) continue;
                        int after = width + 2 - printed;
                        for (int e = 0; e < after; ++e) {
                            out.append(' ');
                        }
                        out.append(line < lineCounts[d + 1] ? (char)'|' : ' ');
                    }
                    out.append(EOL);
                }
                valuePos += columns;
            }
            out.append("(");
            out.append(Integer.toString(rows));
            out.append(rows == 1 ? " row)" : " rows)");
            out.append(EOL);
            out.append(EOL);
        } else {
            int columns = titles.length;
            int rows = values.length / columns;
            int valuePos = 0;
            for (int c = 0; c < rows; ++c) {
                for (int d = 0; d < columns; ++d) {
                    char ch;
                    int e;
                    boolean needsQuotes;
                    Object value;
                    String S = (value = values[valuePos++]) == null ? "" : value.toString();
                    int vlen = S.length();
                    boolean bl = needsQuotes = vlen == 0;
                    if (!needsQuotes) {
                        for (e = 0; e < vlen; ++e) {
                            ch = S.charAt(e);
                            if (ch > ' ' && ch != '\\' && ch != '\'' && ch != '\"') continue;
                            needsQuotes = true;
                            break;
                        }
                    }
                    if (needsQuotes) {
                        out.append('\'');
                        for (e = 0; e < vlen; ++e) {
                            ch = S.charAt(e);
                            if (ch == '\'') {
                                out.append('\\');
                            }
                            out.append(ch);
                        }
                        out.append('\'');
                    } else {
                        out.append(S);
                    }
                    if (d >= columns - 1) continue;
                    out.append(' ');
                }
                out.append(EOL);
            }
        }
    }

    public static void printTable(Object[] titles, Collection<Object> values, Appendable out, boolean isInteractive, boolean[] alignRights) throws IOException {
        int size = values.size();
        Object[] oa = new Object[size];
        values.toArray(oa);
        SQLUtility.printTable(titles, oa, out, isInteractive, alignRights);
    }
}

