/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.sql;

import com.aoindustries.sql.ApplicationResources;
import java.io.Serializable;
import java.math.BigDecimal;

public final class NanoInterval
implements Serializable,
Comparable<NanoInterval> {
    private static final long serialVersionUID = 1L;
    private final long intervalNanos;

    public NanoInterval(long intervalNanos) {
        this.intervalNanos = intervalNanos;
    }

    public long getIntervalNanos() {
        return this.intervalNanos;
    }

    public String toString() {
        return NanoInterval.toString(this.intervalNanos);
    }

    public static String toString(long intervalNanos) {
        if (intervalNanos < 1000000L) {
            return ApplicationResources.accessor.getMessage("NanoInterval.toString.micro", new Object[]{BigDecimal.valueOf(intervalNanos, 3)});
        }
        if (intervalNanos < 1000000000L) {
            return ApplicationResources.accessor.getMessage("NanoInterval.toString.milli", new Object[]{BigDecimal.valueOf(intervalNanos / 1000L, 3)});
        }
        return ApplicationResources.accessor.getMessage("NanoInterval.toString.second", new Object[]{BigDecimal.valueOf(intervalNanos / 1000000L, 3)});
    }

    @Override
    public int compareTo(NanoInterval o) {
        if (this.intervalNanos < o.intervalNanos) {
            return -1;
        }
        if (this.intervalNanos > o.intervalNanos) {
            return 1;
        }
        return 0;
    }
}

