/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.sql;

import com.aoindustries.io.AOPool;
import com.aoindustries.sql.PostgresqlConnectionWrapper;
import com.aoindustries.util.EncodingUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AOConnectionPool
extends AOPool<Connection, SQLException, SQLException> {
    private final String driver;
    private final String url;
    private final String user;
    private final String password;
    private static final ConcurrentMap<String, Object> driversLoaded = new ConcurrentHashMap<String, Object>();

    public AOConnectionPool(String driver, String url, String user, String password, int numConnections, long maxConnectionAge, Logger logger) {
        super(AOConnectionPool.class.getName() + "?url=" + url + "&user=" + user, numConnections, maxConnectionAge, logger);
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    @Override
    protected void close(Connection conn) throws SQLException {
        conn.close();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(2, false, 1);
    }

    public Connection getConnection(boolean readOnly) throws SQLException {
        return this.getConnection(2, readOnly, 1);
    }

    public Connection getConnection(int isolationLevel, boolean readOnly) throws SQLException {
        return this.getConnection(isolationLevel, readOnly, 1);
    }

    public Connection getConnection(int isolationLevel, boolean readOnly, int maxConnections) throws SQLException {
        Connection conn = null;
        try {
            while (conn == null) {
                conn = (Connection)super.getConnection(maxConnections);
                boolean isReadOnly = conn.isReadOnly();
                if (isReadOnly == readOnly) continue;
                conn.setReadOnly(readOnly);
            }
            int currentIsolationLevel = conn.getTransactionIsolation();
            if (currentIsolationLevel != isolationLevel) {
                conn.setTransactionIsolation(isolationLevel);
            }
            return conn;
        }
        catch (SQLException err) {
            if (conn != null) {
                try {
                    this.releaseConnection(conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw err;
        }
        catch (Exception err) {
            if (conn != null) {
                try {
                    this.releaseConnection(conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SQLException(err);
        }
    }

    private static void loadDriver(String classname) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!driversLoaded.containsKey(classname)) {
            Object O = Class.forName(classname).newInstance();
            driversLoaded.putIfAbsent(classname, O);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection getConnectionObject() throws SQLException {
        Connection connection;
        block12: {
            if (Thread.interrupted()) {
                throw new SQLException("Thread interrupted");
            }
            AOConnectionPool.loadDriver(this.driver);
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            boolean successful = false;
            try {
                if (Thread.interrupted()) {
                    throw new SQLException("Thread interrupted");
                }
                if (conn.getClass().getName().startsWith("org.postgresql.")) {
                    conn = new PostgresqlConnectionWrapper(conn);
                }
                successful = true;
                connection = conn;
                if (successful) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (!successful) {
                        conn.close();
                    }
                    throw throwable;
                }
                catch (SQLException err) {
                    this.logger.logp(Level.SEVERE, AOConnectionPool.class.getName(), "getConnectionObject", "url=" + this.url + "&user=" + this.user + "&password=XXXXXXXX", err);
                    throw err;
                }
                catch (ClassNotFoundException err) {
                    SQLException sqlErr = new SQLException();
                    sqlErr.initCause(err);
                    this.logger.logp(Level.SEVERE, AOConnectionPool.class.getName(), "getConnectionObject", "url=" + this.url + "&user=" + this.user + "&password=XXXXXXXX", sqlErr);
                    throw sqlErr;
                }
                catch (InstantiationException err) {
                    SQLException sqlErr = new SQLException();
                    sqlErr.initCause(err);
                    this.logger.logp(Level.SEVERE, AOConnectionPool.class.getName(), "getConnectionObject", "url=" + this.url + "&user=" + this.user + "&password=XXXXXXXX", sqlErr);
                    throw sqlErr;
                }
                catch (IllegalAccessException err) {
                    SQLException sqlErr = new SQLException();
                    sqlErr.initCause(err);
                    this.logger.logp(Level.SEVERE, AOConnectionPool.class.getName(), "getConnectionObject", "url=" + this.url + "&user=" + this.user + "&password=XXXXXXXX", sqlErr);
                    throw sqlErr;
                }
            }
            conn.close();
        }
        return connection;
    }

    @Override
    protected boolean isClosed(Connection conn) throws SQLException {
        return conn.isClosed();
    }

    @Override
    protected void printConnectionStats(Appendable out) throws IOException {
        out.append("  <tr><th colspan='2'><span style='font-size:large;'>JDBC Driver</span></th></tr>\n  <tr><td>Driver:</td><td>");
        EncodingUtils.encodeHtml((Object)this.driver, false, false, out);
        out.append("</td></tr>\n  <tr><td>URL:</td><td>");
        EncodingUtils.encodeHtml((Object)this.url, false, false, out);
        out.append("</td></tr>\n  <tr><td>User:</td><td>");
        EncodingUtils.encodeHtml((Object)this.user, false, false, out);
        out.append("</td></tr>\n  <tr><td>Password:</td><td>");
        int len = this.password.length();
        for (int c = 0; c < len; ++c) {
            out.append('*');
        }
        out.append("</td></tr>\n");
    }

    @Override
    protected void resetConnection(Connection conn) throws SQLException {
        if (Thread.interrupted()) {
            throw new SQLException("Thread interrupted");
        }
        SQLWarning warning = conn.getWarnings();
        if (warning != null) {
            this.logger.logp(Level.WARNING, AOConnectionPool.class.getName(), "resetConnection", null, warning);
        }
        conn.clearWarnings();
        if (!conn.getAutoCommit()) {
            if (Thread.interrupted()) {
                throw new SQLException("Thread interrupted");
            }
            conn.setAutoCommit(true);
        }
        if (conn.getTransactionIsolation() != 2) {
            if (Thread.interrupted()) {
                throw new SQLException("Thread interrupted");
            }
            conn.setTransactionIsolation(2);
        }
        if (!conn.isReadOnly()) {
            if (Thread.interrupted()) {
                throw new SQLException("Thread interrupted");
            }
            conn.setReadOnly(true);
        }
    }

    @Override
    protected SQLException newException(String message, Throwable cause) {
        SQLException err = new SQLException(message);
        if (cause != null) {
            err.initCause(cause);
        }
        return err;
    }

    @Override
    protected SQLException newInterruptedException(String message, Throwable cause) {
        return this.newException(message, cause);
    }

    @Override
    public String toString() {
        return "AOConnectionPool(url=\"" + this.url + "\", user=\"" + this.user + "\")";
    }
}

