/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.rmi;

import com.aoindustries.lang.ObjectUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class RMIClientSocketFactorySSL
implements RMIClientSocketFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String localAddress;

    public RMIClientSocketFactorySSL() {
        this.localAddress = null;
    }

    public RMIClientSocketFactorySSL(String localAddress) {
        this.localAddress = localAddress;
    }

    public boolean equals(Object O) {
        return O != null && O instanceof RMIClientSocketFactorySSL && ObjectUtils.equals((Object)this.localAddress, (Object)((RMIClientSocketFactorySSL)O).localAddress);
    }

    public int hashCode() {
        return this.localAddress == null ? 0 : this.localAddress.hashCode();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Socket regSocket = new Socket();
        if (this.localAddress != null) {
            regSocket.bind(new InetSocketAddress(this.localAddress, 0));
        }
        regSocket.connect(new InetSocketAddress(host, port), 30000);
        regSocket.setKeepAlive(true);
        regSocket.setTcpNoDelay(true);
        return sslFact.createSocket(regSocket, host, port, true);
    }
}

