/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.net;

import com.aoindustries.net.HttpParameters;
import com.aoindustries.net.HttpParametersUtils;
import com.aoindustries.servlet.http.Dispatcher;
import com.aoindustries.servlet.http.LastModifiedServlet;
import com.aoindustries.servlet.http.ServletUtil;
import com.aoindustries.util.StringUtility;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.PageContext;

public class UrlUtils {
    private static final char[] noEncodeCharacters = new char[]{'?', ':', '/', ';', '#', '+'};

    private UrlUtils() {
    }

    public static String encodeUrlPath(String href, String encoding) throws UnsupportedEncodingException {
        if (href.startsWith("tel:")) {
            return href.replace(' ', '-');
        }
        int len = href.length();
        int pos = 0;
        int anchorAt = href.lastIndexOf(35);
        int paramsAt = href.lastIndexOf(63, (anchorAt == -1 ? len : anchorAt) - 1);
        int stopAt = paramsAt == -1 ? (anchorAt == -1 ? len : anchorAt) : paramsAt;
        StringBuilder SB = new StringBuilder(href.length() * 2);
        while (pos < stopAt) {
            int nextPos = StringUtility.indexOf(href, noEncodeCharacters, pos);
            if (nextPos == -1) {
                SB.append(URLEncoder.encode(href.substring(pos, stopAt), encoding));
                pos = len;
                continue;
            }
            if (nextPos > stopAt) {
                nextPos = stopAt;
            }
            SB.append(URLEncoder.encode(href.substring(pos, nextPos), encoding));
            if (nextPos < stopAt) {
                char nextChar = href.charAt(nextPos++);
                SB.append(nextChar);
            }
            pos = nextPos;
        }
        SB.append(href, stopAt, len);
        return SB.toString();
    }

    public static String decodeUrlPath(String href, String encoding) throws UnsupportedEncodingException {
        if (href.startsWith("tel:")) {
            return href;
        }
        int len = href.length();
        int pos = 0;
        StringBuilder SB = new StringBuilder(href.length() * 2);
        while (pos < len) {
            int nextPos = StringUtility.indexOf(href, noEncodeCharacters, pos);
            if (nextPos == -1) {
                SB.append(URLDecoder.decode(href.substring(pos, len), encoding));
                pos = len;
                continue;
            }
            SB.append(URLDecoder.decode(href.substring(pos, nextPos), encoding));
            char nextChar = href.charAt(nextPos);
            if (nextChar == '?') {
                SB.append(href, nextPos, len);
                pos = len;
                continue;
            }
            SB.append(nextChar);
            pos = nextPos + 1;
        }
        return SB.toString();
    }

    public static String buildUrl(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String href, HttpParameters params, boolean hrefAbsolute, LastModifiedServlet.AddLastModifiedWhen addLastModified) throws MalformedURLException, UnsupportedEncodingException {
        String contextPath;
        String responseEncoding = response.getCharacterEncoding();
        String servletPath = Dispatcher.getCurrentPagePath(request);
        href = ServletUtil.getAbsolutePath(servletPath, href);
        href = HttpParametersUtils.addParams(href, params, responseEncoding);
        href = LastModifiedServlet.addLastModified(servletContext, request, servletPath, href, addLastModified);
        if (!hrefAbsolute && href.startsWith("/") && (contextPath = request.getContextPath()).length() > 0) {
            href = contextPath + href;
        }
        href = UrlUtils.encodeUrlPath(href, responseEncoding);
        href = response.encodeURL(href);
        if (hrefAbsolute && href.startsWith("/")) {
            href = ServletUtil.getAbsoluteURL(request, href);
        }
        return href;
    }

    public static String buildUrl(PageContext pageContext, String href, HttpParameters params, boolean hrefAbsolute, LastModifiedServlet.AddLastModifiedWhen addLastModified) throws MalformedURLException, UnsupportedEncodingException {
        return UrlUtils.buildUrl(pageContext.getServletContext(), (HttpServletRequest)pageContext.getRequest(), (HttpServletResponse)pageContext.getResponse(), href, params, hrefAbsolute, addLastModified);
    }

    public static String buildUrl(JspContext jspContext, String src, HttpParameters params, boolean srcAbsolute, LastModifiedServlet.AddLastModifiedWhen addLastModified) throws MalformedURLException, UnsupportedEncodingException {
        return UrlUtils.buildUrl((PageContext)jspContext, src, params, srcAbsolute, addLastModified);
    }
}

