/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.net;

import com.aoindustries.io.BitRateOutputStream;
import com.aoindustries.io.BitRateProvider;
import com.aoindustries.util.BufferManager;
import com.aoindustries.util.ErrorPrinter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.Socket;
import java.net.SocketException;

public abstract class BandwidthLimitingTunnelHandlerThread
implements Runnable,
BitRateProvider {
    private static final long VERBOSE_REPORT_INTERVAL = 10000L;
    private final boolean verbose;
    private final Long bandwidth;
    private final Socket listenSocket;
    private final Socket connectSocket;
    private volatile Thread thread;

    public BandwidthLimitingTunnelHandlerThread(boolean verbose, Long bandwidth, Socket listenSocket, Socket connectSocket) {
        this.verbose = verbose;
        this.bandwidth = bandwidth;
        this.listenSocket = listenSocket;
        this.connectSocket = connectSocket;
    }

    public void start() {
        if (this.thread != null) {
            throw new IllegalStateException();
        }
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long totalBytes = 0L;
            long startTime = this.verbose ? System.currentTimeMillis() : 0L;
            byte[] buff = BufferManager.getBytes();
            try {
                OutputStream out = this.getOutputStream(this.listenSocket, this.connectSocket);
                if (this.bandwidth != null) {
                    out = new BitRateOutputStream(out, this);
                }
                try {
                    InputStream in = this.getInputStream(this.listenSocket, this.connectSocket);
                    try {
                        int ret;
                        long blockStartTime = this.verbose ? System.currentTimeMillis() : 0L;
                        long blockByteCount = 0L;
                        while ((ret = in.read(buff, 0, 4096)) != -1) {
                            out.write(buff, 0, ret);
                            totalBytes += (long)ret;
                            if (!this.verbose) continue;
                            blockByteCount += (long)ret;
                            long currentTime = System.currentTimeMillis();
                            long blockTime = currentTime - blockStartTime;
                            if (blockTime < 0L) {
                                blockStartTime = currentTime;
                                blockByteCount = 0L;
                                continue;
                            }
                            if (blockTime < 10000L) continue;
                            System.out.println(this.getDirection() + " " + totalBytes + " bytes sent in " + BigDecimal.valueOf(currentTime - startTime, 3) + " seconds, " + blockByteCount * 8000L / blockTime + " bits/second");
                            blockStartTime = currentTime;
                            blockByteCount = 0L;
                        }
                    }
                    catch (SocketException err) {
                        if (!"Socket closed".equals(err.getMessage())) {
                            throw err;
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    out.close();
                }
            }
            finally {
                BufferManager.release((byte[])buff, (boolean)false);
            }
            if (this.verbose) {
                long endTime = System.currentTimeMillis();
                System.out.println(this.getDirection() + " Connection closing: " + totalBytes + " bytes sent in " + BigDecimal.valueOf(endTime - startTime, 3) + " seconds, " + totalBytes * 8000L / (endTime - startTime) + " bits/second average");
            }
        }
        catch (IOException err) {
            ErrorPrinter.printStackTraces((Throwable)err);
        }
    }

    @Override
    public int getBlockSize() {
        return 4096;
    }

    @Override
    public Long getBitRate() {
        return this.bandwidth;
    }

    protected abstract String getDirection();

    protected abstract OutputStream getOutputStream(Socket var1, Socket var2) throws IOException;

    protected abstract InputStream getInputStream(Socket var1, Socket var2) throws IOException;
}

