/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.net;

import com.aoindustries.net.BandwidthLimitingTunnelHandler;
import com.aoindustries.util.ErrorPrinter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class BandwidthLimitingTunnel
implements Runnable {
    private final boolean verbose;
    private final String listen_address;
    private final int listen_port;
    private final String connect_address;
    private final int connect_port;
    private final Long upstream_bandwidth;
    private final Long downstream_bandwidth;
    private final Thread thread;

    public BandwidthLimitingTunnel(boolean verbose, String listen_address, int listen_port, String connect_address, int connect_port, Long upstream_bandwidth, Long downstream_bandwidth) {
        this.verbose = verbose;
        this.listen_address = listen_address;
        this.listen_port = listen_port;
        this.connect_address = connect_address;
        this.connect_port = connect_port;
        this.upstream_bandwidth = upstream_bandwidth;
        this.downstream_bandwidth = downstream_bandwidth;
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) {
        boolean verbose;
        if (args.length != 6 && args.length != 7) {
            BandwidthLimitingTunnel.printUsage();
            System.exit(1);
            return;
        }
        int pos = 0;
        if (args.length == 7) {
            if (!args[pos++].equals("-v")) {
                BandwidthLimitingTunnel.printUsage();
                System.exit(1);
                return;
            }
            verbose = true;
        } else {
            verbose = false;
        }
        String listen_address = args[pos++];
        int listen_port = Integer.parseInt(args[pos++]);
        String connect_address = args[pos++];
        int connect_port = Integer.parseInt(args[pos++]);
        String S = args[pos++];
        Long upstream_bandwidth = S.length() == 0 ? null : Long.valueOf(Long.parseLong(S));
        S = args[pos++];
        Long downstream_bandwidth = S.length() == 0 ? null : Long.valueOf(Long.parseLong(S));
        new BandwidthLimitingTunnel(verbose, listen_address, listen_port, connect_address, connect_port, upstream_bandwidth, downstream_bandwidth);
    }

    private static void printUsage() {
        System.err.println("usage: " + BandwidthLimitingTunnel.class.getName() + " [-v] {listen_address|*} <listen_port> {connect_address} {connect_port} {upstream_bandwidth|\"\"} {downstream_bandwidth|\"\"}");
        System.err.println("        -v                   - switch to display status of each connection on standard output");
        System.err.println("        listen_address       - the hostname or IP address to listen to or * to listen on all local IP addresses");
        System.err.println("        listen_port          - the port to listen to");
        System.err.println("        connect_address      - the hostname or IP address to connect to for each tunnel");
        System.err.println("        connect_port         - the port to connect to for each tunnel");
        System.err.println("        upstream_bandwidth   - the maximum number of bits per second for upstream bandwidth or \"\" for unlimited");
        System.err.println("        downstream_bandwidth - the maximum number of bits per second for downstream bandwidth or \"\" for unlimited");
    }

    @Override
    public void run() {
        while (this.thread == Thread.currentThread()) {
            try {
                if (this.thread != Thread.currentThread()) continue;
                if (this.verbose) {
                    System.out.println("Accepting connections on " + this.listen_address + ":" + this.listen_port);
                }
                ServerSocket serverSocket = new ServerSocket(this.listen_port, 50, this.listen_address.equals("*") ? null : InetAddress.getByName(this.listen_address));
                while (true) {
                    Socket socket = serverSocket.accept();
                    if (this.verbose) {
                        System.out.println("New connection from " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                    }
                    new BandwidthLimitingTunnelHandler(this.verbose, this.connect_address, this.connect_port, this.upstream_bandwidth, this.downstream_bandwidth, socket);
                }
            }
            catch (ThreadDeath TD) {
                throw TD;
            }
            catch (Throwable T) {
                ErrorPrinter.printStackTraces((Throwable)T);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException err) {
                    ErrorPrinter.printStackTraces((Throwable)err);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

