/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;

public class TerminalWriter
extends PrintWriter {
    private static final char ESC = '\u001b';
    private static final char[] CLEAR_SCREEN = new char[]{'\u001b', '[', 'H', '\u001b', '[', 'J'};
    private static final char[] BOLD_ON = new char[]{'\u001b', '[', '1', 'm'};
    private static final char[] ATTRIBUTES_OFF = new char[]{'\u001b', '[', 'm'};
    private static final boolean supported = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux");
    private boolean enabled = true;

    public static boolean isSupported() {
        return supported;
    }

    private static String getVerboseOut(String lastVerboseString, String newVerboseString) {
        int i;
        int lastLen = lastVerboseString.length();
        int newLen = newVerboseString.length();
        StringBuilder verboseOut = new StringBuilder();
        int sameCount = 0;
        for (i = 0; i < newLen && i < lastLen && lastVerboseString.charAt(i) == newVerboseString.charAt(i); ++i) {
            ++sameCount;
        }
        for (i = newLen; i < lastLen; ++i) {
            verboseOut.append('\b');
        }
        for (i = newLen; i < lastLen; ++i) {
            verboseOut.append(' ');
        }
        for (i = 0; i < lastLen - sameCount; ++i) {
            verboseOut.append('\b');
        }
        verboseOut.append(newVerboseString, sameCount, newLen);
        return verboseOut.toString();
    }

    public static String progressOutput(String lastVerboseString, String newVerboseString, PrintStream out) {
        out.print(TerminalWriter.getVerboseOut(lastVerboseString, newVerboseString));
        out.flush();
        return newVerboseString;
    }

    public static String progressOutput(String lastVerboseString, String newVerboseString, Writer out) throws IOException {
        out.write(TerminalWriter.getVerboseOut(lastVerboseString, newVerboseString));
        out.flush();
        return newVerboseString;
    }

    public TerminalWriter(Writer out) {
        super(out);
    }

    public TerminalWriter(Writer out, boolean autoFlush) {
        super(out, autoFlush);
    }

    public void attributesOff() throws IOException {
        if (supported && this.enabled) {
            this.flush();
            this.out.write(ATTRIBUTES_OFF);
            this.out.flush();
        }
    }

    public void boldOn() throws IOException {
        if (supported && this.enabled) {
            this.flush();
            this.out.write(BOLD_ON);
            this.out.flush();
        }
    }

    public void clearScreen() throws IOException {
        if (supported && this.enabled) {
            this.flush();
            this.out.write(CLEAR_SCREEN);
            this.out.flush();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String progressOutput(String lastVerboseString, String newVerboseString) throws IOException {
        return TerminalWriter.progressOutput(lastVerboseString, newVerboseString, this.out);
    }
}

