/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.util.AoArrays;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class SyncFile {
    private static final boolean DEBUG = true;
    private static final boolean DRY_RUN = false;
    private static final int BLOCK_SIZE = 0x100000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("usage: " + SyncFile.class.getName() + " <from> <to>");
            System.exit(1);
        } else {
            try {
                long bytesWritten;
                File from = new File(args[0]);
                File to = new File(args[1]);
                System.err.println("Opening " + from);
                FileInputStream in = new FileInputStream(from);
                try {
                    System.err.println("Opening " + to);
                    RandomAccessFile out = new RandomAccessFile(to, "rw");
                    try {
                        bytesWritten = SyncFile.syncFile(in, out);
                    }
                    finally {
                        System.err.println("Closing " + to);
                        out.close();
                    }
                }
                finally {
                    System.err.println("Closing " + from);
                    in.close();
                }
                System.err.println("Wrote " + bytesWritten + " bytes");
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static long syncFile(InputStream in, RandomAccessFile out) throws IOException {
        int numBytes;
        byte[] inBuff = new byte[0x100000];
        byte[] outBuff = new byte[0x100000];
        long pos = 0L;
        long bytesWritten = 0L;
        while ((numBytes = in.read(inBuff, 0, 0x100000)) != -1) {
            System.err.println(pos + ": Read " + numBytes + " bytes of input");
            out.seek(pos);
            long blockEnd = pos + (long)numBytes;
            if (out.length() >= blockEnd) {
                System.err.println(pos + ": Reading " + numBytes + " bytes of output");
                out.readFully(outBuff, 0, numBytes);
                if (!AoArrays.equals((byte[])inBuff, (byte[])outBuff, (int)0, (int)numBytes)) {
                    System.err.println(pos + ": Updating " + numBytes + " bytes of output");
                    out.seek(pos);
                    out.write(inBuff, 0, numBytes);
                    bytesWritten += (long)numBytes;
                } else {
                    System.err.println(pos + ": Data matches, not writing");
                }
            } else {
                System.err.println(pos + ": Appending " + numBytes + " bytes to output");
                out.write(inBuff, 0, numBytes);
                bytesWritten += (long)numBytes;
            }
            pos = blockEnd;
        }
        if (out.length() != pos) {
            System.err.println(pos + ": Truncating output to " + pos + " bytes");
            assert (out.length() > pos);
            try {
                out.setLength(pos);
            }
            catch (IOException e) {
                System.err.println("Warning: Unable to truncate output to " + pos + " bytes");
            }
        }
        return bytesWritten;
    }
}

