/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.BitRate;
import com.aoindustries.io.BitRateOutputStream;
import com.aoindustries.io.BitRateProvider;
import com.aoindustries.io.ByteCount;
import com.aoindustries.io.PrintStreamOutputStream;
import com.aoindustries.util.GetOpt;
import com.aoindustries.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class RateLimitCat {
    private RateLimitCat() {
    }

    private static void usage() {
        System.err.println("Usage: " + RateLimitCat.class.getName() + " [--blocksize=BLOCK_SIZE[unit]] [--bwlimit=BANDWIDTH_LIMIT[unit]] [--limit=MAXIMUM_BYTES[unit]] [--output=OUTPUT_FILE] [--progress[={true|false}]] [--] [FILE]...");
        System.err.println();
        System.err.println("\tWhen FILE is not provided, reads from standard input.");
        System.err.println("\tWhen FILE is -, will read from standard input.");
        System.err.println("\tWhen -- is first found, all subsequent arguments will be treated as filenames, including any - and --.");
        System.err.println();
        System.err.println("\t--blocksize  Reads and writes at most BLOCK_SIZE bytes at a time.  Allows an optional unit.");
        System.err.println("\t             If not provided, defaults to 4096 bytes.  Unit supports IEC_60027");
        System.err.println("\t             prefixes on the unit byte, such as kbyte for 1000 bytes or Kibyte for 1024 bytes.");
        System.err.println("\t--bwlimit    The maximum bandwidth for reads and writes.  Allows an optional unit.");
        System.err.println("\t             If not provided, defaults to bits per second.  Unit supports IEC_60027");
        System.err.println("\t             prefixes on the units bit or byte, such as kbyte for 1000 bytes per second");
        System.err.println("\t             or Kibit for 1024 bits per second.");
        System.err.println("\t--limit      Reads and writes at most MAXIMUM_BYTES bytes.  Allows an optional unit.");
        System.err.println("\t             If not provided, defaults to bytes.  Unit supports IEC_60027 prefixes");
        System.err.println("\t             on the unit byte, such as kbyte for 1000 bytes or Kibyte for 1024 bytes.");
        System.err.println("\t--output     Writes the output to OUTPUT_FILE instead of standard output.");
        System.err.println("\t--progress   Displays the progress of the files once every 60 seconds.");
        System.err.flush();
    }

    private static void report(String filename, long byteCount, long timespan, long[] bytesRemaining) {
        System.err.print(filename);
        System.err.print(": ");
        System.err.print(byteCount);
        System.err.print(" bytes (");
        System.err.print(StringUtility.getApproximateSize(byteCount));
        System.err.print(") transferred in ");
        System.err.print(BigDecimal.valueOf(timespan, 3));
        System.err.print(" seconds (");
        System.err.print(StringUtility.getTimeLengthString(timespan));
        System.err.print(')');
        if (bytesRemaining != null && bytesRemaining[0] > 0L) {
            System.err.print(", ");
            System.err.print(bytesRemaining[0]);
            System.err.print(" bytes (");
            System.err.print(StringUtility.getApproximateSize(bytesRemaining[0]));
            System.err.print(") remaining");
        }
        System.err.println();
        System.err.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transfer(String filename, InputStream in, OutputStream out, byte[] buff, boolean progress, long[] bytesRemaining) throws IOException {
        long startTime = System.currentTimeMillis();
        long lastReportByteCount = -1L;
        long lastReportTime = startTime;
        long byteCount = 0L;
        try {
            while (true) {
                int bytesRead;
                int blockSize = buff.length;
                if (bytesRemaining != null) {
                    if (bytesRemaining[0] <= 0L) {
                        break;
                    }
                    if (bytesRemaining[0] < (long)blockSize) {
                        blockSize = (int)bytesRemaining[0];
                    }
                }
                if ((bytesRead = in.read(buff, 0, blockSize)) == -1) {
                    break;
                }
                out.write(buff, 0, bytesRead);
                byteCount += (long)bytesRead;
                if (bytesRemaining != null) {
                    bytesRemaining[0] = bytesRemaining[0] - (long)bytesRead;
                }
                if (!progress || lastReportByteCount == byteCount) continue;
                long currentTime = System.currentTimeMillis();
                long timeSinceReport = currentTime - lastReportTime;
                if (timeSinceReport < 0L) {
                    lastReportTime = currentTime;
                    continue;
                }
                if (timeSinceReport < 60000L) continue;
                RateLimitCat.report(filename, byteCount, currentTime - startTime, bytesRemaining);
                lastReportByteCount = byteCount;
                lastReportTime = currentTime;
            }
        }
        finally {
            if (progress && lastReportByteCount != byteCount) {
                RateLimitCat.report(filename, byteCount, System.currentTimeMillis() - startTime, bytesRemaining);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int retval;
        block30: {
            retval = 0;
            try {
                long[] bytesRemaining;
                int blockSize;
                ByteCount blocksizeParam = (ByteCount)GetOpt.getOpt((String[])args, (String)"blocksize", ByteCount.class);
                if (blocksizeParam == null) {
                    blockSize = 4096;
                } else {
                    long longBlockSize = blocksizeParam.getByteCount();
                    if (longBlockSize > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("blocksize>Integer.MAX_VALUE: " + blocksizeParam);
                    }
                    if (longBlockSize < 1L) {
                        throw new IllegalArgumentException("blocksize<1: " + blocksizeParam);
                    }
                    blockSize = (int)longBlockSize;
                }
                final BitRate bwlimit = (BitRate)GetOpt.getOpt((String[])args, (String)"bwlimit", BitRate.class);
                if (bwlimit != null && bwlimit.getBitRate() < 1L) {
                    throw new IllegalArgumentException("bwlimit<1: " + bwlimit);
                }
                ByteCount limit = (ByteCount)GetOpt.getOpt((String[])args, (String)"limit", ByteCount.class);
                if (limit == null) {
                    bytesRemaining = null;
                } else {
                    long temp = limit.getByteCount();
                    if (temp < 0L) {
                        throw new IllegalArgumentException("limit<0: " + limit);
                    }
                    bytesRemaining = new long[]{temp};
                }
                File output = (File)GetOpt.getOpt((String[])args, (String)"output", File.class);
                Boolean progressParam = (Boolean)GetOpt.getOpt((String[])args, (String)"progress", Boolean.TYPE);
                boolean progress = progressParam != null ? progressParam : false;
                List sourcePaths = GetOpt.getArguments((String[])args);
                ArrayList<File> sourceFiles = new ArrayList<File>(sourcePaths.size() + 1);
                boolean allowStdin = true;
                boolean hasError = false;
                for (String sourcePath : sourcePaths) {
                    if (allowStdin && "--".equals(sourcePath)) {
                        allowStdin = false;
                        continue;
                    }
                    if (allowStdin && "-".equals(sourcePath)) {
                        sourceFiles.add(null);
                        continue;
                    }
                    File sourceFile = new File(sourcePath);
                    if (!sourceFile.exists()) {
                        System.err.println("File not found: " + sourcePath);
                        hasError = true;
                        continue;
                    }
                    if (sourceFile.isDirectory()) {
                        System.err.println("Directories not supported: " + sourcePath);
                        hasError = true;
                        continue;
                    }
                    if (!sourceFile.canRead()) {
                        System.err.println("Unable to read file: " + sourcePath);
                        hasError = true;
                        continue;
                    }
                    sourceFiles.add(sourceFile);
                }
                if (hasError) {
                    System.err.flush();
                    retval = 2;
                    break block30;
                }
                if (sourceFiles.isEmpty()) {
                    sourceFiles.add(null);
                }
                try {
                    OutputStream out = output == null ? new PrintStreamOutputStream(System.out) : new FileOutputStream(output);
                    try {
                        if (bwlimit != null) {
                            out = new BitRateOutputStream(out, new BitRateProvider(){

                                @Override
                                public Long getBitRate() {
                                    return bwlimit.getBitRate();
                                }

                                @Override
                                public int getBlockSize() {
                                    return blockSize;
                                }
                            });
                        }
                        byte[] buff = new byte[blockSize];
                        for (File sourceFile : sourceFiles) {
                            if (bytesRemaining != null && bytesRemaining[0] <= 0L) {
                                break;
                            }
                            if (sourceFile == null) {
                                RateLimitCat.transfer("-", System.in, out, buff, progress, bytesRemaining);
                                continue;
                            }
                            FileInputStream in = new FileInputStream(sourceFile);
                            try {
                                RateLimitCat.transfer(sourceFile.getPath(), in, out, buff, progress, bytesRemaining);
                            }
                            finally {
                                ((InputStream)in).close();
                            }
                        }
                    }
                    finally {
                        out.flush();
                        out.close();
                    }
                }
                catch (IOException err) {
                    System.err.println("IO Exception: " + err.toString());
                    System.err.flush();
                    retval = 3;
                }
            }
            catch (IllegalArgumentException err) {
                System.err.println("Illegal Argument: " + err.toString());
                System.err.flush();
                RateLimitCat.usage();
                retval = 1;
            }
        }
        System.exit(retval);
    }
}

