/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class MultiFileOutputStream
extends OutputStream {
    public static final long DEFAULT_FILE_SIZE = 0x40000000L;
    private final File parent;
    private final String prefix;
    private final String suffix;
    private final long fileSize;
    private final List<File> files = new ArrayList<File>();
    private FileOutputStream out = null;
    private long bytesOut = 0L;

    public MultiFileOutputStream(File parent, String prefix, String suffix) {
        this(parent, prefix, suffix, 0x40000000L);
    }

    public MultiFileOutputStream(File parent, String prefix, String suffix, long fileSize) {
        this.parent = parent;
        this.prefix = prefix;
        this.suffix = suffix;
        this.fileSize = fileSize;
    }

    @Override
    public synchronized void close() throws IOException {
        FileOutputStream tempOut = this.out;
        if (tempOut != null) {
            this.out = null;
            tempOut.flush();
            tempOut.close();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        while (off < len) {
            int blockLen;
            long newBytesOut;
            if (this.out == null) {
                this.makeNewFile();
            }
            if ((newBytesOut = this.bytesOut + (long)(blockLen = len)) > this.fileSize) {
                blockLen = (int)(this.fileSize - newBytesOut);
            }
            this.out.write(b, off, blockLen);
            off += blockLen;
            len -= blockLen;
            this.bytesOut += (long)blockLen;
            if (this.bytesOut < this.fileSize) continue;
            FileOutputStream tempOut = this.out;
            try {
                this.out = null;
                tempOut.flush();
            }
            finally {
                tempOut.close();
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        ++this.bytesOut;
        if (this.bytesOut >= this.fileSize) {
            FileOutputStream tempOut = this.out;
            try {
                this.out = null;
                tempOut.flush();
            }
            finally {
                tempOut.close();
            }
        }
    }

    private void makeNewFile() throws IOException {
        String filename = this.prefix + (this.files.size() + 1) + this.suffix;
        File file = new File(this.parent, filename);
        this.out = new FileOutputStream(file);
        this.bytesOut = 0L;
        this.files.add(file);
    }

    public File[] getFiles() {
        File[] FA = new File[this.files.size()];
        this.files.toArray(FA);
        return FA;
    }
}

