/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MultiFileInputStream
extends InputStream {
    private final File[] files;
    private int nextFile = 0;
    private FileInputStream in = null;

    public MultiFileInputStream(File[] files) {
        this.files = files;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.in == null) {
            if (this.nextFile >= this.files.length) {
                return 0;
            }
            this.in = new FileInputStream(this.files[this.nextFile++]);
        }
        return this.in.available();
    }

    @Override
    public synchronized void close() throws IOException {
        FileInputStream tempIn;
        if (this.nextFile < this.files.length) {
            this.nextFile = this.files.length;
        }
        if ((tempIn = this.in) != null) {
            this.in = null;
            tempIn.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            if (this.in == null) {
                if (this.nextFile >= this.files.length) {
                    super.mark(readlimit);
                    return;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            this.in.mark(readlimit);
        }
        catch (IOException err) {
            super.mark(readlimit);
        }
    }

    @Override
    public synchronized boolean markSupported() {
        try {
            if (this.in == null) {
                if (this.nextFile >= this.files.length) {
                    return false;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            return this.in.markSupported();
        }
        catch (IOException err) {
            return false;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.in == null) {
            if (this.nextFile >= this.files.length) {
                return -1;
            }
            this.in = new FileInputStream(this.files[this.nextFile++]);
        }
        int value = -1;
        while (value == -1) {
            value = this.in.read();
            if (value != -1) continue;
            FileInputStream tempIn = this.in;
            try {
                this.in = null;
            }
            finally {
                tempIn.close();
            }
            if (this.nextFile >= this.files.length) {
                return -1;
            }
            this.in = new FileInputStream(this.files[this.nextFile++]);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] buff) throws IOException {
        if (buff.length > 0) {
            if (this.in == null) {
                if (this.nextFile >= this.files.length) {
                    return -1;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            int count = -1;
            while (count == -1) {
                count = this.in.read(buff);
                if (count != -1) continue;
                FileInputStream tempIn = this.in;
                try {
                    this.in = null;
                }
                finally {
                    tempIn.close();
                }
                if (this.nextFile >= this.files.length) {
                    return -1;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            return count;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] buff, int off, int len) throws IOException {
        if (len > 0) {
            if (this.in == null) {
                if (this.nextFile >= this.files.length) {
                    return -1;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            int count = -1;
            while (count == -1) {
                count = this.in.read(buff, off, len);
                if (count != -1) continue;
                FileInputStream tempIn = this.in;
                try {
                    this.in = null;
                }
                finally {
                    tempIn.close();
                }
                if (this.nextFile >= this.files.length) {
                    return -1;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            return count;
        }
        return 0;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.in == null) {
            if (this.nextFile >= this.files.length) {
                super.reset();
                return;
            }
            this.in = new FileInputStream(this.files[this.nextFile++]);
        }
        this.in.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long skip(long n) throws IOException {
        if (n > 0L) {
            if (this.in == null) {
                if (this.nextFile >= this.files.length) {
                    return -1L;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            long count = -1L;
            while (count == -1L) {
                count = this.in.skip(n);
                if (count != -1L) continue;
                FileInputStream tempIn = this.in;
                try {
                    this.in = null;
                }
                finally {
                    tempIn.close();
                }
                if (this.nextFile >= this.files.length) {
                    return -1L;
                }
                this.in = new FileInputStream(this.files[this.nextFile++]);
            }
            return count;
        }
        return 0L;
    }

    public long length() {
        long total = 0L;
        for (File file : this.files) {
            total += file.length();
        }
        return total;
    }
}

