/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.AoByteArrayInputStream;
import com.aoindustries.io.AoByteArrayOutputStream;
import com.aoindustries.io.FileListObject;
import com.aoindustries.io.FileListObjectFactory;
import com.aoindustries.io.FileUtils;
import com.aoindustries.io.FixedRecordFile;
import com.aoindustries.util.WrappedException;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.RandomAccess;

public class FileList<T extends FileListObject>
extends AbstractList<T>
implements RandomAccess {
    private final String filenamePrefix;
    private final String filenameExtension;
    private final File file;
    private final FixedRecordFile frf;
    private final FileListObjectFactory<T> objectFactory;
    private final AoByteArrayInputStream inBuffer;
    private final DataInputStream dataInBuffer;
    private final AoByteArrayOutputStream outBuffer;
    private final DataOutputStream dataOutBuffer;

    public FileList(String filenamePrefix, String filenameExtension, int objectLength, FileListObjectFactory<T> objectFactory) throws IOException {
        this.filenamePrefix = filenamePrefix;
        this.filenameExtension = filenameExtension;
        this.file = FileList.getTempFile(filenamePrefix, filenameExtension);
        this.frf = new FixedRecordFile(this.file, "rw", objectLength + 1);
        this.objectFactory = objectFactory;
        this.inBuffer = new AoByteArrayInputStream(new byte[objectLength + 1]);
        this.dataInBuffer = new DataInputStream((InputStream)this.inBuffer);
        this.outBuffer = new AoByteArrayOutputStream(objectLength + 1);
        this.dataOutBuffer = new DataOutputStream((OutputStream)this.outBuffer);
    }

    @Override
    public void clear() {
        try {
            this.frf.removeAllRecords();
            ++this.modCount;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf});
        }
    }

    @Override
    public T get(int index) {
        try {
            this.frf.seekToExistingRecord(index);
            this.inBuffer.fillFrom((DataInput)this.frf);
            if (this.dataInBuffer.readBoolean()) {
                T obj = this.objectFactory.createInstance();
                obj.readRecord(this.dataInBuffer);
                return obj;
            }
            return null;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf});
        }
    }

    public void swap(int index1, int index2) {
        try {
            this.frf.swap(index1, index2);
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf});
        }
    }

    @Override
    public int size() {
        try {
            return this.frf.getRecordCount();
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf});
        }
    }

    @Override
    public T set(int index, T element) {
        try {
            FileListObject old;
            this.frf.seekToExistingRecord(index);
            this.inBuffer.fillFrom((DataInput)this.frf);
            if (this.dataInBuffer.readBoolean()) {
                old = (FileListObject)this.objectFactory.createInstance();
                old.readRecord(this.dataInBuffer);
            } else {
                old = null;
            }
            this.frf.seekToExistingRecord(index);
            this.outBuffer.reset();
            if (element == null) {
                this.dataOutBuffer.writeBoolean(false);
            } else {
                T newObj = element;
                this.dataOutBuffer.writeBoolean(true);
                newObj.writeRecord(this.dataOutBuffer);
            }
            int recordSize = this.outBuffer.size();
            if (recordSize > this.frf.getRecordLength()) {
                throw new IOException("Record length exceeded: outBuffer.size()=" + recordSize + ", frf.getRecordLength()=" + this.frf.getRecordLength());
            }
            this.outBuffer.writeTo((RandomAccessFile)this.frf);
            return (T)old;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf});
        }
    }

    @Override
    public void add(int index, T element) {
        try {
            this.outBuffer.reset();
            if (element == null) {
                this.dataOutBuffer.writeBoolean(false);
            } else {
                T newObj = element;
                this.dataOutBuffer.writeBoolean(true);
                newObj.writeRecord(this.dataOutBuffer);
            }
            int recordSize = this.outBuffer.size();
            if (recordSize > this.frf.getRecordLength()) {
                throw new IOException("Record length exceeded: outBuffer.size()=" + recordSize + ", frf.getRecordLength()=" + this.frf.getRecordLength());
            }
            this.frf.addRecord(index);
            this.outBuffer.writeTo((RandomAccessFile)this.frf);
            ++this.modCount;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf});
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> C) {
        return this.addAll(this.size(), C);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> C) {
        try {
            if (C instanceof FileList) {
                FileList otherFL = (FileList)C;
                if (otherFL.frf.getRecordLength() == this.frf.getRecordLength()) {
                    boolean changed = false;
                    int otherSize = otherFL.size();
                    if (otherSize > 0) {
                        this.frf.addRecords(index, otherSize);
                        FixedRecordFile.copyRecords(otherFL.frf, 0L, this.frf, index, otherSize);
                        changed = true;
                    }
                    if (changed) {
                        ++this.modCount;
                    }
                    return changed;
                }
            }
            boolean changed = false;
            int otherSize = C.size();
            if (otherSize > 0) {
                this.frf.addRecords(index, otherSize);
                Iterator<T> records = C.iterator();
                int count = 0;
                while (records.hasNext()) {
                    this.outBuffer.reset();
                    FileListObject O = (FileListObject)records.next();
                    if (O == null) {
                        this.dataOutBuffer.writeBoolean(false);
                    } else {
                        this.dataOutBuffer.writeBoolean(true);
                        O.writeRecord(this.dataOutBuffer);
                    }
                    int recordSize = this.outBuffer.size();
                    if (recordSize > this.frf.getRecordLength()) {
                        throw new IOException("Record length exceeded: outBuffer.size()=" + recordSize + ", frf.getRecordLength()=" + this.frf.getRecordLength());
                    }
                    this.frf.seekToExistingRecord(index + count);
                    this.outBuffer.writeTo((RandomAccessFile)this.frf);
                    ++count;
                }
                if (count != otherSize) {
                    throw new IOException("count!=otherSize");
                }
                changed = true;
            }
            if (changed) {
                ++this.modCount;
            }
            return changed;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf, "index=" + index});
        }
    }

    @Override
    public T remove(int index) {
        try {
            FileListObject old;
            this.frf.seekToExistingRecord(index);
            this.inBuffer.fillFrom((DataInput)this.frf);
            if (this.dataInBuffer.readBoolean()) {
                old = (FileListObject)this.objectFactory.createInstance();
                old.readRecord(this.dataInBuffer);
            } else {
                old = null;
            }
            this.frf.removeRecord(index);
            ++this.modCount;
            return (T)old;
        }
        catch (IOException err) {
            throw new WrappedException((Throwable)err, new Object[]{"frf=" + this.frf, "index=" + index});
        }
    }

    public String getFilenamePrefix() {
        return this.filenamePrefix;
    }

    public String getFilenameExtension() {
        return this.filenameExtension;
    }

    public FileListObjectFactory<T> getObjectFactory() {
        return this.objectFactory;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public void close() throws IOException {
        this.frf.close();
        if (this.file.exists()) {
            FileUtils.delete((File)this.file);
        }
    }

    public static File getTempFile(String prefix, String extension) throws IOException {
        if (extension == null) {
            extension = "tmp";
        }
        File f = File.createTempFile(prefix + '_', '.' + extension);
        f.deleteOnExit();
        return f;
    }
}

