/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.io.FilesystemIterator;
import com.aoindustries.io.FilesystemIteratorRule;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class DirectoryMetaSnapshot {
    private final SortedMap<String, FileMetaSnapshot> files;

    public DirectoryMetaSnapshot(String startPath) throws IOException {
        File file;
        Map<String, FilesystemIteratorRule> noPrefixRules = Collections.emptyMap();
        FilesystemIterator iter = new FilesystemIterator(Collections.singletonMap(startPath, FilesystemIteratorRule.OK), noPrefixRules, startPath);
        String expectedStart = startPath + File.separatorChar;
        TreeMap<String, FileMetaSnapshot> newFiles = new TreeMap<String, FileMetaSnapshot>();
        while ((file = iter.getNextFile()) != null) {
            if (!file.isFile()) continue;
            String path = file.getPath();
            if (!path.startsWith(expectedStart)) {
                throw new AssertionError((Object)("Unexpected start of path: " + path));
            }
            newFiles.put(path.substring(expectedStart.length()), new FileMetaSnapshot(file.lastModified(), file.length()));
        }
        this.files = Collections.unmodifiableSortedMap(newFiles);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DirectoryMetaSnapshot)) {
            return false;
        }
        DirectoryMetaSnapshot other = (DirectoryMetaSnapshot)obj;
        return this.files.equals(other.files);
    }

    public int hashCode() {
        return this.files.hashCode();
    }

    public SortedMap<String, FileMetaSnapshot> getFiles() {
        return this.files;
    }

    public static final class FileMetaSnapshot {
        private final long lastModified;
        private final long length;

        private FileMetaSnapshot(long lastModified, long length) {
            this.lastModified = lastModified;
            this.length = length;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileMetaSnapshot)) {
                return false;
            }
            FileMetaSnapshot other = (FileMetaSnapshot)obj;
            return this.lastModified == other.lastModified && this.length == other.length;
        }

        public int hashCode() {
            return (int)(this.lastModified >>> 32) ^ (int)this.lastModified ^ (int)(this.length >>> 32) ^ (int)this.length;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getLength() {
            return this.length;
        }
    }
}

