/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CompressedDataOutputStream
extends DataOutputStream {
    private String[] lastStrings;
    private int[] lastCommonLengths;

    public CompressedDataOutputStream(OutputStream out) {
        super(out);
    }

    public static void writeCompressedInt(int i, OutputStream out) throws IOException {
        int t = i & 0xFFFFFFF0;
        if (t == 0 || t == -16) {
            out.write(i & 0x1F);
        } else {
            t = i & 0xFFFFF000;
            if (t == 0 || t == -4096) {
                out.write(0x20 | (i & 0x1F00) >>> 8);
                out.write(i & 0xFF);
            } else {
                t = i & 0xFFE00000;
                if (t == 0 || t == -2097152) {
                    out.write(0x40 | (i & 0x3F0000) >>> 16);
                    out.write((i & 0xFF00) >>> 8);
                    out.write(i & 0xFF);
                } else {
                    t = i & 0xC0000000;
                    if (t == 0 || t == -1073741824) {
                        out.write(0x80 | (i & 0x7F000000) >>> 24);
                        out.write((i & 0xFF0000) >>> 16);
                        out.write((i & 0xFF00) >>> 8);
                        out.write(i & 0xFF);
                    } else {
                        throw new IOException("Value out of range (-1073741824 to 1073741823): " + i);
                    }
                }
            }
        }
    }

    public void writeCompressedInt(int i) throws IOException {
        CompressedDataOutputStream.writeCompressedInt(i, this.out);
    }

    public void writeCompressedUTF(String str) throws IOException {
        this.writeCompressedUTF(str, 0);
    }

    public void writeCompressedUTF(String str, int slot) throws IOException {
        int commonDifference;
        int common;
        String last;
        if (slot < 0 || slot > 63) {
            throw new IOException("Slot out of range (0-63): " + slot);
        }
        if (this.lastStrings == null) {
            this.lastStrings = new String[64];
        }
        if ((last = this.lastStrings[slot]) == null) {
            last = "";
        }
        int strLen = str.length();
        int lastLen = last.length();
        int maxCommon = Math.min(strLen, lastLen);
        for (common = 0; common < maxCommon && str.charAt(common) == last.charAt(common); ++common) {
        }
        if (this.lastCommonLengths == null) {
            this.lastCommonLengths = new int[64];
        }
        this.out.write(((commonDifference = common - this.lastCommonLengths[slot]) == 0 ? 0 : 128) | (common == strLen ? 0 : 64) | slot);
        if (commonDifference > 0) {
            this.writeCompressedInt(commonDifference - 1);
        } else if (commonDifference < 0) {
            this.writeCompressedInt(commonDifference);
        }
        if (common != strLen) {
            this.writeUTF(str.substring(common));
        }
        this.lastStrings[slot] = str;
        this.lastCommonLengths[slot] = common;
    }

    public void writeNullUTF(String str) throws IOException {
        this.writeBoolean(str != null);
        if (str != null) {
            this.writeUTF(str);
        }
    }

    public void writeLongUTF(String str) throws IOException {
        int length = str.length();
        this.writeCompressedInt(length);
        for (int position = 0; position < length; position += 20480) {
            int blockLength = length - position;
            if (blockLength > 20480) {
                blockLength = 20480;
            }
            String block = str.substring(position, position + blockLength);
            this.writeUTF(block);
        }
    }

    public void writeNullLongUTF(String str) throws IOException {
        this.writeBoolean(str != null);
        if (str != null) {
            this.writeLongUTF(str);
        }
    }

    public void writeNullInteger(Integer i) throws IOException {
        this.writeBoolean(i != null);
        if (i != null) {
            this.writeInt(i);
        }
    }

    public void writeNullLong(Long l) throws IOException {
        this.writeBoolean(l != null);
        if (l != null) {
            this.writeLong(l);
        }
    }

    public void writeEnum(Enum<?> e) throws IOException {
        this.writeUTF(e.name());
    }

    public void writeNullEnum(Enum<?> e) throws IOException {
        this.writeBoolean(e != null);
        if (e != null) {
            this.writeUTF(e.name());
        }
    }
}

