/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class CompressedDataInputStream
extends DataInputStream {
    private String[] lastStrings;
    private int[] lastCommonLengths;

    public CompressedDataInputStream(InputStream in) {
        super(in);
    }

    public static int readCompressedInt(InputStream in) throws IOException {
        int b1 = in.read();
        if (b1 == -1) {
            throw new EOFException();
        }
        if ((b1 & 0x80) != 0) {
            int b2 = in.read();
            if (b2 == -1) {
                throw new EOFException();
            }
            int b3 = in.read();
            if (b3 == -1) {
                throw new EOFException();
            }
            int b4 = in.read();
            if (b4 == -1) {
                throw new EOFException();
            }
            return ((b1 & 0x40) == 0 ? 0 : -1073741824) | (b1 & 0x3F) << 24 | b2 << 16 | b3 << 8 | b4;
        }
        if ((b1 & 0x40) != 0) {
            int b2 = in.read();
            if (b2 == -1) {
                throw new EOFException();
            }
            int b3 = in.read();
            if (b3 == -1) {
                throw new EOFException();
            }
            return ((b1 & 0x20) == 0 ? 0 : -2097152) | (b1 & 0x1F) << 16 | b2 << 8 | b3;
        }
        if ((b1 & 0x20) != 0) {
            int b2 = in.read();
            if (b2 == -1) {
                throw new EOFException();
            }
            return ((b1 & 0x10) == 0 ? 0 : -4096) | (b1 & 0xF) << 8 | b2;
        }
        return ((b1 & 0x10) == 0 ? 0 : -16) | b1 & 0xF;
    }

    public int readCompressedInt() throws IOException {
        return CompressedDataInputStream.readCompressedInt(this.in);
    }

    public String readCompressedUTF() throws IOException {
        int b1 = this.in.read();
        if (b1 == -1) {
            throw new EOFException();
        }
        int slot = b1 & 0x3F;
        if (this.lastCommonLengths == null) {
            this.lastCommonLengths = new int[64];
        }
        if ((b1 & 0x80) != 0) {
            int diff = this.readCompressedInt();
            if (diff >= 0) {
                ++diff;
            }
            int n = slot;
            this.lastCommonLengths[n] = this.lastCommonLengths[n] + diff;
        }
        int common = this.lastCommonLengths[slot];
        if (this.lastStrings == null) {
            this.lastStrings = new String[64];
        }
        if ((b1 & 0x40) != 0) {
            String combined;
            String suffix = this.readUTF();
            if (common == 0) {
                this.lastStrings[slot] = suffix;
                return this.lastStrings[slot];
            }
            String last = this.lastStrings[slot];
            if (last == null) {
                last = "";
            }
            this.lastStrings[slot] = combined = new StringBuilder(common + suffix.length()).append(last, 0, common).append(suffix).toString();
            return combined;
        }
        String last = this.lastStrings[slot];
        if (last == null) {
            last = "";
        }
        if (common == last.length()) {
            return last;
        }
        this.lastStrings[slot] = last.substring(0, common);
        return this.lastStrings[slot];
    }

    public String readNullUTF() throws IOException {
        return this.readBoolean() ? this.readUTF() : null;
    }

    public String readLongUTF() throws IOException {
        int length = this.readCompressedInt();
        StringBuilder SB = new StringBuilder(length);
        for (int position = 0; position < length; position += 20480) {
            String block;
            int expectedLen = length - position;
            if (expectedLen > 20480) {
                expectedLen = 20480;
            }
            if ((block = this.readUTF()).length() != expectedLen) {
                throw new IOException("Block has unexpected length: expected " + expectedLen + ", got " + block.length());
            }
            SB.append(block);
        }
        if (SB.length() != length) {
            throw new IOException("StringBuilder has unexpected length: expected " + length + ", got " + SB.length());
        }
        return SB.toString();
    }

    public String readNullLongUTF() throws IOException {
        return this.readBoolean() ? this.readLongUTF() : null;
    }

    public Integer readNullInteger() throws IOException {
        return this.readBoolean() ? Integer.valueOf(this.readInt()) : null;
    }

    public Long readNullLong() throws IOException {
        return this.readBoolean() ? Long.valueOf(this.readLong()) : null;
    }

    public <T extends Enum<T>> T readEnum(Class<T> enumType) throws IOException {
        try {
            return Enum.valueOf(enumType, this.readUTF());
        }
        catch (IllegalArgumentException err) {
            throw new IOException(err);
        }
    }

    public <T extends Enum<T>> T readNullEnum(Class<T> enumType) throws IOException {
        try {
            return this.readBoolean() ? (T)Enum.valueOf(enumType, this.readUTF()) : null;
        }
        catch (IllegalArgumentException err) {
            throw new IOException(err);
        }
    }
}

