/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.math.Statistics;
import com.aoindustries.util.BufferManager;
import com.aoindustries.util.ErrorPrinter;
import com.aoindustries.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Benchmark {
    private static final long MAX_READ_BYTES = 0x100000000L;
    private static final int[] blockSizes = new int[]{512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
    private static final int[] concurrencies = new int[]{1, 2, 3, 4, 6, 8, 12, 16, 24, 32, 48, 64};

    private Benchmark() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void benchmark(int pass, String[] args, List<List<List<Double>>> throughputs, List<List<List<Double>>> seekRates, NumberFormat numberFormat) {
        System.out.print("Pass #");
        System.out.println(pass);
        System.out.println();
        for (int c = 1; c < args.length; ++c) {
            List<List<Double>> fileThroughputs = throughputs.get(c - 1);
            List<List<Double>> fileSeekRates = seekRates.get(c - 1);
            String filename = args[c];
            final File file = new File(filename);
            System.out.print("Sequential Read by Block Size (");
            System.out.print(StringUtility.getApproximateSize(0x100000000L));
            System.out.println(" Total)");
            block14: for (int ci = 0; ci < blockSizes.length; ++ci) {
                long bytesRead;
                List<Double> blockSizeThroughputs = fileThroughputs.get(ci);
                int blockSize = blockSizes[ci];
                byte[] buff = new byte[blockSize];
                long startTime = System.currentTimeMillis();
                try {
                    FileInputStream in = new FileInputStream(file);
                    try {
                        int ret;
                        for (bytesRead = 0L; bytesRead < 0x100000000L; bytesRead += (long)ret) {
                            long bytesLeft = 0x100000000L - bytesRead;
                            int len = bytesLeft < (long)blockSize ? (int)bytesLeft : blockSize;
                            ret = ((InputStream)in).read(buff, 0, len);
                            if (ret != -1) continue;
                            continue block14;
                        }
                        continue;
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException err) {
                    ErrorPrinter.printStackTraces((Throwable)err);
                    continue;
                }
                finally {
                    long timeSpan = System.currentTimeMillis() - startTime;
                    if (bytesRead != 0x100000000L) {
                        System.err.println("Incorrect number of bytes read.  Expected 4294967296, got " + bytesRead);
                    }
                    double throughput = (double)bytesRead * 1000.0 / ((double)timeSpan * 1048576.0);
                    blockSizeThroughputs.add(throughput);
                    System.out.print("    ");
                    System.out.print(StringUtility.getApproximateSize(blockSize));
                    System.out.print(": ");
                    System.out.print(numberFormat.format(throughput));
                    System.out.print(" MB/sec");
                    if (blockSizeThroughputs.size() > 1) {
                        System.out.print(" (");
                        System.out.print(numberFormat.format(Collections.min(blockSizeThroughputs)));
                        System.out.print(", ");
                        double mean = Statistics.mean(blockSizeThroughputs);
                        System.out.print(numberFormat.format(mean));
                        System.out.print('\u00b1');
                        System.out.print(numberFormat.format(Statistics.standardDeviation((double)mean, blockSizeThroughputs)));
                        System.out.print(", ");
                        System.out.print(numberFormat.format(Collections.max(blockSizeThroughputs)));
                        System.out.print(')');
                    }
                    System.out.println();
                }
            }
            System.out.println("Random Seek by Concurrency (4 kB Blocks)");
            final byte[] buff = BufferManager.getBytes();
            try {
                for (int ci = 0; ci < concurrencies.length; ++ci) {
                    int d;
                    List<Double> concurrencySeekRates = fileSeekRates.get(ci);
                    int concurrency = concurrencies[ci];
                    final int[] counter = new int[1];
                    Thread[] threads = new Thread[concurrency];
                    for (d = 0; d < concurrency; ++d) {
                        Thread T = threads[d] = new Thread(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                int count = 0;
                                try {
                                    RandomAccessFile raf = new RandomAccessFile(file, "r");
                                    long length = raf.length();
                                    try {
                                        long endTime = System.currentTimeMillis() + 30000L;
                                        while (System.currentTimeMillis() < endTime) {
                                            raf.seek((long)(Math.random() * (double)(length - 4096L)));
                                            raf.read(buff, 0, 4096);
                                            ++count;
                                        }
                                    }
                                    finally {
                                        raf.close();
                                    }
                                }
                                catch (IOException err) {
                                    ErrorPrinter.printStackTraces((Throwable)err);
                                }
                                int[] nArray = counter;
                                synchronized (counter) {
                                    counter[0] = counter[0] + count;
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                            }
                        };
                        T.start();
                    }
                    for (d = 0; d < concurrency; ++d) {
                        try {
                            threads[d].join();
                            continue;
                        }
                        catch (InterruptedException err) {
                            ErrorPrinter.printStackTraces((Throwable)err);
                            Thread.currentThread().interrupt();
                        }
                    }
                    double seekRate = (double)counter[0] / 30.0;
                    concurrencySeekRates.add(seekRate);
                    System.out.print("    ");
                    System.out.print(concurrency);
                    System.out.print(": ");
                    System.out.print(numberFormat.format(seekRate));
                    System.out.print(" seeks/sec");
                    if (concurrencySeekRates.size() > 1) {
                        System.out.print(" (");
                        System.out.print(numberFormat.format(Collections.min(concurrencySeekRates)));
                        System.out.print(", ");
                        double mean = Statistics.mean(concurrencySeekRates);
                        System.out.print(numberFormat.format(mean));
                        System.out.print('\u00b1');
                        System.out.print(numberFormat.format(Statistics.standardDeviation((double)mean, concurrencySeekRates)));
                        System.out.print(", ");
                        System.out.print(numberFormat.format(Collections.max(concurrencySeekRates)));
                        System.out.print(')');
                    }
                    System.out.println();
                }
                continue;
            }
            finally {
                BufferManager.release((byte[])buff, (boolean)false);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(3);
            numberFormat.setMaximumFractionDigits(3);
            int numPasses = Integer.parseInt(args[0]);
            int numFiles = args.length - 1;
            ArrayList<List<List<Double>>> throughputs = new ArrayList<List<List<Double>>>(numFiles);
            ArrayList<List<List<Double>>> seekRates = new ArrayList<List<List<Double>>>(numFiles);
            for (int c = 0; c < numFiles; ++c) {
                ArrayList fileThroughputs = new ArrayList(blockSizes.length);
                for (int d = 0; d < blockSizes.length; ++d) {
                    fileThroughputs.add(new ArrayList(numPasses));
                }
                throughputs.add(fileThroughputs);
                ArrayList fileSeekRates = new ArrayList(concurrencies.length);
                for (int d = 0; d < concurrencies.length; ++d) {
                    fileSeekRates.add(new ArrayList(numPasses));
                }
                seekRates.add(fileSeekRates);
            }
            for (int pass = 1; pass <= numPasses; ++pass) {
                if (pass > 1) {
                    System.out.println();
                }
                Benchmark.benchmark(pass, args, throughputs, seekRates, numberFormat);
            }
        } else {
            System.err.println("Usage: Benchmark num_passes filename [filename] [...]");
            System.exit(1);
        }
    }
}

