/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.io;

import com.aoindustries.util.EncodingUtils;
import com.aoindustries.util.ErrorPrinter;
import com.aoindustries.util.StringUtility;
import com.aoindustries.util.WrappedExceptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AOPool<C, E extends Exception, I extends Exception>
extends Thread {
    public static final int DEFAULT_DELAY_TIME = 60000;
    public static final int DEFAULT_MAX_IDLE_TIME = 600000;
    public static final long UNLIMITED_MAX_CONNECTION_AGE = -1L;
    public static final long DEFAULT_MAX_CONNECTION_AGE = 1800000L;
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    public static final int DEFAULT_SOCKET_SO_LINGER = 15;
    private final int delayTime;
    private final int maxIdleTime;
    private final long startTime;
    private final int poolSize;
    private final long maxConnectionAge;
    private final PoolLock poolLock = new PoolLock();
    private final List<PooledConnection<C>> allConnections;
    private final PriorityQueue<PooledConnection<C>> availableConnections;
    private final Set<PooledConnection<C>> busyConnections;
    private boolean isClosed = false;
    private int maxConcurrency = 0;
    private final ThreadLocal<List<PooledConnection<C>>> currentThreadConnections = new ThreadLocal<List<PooledConnection<C>>>(){

        @Override
        public List<PooledConnection<C>> initialValue() {
            return new ArrayList();
        }
    };
    protected final Logger logger;

    protected AOPool(String name, int poolSize, long maxConnectionAge, Logger logger) {
        this(60000, 600000, name, poolSize, maxConnectionAge, logger);
    }

    protected AOPool(int delayTime, int maxIdleTime, String name, int poolSize, long maxConnectionAge, Logger logger) {
        super(name + "&delayTime=" + delayTime + "&maxIdleTime=" + maxIdleTime + "&size=" + poolSize + "&maxConnectionAge=" + (maxConnectionAge == -1L ? "Unlimited" : Long.toString(maxConnectionAge)));
        this.delayTime = delayTime;
        this.maxIdleTime = maxIdleTime;
        this.startTime = System.currentTimeMillis();
        this.setPriority(5);
        this.setDaemon(true);
        this.poolSize = poolSize;
        this.maxConnectionAge = maxConnectionAge;
        if (logger == null) {
            throw new IllegalArgumentException("logger is null");
        }
        this.logger = logger;
        this.allConnections = new ArrayList<PooledConnection<C>>(poolSize);
        this.availableConnections = new PriorityQueue(poolSize);
        this.busyConnections = new HashSet<PooledConnection<C>>(poolSize * 4 / 3 + 1);
        this.start();
    }

    protected abstract void close(C var1) throws E;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        ArrayList connsToClose;
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            this.isClosed = true;
            connsToClose = new ArrayList(this.availableConnections.size());
            Iterator<PooledConnection<C>> iterator = this.availableConnections.iterator();
            while (iterator.hasNext()) {
                PooledConnection<C> availableConnection;
                PooledConnection<C> pooledConnection = availableConnection = iterator.next();
                synchronized (pooledConnection) {
                    Object conn = availableConnection.connection;
                    if (conn != null) {
                        availableConnection.connection = null;
                        connsToClose.add(conn);
                    }
                }
            }
            this.poolLock.notifyAll();
        }
        for (Object conn : connsToClose) {
            try {
                this.close(conn);
            }
            catch (Exception err) {
                this.logger.log(Level.WARNING, null, err);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConcurrency() {
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            return this.busyConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConnectionCount() {
        int total = 0;
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            for (PooledConnection<C> pooledConnection : this.allConnections) {
                if (pooledConnection.connection == null) continue;
                ++total;
            }
        }
        return total;
    }

    public C getConnection() throws I, E {
        return this.getConnection(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public C getConnection(int maxConnections) throws I, E {
        if (Thread.interrupted()) {
            throw this.newInterruptedException(null, null);
        }
        Thread thisThread = Thread.currentThread();
        List<PooledConnection<C>> threadConnections = this.currentThreadConnections.get();
        int useCount = threadConnections.size();
        if (useCount >= maxConnections) {
            Throwable[] allocateStackTraces = new Throwable[useCount];
            for (int c = 0; c < useCount; ++c) {
                PooledConnection<C> threadConnection = threadConnections.get(c);
                allocateStackTraces[c] = threadConnection.allocateStackTrace;
            }
            if (useCount >= this.poolSize / 2) {
                throw this.newException("Thread attempting to allocate more than half of the connection pool: " + thisThread.toString(), (Throwable)new WrappedExceptions(allocateStackTraces));
            }
            this.logger.logp(Level.WARNING, AOPool.class.getName(), "getConnection", null, (Throwable)new WrappedExceptions("Warning: Thread allocated more than " + maxConnections + " " + (maxConnections == 1 ? "connection" : "connections") + ".  The stack trace at allocation time is included.", allocateStackTraces));
        }
        PooledConnection pooledConnection = null;
        PoolLock c = this.poolLock;
        synchronized (c) {
            try {
                while (pooledConnection == null) {
                    if (Thread.interrupted()) {
                        throw this.newInterruptedException(null, null);
                    }
                    if (this.allConnections.size() != this.availableConnections.size() + this.busyConnections.size()) {
                        throw new AssertionError((Object)"allConnections.size!=(availableConnections.size+busyConnections.size)");
                    }
                    if (this.isClosed) {
                        throw this.newException("Pool is closed", null);
                    }
                    if (!this.availableConnections.isEmpty()) {
                        pooledConnection = (PooledConnection)this.availableConnections.remove();
                        this.busyConnections.add(pooledConnection);
                        continue;
                    }
                    if (this.allConnections.size() < this.poolSize) {
                        pooledConnection = new PooledConnection();
                        this.allConnections.add(pooledConnection);
                        this.busyConnections.add(pooledConnection);
                        continue;
                    }
                    try {
                        this.poolLock.wait();
                    }
                    catch (InterruptedException err) {
                        Thread.currentThread().interrupt();
                        throw this.newInterruptedException(null, err);
                    }
                }
                int concurrency = this.busyConnections.size();
                if (concurrency > this.maxConcurrency) {
                    this.maxConcurrency = concurrency;
                }
            }
            finally {
                this.poolLock.notify();
            }
        }
        threadConnections.add(pooledConnection);
        boolean successful = false;
        try {
            boolean doReset;
            PooledConnection pooledConnection2;
            Object conn;
            long currentTime = System.currentTimeMillis();
            PooledConnection pooledConnection3 = pooledConnection;
            synchronized (pooledConnection3) {
                pooledConnection.startTime = currentTime;
                conn = pooledConnection.connection;
            }
            if (conn == null || this.isClosed(conn)) {
                boolean myIsClosed;
                conn = this.getConnectionObject();
                pooledConnection2 = this.poolLock;
                synchronized (pooledConnection2) {
                    myIsClosed = this.isClosed;
                }
                if (myIsClosed) {
                    this.close(conn);
                    throw this.newException("Pool is closed", null);
                }
                pooledConnection2 = pooledConnection;
                synchronized (pooledConnection2) {
                    pooledConnection.connection = conn;
                    pooledConnection.createTime = currentTime;
                    pooledConnection.connectCount.incrementAndGet();
                }
                doReset = true;
            } else {
                doReset = false;
            }
            Throwable allocateStackTrace = new Throwable("StackTrace at getConnection(" + maxConnections + ") for Thread named \"" + thisThread.getName() + "\"");
            pooledConnection2 = pooledConnection;
            synchronized (pooledConnection2) {
                pooledConnection.releaseTime = 0L;
                pooledConnection.useCount.incrementAndGet();
                pooledConnection.allocateStackTrace = allocateStackTrace;
            }
            if (doReset) {
                this.resetConnection(conn);
            }
            successful = true;
            pooledConnection2 = conn;
            return (C)pooledConnection2;
        }
        finally {
            if (!successful) {
                try {
                    Object conn;
                    PooledConnection pooledConnection4 = pooledConnection;
                    synchronized (pooledConnection4) {
                        conn = pooledConnection.connection;
                        pooledConnection.connection = null;
                    }
                    if (conn != null) {
                        try {
                            this.close(conn);
                        }
                        catch (Exception err) {
                            this.logger.log(Level.WARNING, null, err);
                        }
                    }
                }
                finally {
                    threadConnections.remove(pooledConnection);
                    this.release(pooledConnection);
                }
            }
        }
    }

    protected abstract C getConnectionObject() throws I, E;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(PooledConnection<C> pooledConnection) {
        long currentTime = System.currentTimeMillis();
        Object object = pooledConnection;
        synchronized (object) {
            pooledConnection.releaseTime = currentTime;
            long useTime = currentTime - pooledConnection.startTime;
            if (useTime > 0L) {
                pooledConnection.totalTime.addAndGet(useTime);
            }
            pooledConnection.allocateStackTrace = null;
        }
        object = this.poolLock;
        synchronized (object) {
            try {
                if (this.busyConnections.remove(pooledConnection)) {
                    this.availableConnections.add(pooledConnection);
                }
            }
            finally {
                this.poolLock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getConnects() {
        long total = 0L;
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            for (PooledConnection<C> conn : this.allConnections) {
                total += conn.connectCount.get();
            }
        }
        return total;
    }

    public final long getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxConcurrency() {
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            return this.maxConcurrency;
        }
    }

    public final int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTotalTime() {
        long total = 0L;
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            for (PooledConnection<C> conn : this.allConnections) {
                total += conn.totalTime.get();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTransactionCount() {
        long total = 0L;
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            for (PooledConnection<C> conn : this.allConnections) {
                total += conn.useCount.get();
            }
        }
        return total;
    }

    protected abstract boolean isClosed(C var1) throws E;

    protected abstract void printConnectionStats(Appendable var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void printStatisticsHTML(Appendable out) throws IOException, E {
        Throwable[] allocateStackTraces;
        long[] releaseTimes;
        long[] startTimes;
        boolean[] isBusies;
        long[] totalTimes;
        long[] useCounts;
        long[] connectCounts;
        long[] createTimes;
        boolean[] isConnecteds;
        int numConnections;
        boolean myIsClosed;
        PoolLock poolLock = this.poolLock;
        synchronized (poolLock) {
            myIsClosed = this.isClosed;
        }
        PoolLock poolLock2 = this.poolLock;
        synchronized (poolLock2) {
            numConnections = this.allConnections.size();
            isConnecteds = new boolean[numConnections];
            createTimes = new long[numConnections];
            connectCounts = new long[numConnections];
            useCounts = new long[numConnections];
            totalTimes = new long[numConnections];
            isBusies = new boolean[numConnections];
            startTimes = new long[numConnections];
            releaseTimes = new long[numConnections];
            allocateStackTraces = new Throwable[numConnections];
            for (int c = 0; c < numConnections; ++c) {
                PooledConnection<C> pooledConnection = this.allConnections.get(c);
                isConnecteds[c] = pooledConnection.connection != null;
                createTimes[c] = pooledConnection.createTime;
                connectCounts[c] = pooledConnection.connectCount.get();
                useCounts[c] = pooledConnection.useCount.get();
                totalTimes[c] = pooledConnection.totalTime.get();
                isBusies[c] = this.busyConnections.contains(pooledConnection);
                startTimes[c] = pooledConnection.startTime;
                releaseTimes[c] = pooledConnection.releaseTime;
                allocateStackTraces[c] = pooledConnection.allocateStackTrace;
            }
        }
        long time = System.currentTimeMillis();
        long timeLen = time - this.startTime;
        out.append("<table style='border:1px;' cellspacing='0' cellpadding='2'>\n");
        this.printConnectionStats(out);
        out.append("  <tr><td>Max Connection Pool Size:</td><td>").append(Integer.toString(this.poolSize)).append("</td></tr>\n  <tr><td>Connection Clean Interval:</td><td>");
        EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(this.delayTime), out);
        out.append("</td></tr>\n  <tr><td>Max Idle Time:</td><td>");
        EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(this.maxIdleTime), out);
        out.append("</td></tr>\n  <tr><td>Max Connection Age:</td><td>");
        EncodingUtils.encodeHtml(this.maxConnectionAge == -1L ? "Unlimited" : StringUtility.getDecimalTimeLengthString(this.maxConnectionAge), out);
        out.append("</td></tr>\n  <tr><td>Is Closed:</td><td>").append(Boolean.toString(myIsClosed)).append("</td></tr>\n</table>\n<br /><br />\n<table style='border:1px;' cellspacing='0' cellpadding='2'>\n  <tr><th colspan='11'><span style='font-size:large;'>Connections</span></th></tr>\n  <tr>\n    <th>Connection #</th>\n    <th>Is Connected</th>\n    <th>Conn Age</th>\n    <th>Conn Count</th>\n    <th>Use Count</th>\n    <th>Total Time</th>\n    <th>% of Time</th>\n    <th>State</th>\n    <th>State Time</th>\n    <th>Ave Trans Time</th>\n    <th>Stack Trace</th>\n  </tr>\n");
        int totalConnected = 0;
        long totalConnects = 0L;
        long totalUses = 0L;
        long totalTotalTime = 0L;
        int totalBusy = 0;
        for (int c = 0; c < numConnections; ++c) {
            long connCount = connectCounts[c];
            boolean isConnected = isConnecteds[c];
            long useCount = useCounts[c];
            long totalTime = totalTimes[c];
            boolean isBusy = isBusies[c];
            if (isBusy) {
                totalTime += time - startTimes[c];
            }
            long stateTime = isBusy ? time - startTimes[c] : time - releaseTimes[c];
            out.append("  <tr>\n    <td>").append(Integer.toString(c + 1)).append("</td>\n    <td>").append(isConnected ? "Yes" : "No").append("</td>\n    <td>");
            if (isConnected) {
                EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(time - createTimes[c]), out);
            } else {
                out.append("&#160;");
            }
            out.append("    <td>").append(Long.toString(connCount)).append("</td>\n    <td>").append(Long.toString(useCount)).append("</td>\n    <td>");
            EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(totalTime), out);
            out.append("</td>\n    <td>").append(Float.toString((float)(totalTime * 100L) / (float)timeLen)).append("%</td>\n    <td>").append(isBusy ? "In Use" : (isConnected ? "Idle" : "Closed")).append("</td>\n    <td>");
            EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(stateTime), out);
            out.append("</td>\n    <td>").append(Long.toString(totalTime * 1000L / useCount)).append("&#181;s</td>\n    <td>");
            Throwable T = allocateStackTraces[c];
            if (T == null) {
                out.append("&#160;");
            } else {
                out.append("      <a href='#' onclick='var elem = document.getElementById(\"stack_").append(Integer.toString(c)).append("\").style; elem.visibility=(elem.visibility==\"visible\" ? \"hidden\" : \"visible\"); return false;'>Stack Trace</a>\n      <span id='stack_").append(Integer.toString(c)).append("' style='text-align:left; white-space:nowrap; position:absolute; visibility: hidden; z-index:").append(Integer.toString(c + 1)).append("'>\n        <pre style='text-align:left; background-color:white; border: 2px solid; border-color: black;'>\n");
                ErrorPrinter.printStackTraces((Throwable)T, (Appendable)out);
                out.append("        </pre>\n      </span>\n");
            }
            out.append("</td>\n  </tr>\n");
            if (isConnected) {
                ++totalConnected;
            }
            totalConnects += connCount;
            totalUses += useCount;
            totalTotalTime += totalTime;
            if (!isBusy) continue;
            ++totalBusy;
        }
        out.append("  <tr>\n    <td><b>Total</b></td>\n    <td>").append(Integer.toString(totalConnected)).append("</td>\n    <td>&#160;</td>\n    <td>").append(Long.toString(totalConnects)).append("</td>\n    <td>").append(Long.toString(totalUses)).append("</td>\n    <td>");
        EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(totalTotalTime), out);
        out.append("</td>\n    <td>").append(Float.toString(timeLen == 0L ? 0.0f : (float)(totalTotalTime * 100L) / (float)timeLen)).append("%</td>\n    <td>").append(Integer.toString(totalBusy)).append("</td>\n    <td>");
        EncodingUtils.encodeHtml(StringUtility.getDecimalTimeLengthString(timeLen), out);
        out.append("</td>\n    <td>").append(Long.toString(totalUses == 0L ? 0L : totalTotalTime * 1000L / totalUses)).append("&#181;s</td>\n    <td>&#160;</td>\n  </tr>\n</table>\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseConnection(C connection) throws E {
        block30: {
            PooledConnection<C> pooledConnection = null;
            List<PooledConnection<C>> threadConnections = this.currentThreadConnections.get();
            for (int c = threadConnections.size() - 1; c >= 0; --c) {
                PooledConnection<C> threadConnection;
                PooledConnection<C> pooledConnection2 = threadConnection = threadConnections.get(c);
                synchronized (pooledConnection2) {
                    if (threadConnection.connection == connection) {
                        pooledConnection = threadConnection;
                        threadConnections.remove(c);
                        break;
                    }
                    continue;
                }
            }
            if (pooledConnection == null) {
                this.logger.log(Level.WARNING, "PooledConnection not found during releaseConnection");
            } else {
                try {
                    long age;
                    boolean connIsClosed;
                    boolean closeConnection = false;
                    try {
                        connIsClosed = this.isClosed(connection);
                    }
                    catch (Exception err) {
                        this.logger.log(Level.SEVERE, null, err);
                        connIsClosed = false;
                        closeConnection = true;
                    }
                    if (connIsClosed) {
                        PooledConnection<C> err = pooledConnection;
                        synchronized (err) {
                            pooledConnection.connection = null;
                            break block30;
                        }
                    }
                    if (this.maxConnectionAge != -1L && ((age = System.currentTimeMillis() - pooledConnection.createTime) < 0L || age >= this.maxConnectionAge)) {
                        closeConnection = true;
                    }
                    if (closeConnection) {
                        try {
                            this.close(connection);
                        }
                        catch (Exception err) {
                            this.logger.log(Level.SEVERE, null, err);
                        }
                        PooledConnection<C> err = pooledConnection;
                        synchronized (err) {
                            pooledConnection.connection = null;
                            break block30;
                        }
                    }
                    try {
                        this.resetConnection(connection);
                    }
                    catch (Exception err) {
                        this.logger.log(Level.SEVERE, null, err);
                        try {
                            this.close(connection);
                        }
                        catch (Exception err2) {
                            this.logger.log(Level.SEVERE, null, err2);
                        }
                        PooledConnection<C> pooledConnection3 = pooledConnection;
                        synchronized (pooledConnection3) {
                            pooledConnection.connection = null;
                        }
                    }
                }
                finally {
                    this.release(pooledConnection);
                }
            }
        }
    }

    protected abstract void resetConnection(C var1) throws I, E;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            try {
                block14: while (true) {
                    ArrayList connsToClose;
                    try {
                        AOPool.sleep(this.delayTime);
                    }
                    catch (InterruptedException err) {
                        this.logger.log(Level.WARNING, null, err);
                        Thread.currentThread().interrupt();
                    }
                    long time = System.currentTimeMillis();
                    Object object = this.poolLock;
                    synchronized (object) {
                        if (this.isClosed) {
                            return;
                        }
                        int maxIdle = this.maxIdleTime;
                        connsToClose = new ArrayList(this.availableConnections.size());
                        Iterator<PooledConnection<C>> iterator = this.availableConnections.iterator();
                        while (iterator.hasNext()) {
                            PooledConnection<C> availableConnection;
                            PooledConnection<C> pooledConnection = availableConnection = iterator.next();
                            synchronized (pooledConnection) {
                                Object conn = availableConnection.connection;
                                if (conn != null && (time - availableConnection.releaseTime > (long)maxIdle || this.maxConnectionAge != -1L && (availableConnection.createTime > time || time - availableConnection.createTime >= this.maxConnectionAge))) {
                                    availableConnection.connection = null;
                                    connsToClose.add(conn);
                                }
                            }
                        }
                    }
                    object = connsToClose.iterator();
                    while (true) {
                        if (!object.hasNext()) continue block14;
                        Object conn = object.next();
                        try {
                            this.close(conn);
                        }
                        catch (Exception err) {
                            this.logger.log(Level.WARNING, null, err);
                        }
                    }
                    break;
                }
            }
            catch (ThreadDeath TD) {
                throw TD;
            }
            catch (Throwable T) {
                this.logger.logp(Level.SEVERE, AOPool.class.getName(), "run", null, T);
                continue;
            }
            break;
        }
    }

    protected abstract E newException(String var1, Throwable var2);

    protected abstract I newInterruptedException(String var1, Throwable var2);

    public final Logger getLogger() {
        return this.logger;
    }

    private static class PoolLock {
        private PoolLock() {
        }
    }

    private static class PooledConnection<C>
    implements Comparable<PooledConnection<C>> {
        private static final AtomicLong nextId = new AtomicLong(0L);
        final long id = nextId.getAndIncrement();
        volatile C connection;
        volatile long createTime;
        final AtomicLong totalTime = new AtomicLong();
        volatile long startTime;
        volatile long releaseTime;
        final AtomicLong connectCount = new AtomicLong();
        final AtomicLong useCount = new AtomicLong();
        volatile Throwable allocateStackTrace;

        private PooledConnection() {
        }

        @Override
        public int compareTo(PooledConnection<C> o) {
            if (this.id < o.id) {
                return -1;
            }
            if (this.id > o.id) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object O) {
            return O != null && O instanceof PooledConnection && this.id == ((PooledConnection)O).id;
        }

        public int hashCode() {
            return (int)(this.id ^ this.id >>> 32);
        }
    }
}

